/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IVariableStatusListener;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.collect.StackEx;
import org.eclipse.sirius.query.legacy.AcceleoInterpreterPlugin;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoCompletionEntry;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoTemplateWorkspaceListener;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.ENodeHelper;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.template.Template;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.scripts.SpecificScript;
import org.eclipse.sirius.query.legacy.tools.classloaders.AcceleoClassLoader;

public abstract class AcceleoInterpreter
implements IInterpreter,
IInterpreterProvider,
IProposalProvider {
    protected static final String VARIABLE_KEYWORD = "$";
    protected static final String PREFIX_KEYWORD = "<%";
    protected static final String SUFFIX_KEYWORD = "%>";
    protected final Map<SpecificScript, Map<String, Template>> templates = new HashMap<SpecificScript, Map<String, Template>>();
    protected SpecificScript pvScript;
    protected final Map<String, StackEx<ENode>> variableTables = new HashMap<String, StackEx<ENode>>();
    protected Map<String, SpecificScript> mmToScript = new WeakHashMap<String, SpecificScript>();
    private final Collection<String> imports = new LinkedHashSet<String>();
    private final Set<IVariableStatusListener> variablesListeners = new HashSet<IVariableStatusListener>();
    private Map<CacheKey, ENode> cache;
    private AcceleoTemplateWorkspaceListener templateListener;

    public AcceleoInterpreter() {
        this.installWorkspaceListener();
        TemplateConstants.initConstants();
    }

    protected final SpecificScript getScript(EObject current) {
        String mmURI = this.computeMetamodelURI(current);
        SpecificScript resultScript = this.mmToScript.get(mmURI);
        if (resultScript != null) {
            return resultScript;
        }
        SpecificScript newScript = this.createNewScript(current, mmURI);
        this.mmToScript.put(mmURI, newScript);
        return newScript;
    }

    protected abstract SpecificScript createNewScript(EObject var1, String var2);

    public Object evaluate(EObject target, String expression) throws EvaluationException {
        ENode node = this.evaluateENode(target, expression);
        return this.getValue(node, expression);
    }

    public ENode evaluateENode(EObject eObj, String expression) throws EvaluationException {
        try {
            AcceleoClassLoader.setPreferredClassLoader(eObj.getClass().getClassLoader());
            SpecificScript script = this.getScript(eObj);
            Template template = null;
            if (expression != null && expression.trim().length() > 0) {
                Map<String, Template> scriptTemplates = this.templates.get(script);
                if (scriptTemplates != null && scriptTemplates.containsKey(expression)) {
                    template = scriptTemplates.get(expression);
                } else {
                    template = Template.from(expression, script, eObj);
                    if (scriptTemplates == null) {
                        scriptTemplates = new WeakHashMap<String, Template>();
                        this.templates.put(script, scriptTemplates);
                    }
                    scriptTemplates.put(expression, template);
                }
            }
            if (template != null) {
                return template.evaluate(eObj, LaunchManager.create("run", false));
            }
            AcceleoClassLoader.setPreferredClassLoader(null);
            return new ENode(null, null, true);
        }
        catch (ENodeException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (FactoryException e) {
            throw new EvaluationException((Throwable)e);
        }
    }

    @Deprecated
    public boolean evaluateCondition(EObject eObj, String condition) throws EvaluationException {
        return true;
    }

    protected String getScriptHeader(String metamodelURI) {
        StringBuffer header = new StringBuffer("");
        header.append(TemplateConstants.IMPORT_BEGIN).append("\n");
        header.append(TemplateConstants.MODELTYPE_WORD).append(' ').append(metamodelURI).append(" \n");
        for (String imp : this.imports) {
            if (imp.contains("::")) continue;
            header.append(TemplateConstants.IMPORT_WORD).append(' ').append(imp).append("\n");
        }
        header.append("\n").append(TemplateConstants.IMPORT_END);
        return header.toString();
    }

    protected String computeMetamodelURI(EObject object) {
        if (this.isDynamic(object)) {
            return this.computeEcoreFileURI(object);
        }
        return this.computeNsURI(object);
    }

    private String computeEcoreFileURI(EObject object) {
        URI ecoreURI;
        Resource eCoreRes = object.eClass().eResource();
        if (eCoreRes != null && eCoreRes.getURI() != null && (ecoreURI = eCoreRes.getURI()).isPlatformResource()) {
            return ecoreURI.toPlatformString(true);
        }
        return null;
    }

    private boolean isDynamic(EObject object) {
        return object instanceof DynamicEObjectImpl;
    }

    private String computeNsURI(EObject object) {
        EPackage p = object.eClass().getEPackage();
        String nsURI = p.getNsURI();
        p = p.getESuperPackage();
        while (p != null) {
            String currentURI = p.getNsURI();
            if (currentURI != null && currentURI.length() > 0 && !currentURI.startsWith("unused://")) {
                nsURI = currentURI;
            }
            p = p.getESuperPackage();
        }
        return nsURI;
    }

    public void setVariable(String name, EObject value) {
        this.setVariable(name, new ENode(value, null, true));
    }

    public void setVariable(String name, Object value) {
        ENode valueNode = ENode.createTry(value, new ENode(null, null, true));
        this.setVariable(name, valueNode);
    }

    public void setVariable(String name, ENode value) {
        StackEx values = this.variableTables.get(name);
        if (values == null) {
            values = new StackEx();
        }
        values.push((Object)value);
        this.variableTables.put(name, (StackEx<ENode>)values);
        this.notifyVariableListeners();
    }

    public void unSetVariable(String name) {
        StackEx<ENode> values = this.variableTables.get(name);
        if (values != null) {
            if (values.size() > 1) {
                values.pop();
            } else {
                this.clearVariable(name);
            }
        }
        this.notifyVariableListeners();
    }

    protected ENode getVariableValue(String name) {
        StackEx<ENode> values = this.variableTables.get(name);
        if (values != null) {
            return (ENode)values.peek();
        }
        return null;
    }

    protected boolean isVariableSet(String name) {
        return this.variableTables.containsKey(name);
    }

    public void clearVariables() {
        this.variableTables.clear();
        this.notifyVariableListeners();
    }

    public void clearVariable(String name) {
        if (this.variableTables.containsKey(name)) {
            this.variableTables.remove(name);
            this.notifyVariableListeners();
        }
    }

    public void clearImports() {
        this.mmToScript.clear();
        this.templates.clear();
        this.imports.clear();
    }

    public void addImport(String path) {
        if (path != null && path.contains(".") && !this.imports.contains(path)) {
            this.mmToScript.clear();
            this.templates.clear();
            this.imports.add(path);
        }
        this.templates.clear();
    }

    public void addVariableStatusListener(IVariableStatusListener newListener) {
        this.variablesListeners.add(newListener);
    }

    public void removeVariableStatusListener(IVariableStatusListener listener) {
        this.variablesListeners.remove(listener);
    }

    public Map<String, ?> getVariables() {
        HashMap<String, ENode> lightVariables = new HashMap<String, ENode>();
        for (String variableName : this.variableTables.keySet()) {
            lightVariables.put(variableName, this.getVariableValue(variableName));
        }
        return lightVariables;
    }

    private void notifyVariableListeners() {
        if (this.variablesListeners.size() > 0) {
            Map<String, ?> lightVariables = this.getVariables();
            for (IVariableStatusListener listener : this.variablesListeners) {
                listener.notifyChanged(lightVariables);
            }
        }
    }

    @Deprecated
    public boolean getAsBoolean(Object evaluate) {
        return this.internalGetAsBoolean(evaluate);
    }

    private boolean internalGetAsBoolean(Object evaluate) {
        boolean result = false;
        if (evaluate instanceof ENode) {
            result = ENodeHelper.getAsBoolean((ENode)evaluate);
        } else if (evaluate instanceof Boolean) {
            result = (Boolean)evaluate;
        } else if (evaluate instanceof String) {
            result = Boolean.parseBoolean((String)evaluate);
        } else if (evaluate instanceof IAdaptable) {
            Boolean adaptedBoolean = (Boolean)((IAdaptable)evaluate).getAdapter(Boolean.class);
            if (adaptedBoolean != null) {
                result = adaptedBoolean;
            }
        } else if (evaluate != null) {
            result = true;
        }
        return result;
    }

    @Deprecated
    public EObject getAsEObject(Object result) {
        return this.internalGetAsEObject(result);
    }

    private EObject internalGetAsEObject(Object result) {
        Collection collection;
        EObject eObject = null;
        if (result instanceof ENode) {
            eObject = ENodeHelper.getAsEObject((ENode)result);
        } else if (result instanceof EObject) {
            eObject = (EObject)result;
        } else if (result instanceof IAdaptable) {
            eObject = (EObject)((IAdaptable)result).getAdapter(EObject.class);
        } else if (result instanceof ENodeList) {
            ENodeList eNodeList = (ENodeList)result;
            if (eNodeList.size() > 0) {
                eObject = this.internalGetAsEObject(eNodeList.get(0));
            }
        } else if (result instanceof Collection && !(collection = (Collection)result).isEmpty()) {
            Object first = collection.iterator().next();
            eObject = this.internalGetAsEObject(first);
        }
        return eObject;
    }

    @Deprecated
    public Integer getAsInteger(Object result) {
        return this.internalGetAsInteger(result);
    }

    private Integer internalGetAsInteger(Object result) {
        Integer integer = null;
        if (result instanceof ENode) {
            integer = ENodeHelper.getAsInteger((ENode)result);
        } else if (result instanceof Integer) {
            integer = (Integer)result;
        } else if (result instanceof IAdaptable) {
            integer = (Integer)((IAdaptable)result).getAdapter(Integer.class);
        } else if (result instanceof String) {
            try {
                int res = Integer.parseInt((String)result);
                integer = res;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return integer;
    }

    @Deprecated
    public Collection<EObject> getAsListOfEObjects(Object object) {
        return this.internalGetAsListOfEObjects(object);
    }

    private Collection<EObject> internalGetAsListOfEObjects(Object object) {
        LinkedList<EObject> result = new LinkedList();
        if (object instanceof Collection) {
            Collection tmp = (Collection)object;
            for (Object obj : tmp) {
                if (!(obj instanceof EObject)) continue;
                result.add((EObject)obj);
            }
        } else if (object instanceof ENode) {
            result = ENodeHelper.getAsListOfEObjects((ENode)object);
        } else if (object instanceof EObject) {
            result.add((EObject)object);
        }
        return result;
    }

    @Deprecated
    public String getAsString(Object result) {
        return this.internalGetAsString(result);
    }

    private String internalGetAsString(Object result) {
        if (result instanceof ENode) {
            return ENodeHelper.getAsString((ENode)result);
        }
        return result != null ? result.toString() : null;
    }

    public Object getValue(Object object, String s) {
        Object result = object;
        if (object instanceof ENode) {
            result = ENodeHelper.getValue((ENode)result, s);
        }
        return result;
    }

    public boolean provides(String expression) {
        return expression != null && expression.indexOf(PREFIX_KEYWORD) >= 0;
    }

    public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        Object evaluation = this.evaluate(context, expression);
        return this.internalGetAsBoolean(evaluation);
    }

    public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
        Object evaluation = this.evaluate(context, expression);
        return this.internalGetAsListOfEObjects(evaluation);
    }

    public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
        Object evaluation = this.evaluate(context, expression);
        return this.internalGetAsEObject(evaluation);
    }

    public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
        Object evaluation = this.evaluate(context, expression);
        return this.internalGetAsInteger(evaluation);
    }

    public String evaluateString(EObject context, String expression) throws EvaluationException {
        Object evaluation = this.evaluate(context, expression);
        return this.internalGetAsString(evaluation);
    }

    public Object getVariable(String name) {
        ENode node = this.getVariableValue(name);
        return this.getValue(node, "");
    }

    public void setProperty(Object key, Object value) {
    }

    public void dispose() {
        for (Map.Entry<SpecificScript, Map<String, Template>> child : this.templates.entrySet()) {
            child.getValue().clear();
        }
        this.templates.clear();
        this.variableTables.clear();
        this.variablesListeners.clear();
        this.imports.clear();
        this.deactivateCache();
        this.uninstallWorkspaceListener();
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    public abstract IInterpreter createInterpreter();

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        return this.getCompletionEntry().computeProposals(context);
    }

    public String getPrefix() {
        return PREFIX_KEYWORD;
    }

    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal("<%%>", "<%%>", "New legacy query language expression.", 2);
    }

    public String getVariablePrefix() {
        return VARIABLE_KEYWORD;
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
    }

    protected ENode getFromCache(ENode context, String evaluation, ENode[] args) {
        if (this.cache != null) {
            return this.cache.get(new CacheKey(context, evaluation, args));
        }
        return null;
    }

    protected void cache(ENode context, String evaluation, ENode[] args, ENode result) {
        if (this.cache != null) {
            this.cache.put(new CacheKey(context, evaluation, args), result);
        }
    }

    public void activateCache() {
        if (this.cache == null) {
            this.cache = new HashMap<CacheKey, ENode>();
        }
    }

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
    }

    public void deactivateCache() {
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        List<ContentProposal> resultList;
        String textSoFar = context.getTextSoFar();
        String evaluationString = textSoFar.substring(0, context.getCursorPosition());
        if (evaluationString.toLowerCase().startsWith(PREFIX_KEYWORD) && (resultList = this.getCompletionEntry().computeProposals(context)).size() > 0) {
            return resultList;
        }
        return Collections.emptyList();
    }

    public Collection<String> getImports() {
        return Collections.unmodifiableCollection(this.imports);
    }

    public void removeImport(String dependency) {
        if (this.imports.contains(dependency)) {
            this.imports.remove(dependency);
            this.mmToScript.clear();
        }
        this.templates.clear();
    }

    protected AcceleoCompletionEntry getCompletionEntry() {
        return new AcceleoCompletionEntry();
    }

    private void installWorkspaceListener() {
        if (this.templateListener == null) {
            this.templateListener = new AcceleoTemplateWorkspaceListener(this);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this.templateListener);
        }
    }

    private void uninstallWorkspaceListener() {
        if (this.templateListener != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener((IResourceChangeListener)this.templateListener);
            this.templateListener = null;
        }
    }

    protected void reconsiderTemplateFiles() {
        for (Map.Entry<SpecificScript, Map<String, Template>> child : this.templates.entrySet()) {
            child.getValue().clear();
        }
        this.mmToScript.clear();
        this.templates.clear();
    }

    private static class CacheKey {
        private ENode context;
        private String evaluation;
        private ENode[] args;

        public CacheKey(ENode context, String evaluation, ENode[] args) {
            this.context = context;
            this.evaluation = evaluation;
            this.args = args;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.evaluation == null ? 0 : this.evaluation.hashCode());
            result = 31 * result + (this.context == null ? 0 : this.hashCode(this.context));
            ENode[] eNodeArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                ENode node = eNodeArray[n2];
                result = 31 * result + (node == null ? 0 : this.hashCode(node));
                ++n2;
            }
            return result;
        }

        private int hashCode(ENode node) {
            int value = 0;
            if (node.getValue() != null) {
                if (!node.isList()) {
                    return node.getValue().hashCode();
                }
                try {
                    ENodeIterator iterNodes = node.getList().iterator();
                    while (iterNodes.hasNext()) {
                        value += this.hashCode(iterNodes.next());
                    }
                }
                catch (ENodeCastException e) {
                    AcceleoInterpreterPlugin.getDefault().error(e.getMessage(), e);
                }
            }
            return value;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof CacheKey) {
                result = this.equals((CacheKey)obj);
            }
            return result;
        }

        private boolean equals(CacheKey cacheKey) {
            boolean node = this.context == null && cacheKey.context == null || this.context != null && this.context.equals((Object)cacheKey.context);
            boolean eval = node && (this.evaluation == null && cacheKey.evaluation == null || this.evaluation != null && this.evaluation.equals(cacheKey.evaluation));
            boolean result = eval && this.args.length == cacheKey.args.length;
            int i = 0;
            while (i < this.args.length && result) {
                result = this.args[i].equals((Object)cacheKey.args[i]);
                ++i;
            }
            return result;
        }
    }
}

