/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.fa.properties.controllers.AbstractFunction_AvailableInStatesController;
import org.polarsys.capella.core.data.fa.properties.controllers.FunctionRealizationsController;
import org.polarsys.capella.core.data.fa.properties.fields.FunctionKindGroup;
import org.polarsys.capella.core.data.fa.properties.sections.Messages;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;
import org.polarsys.capella.core.ui.properties.fields.TextValueGroup;

public abstract class AbstractFunctionSection
extends NamedElementSection {
    private boolean showKind;
    private boolean showRealizations;
    private MultipleSemanticField realizedWidget;
    private MultipleSemanticField availableInStatesField;
    private FunctionKindGroup functionKindGroup;
    protected TextValueGroup conditionField;

    public AbstractFunctionSection() {
        this(true, true);
    }

    public AbstractFunctionSection(boolean showKind, boolean showRealizations) {
        this.showKind = showKind;
        this.showRealizations = showRealizations;
    }

    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        if (this.showKind) {
            this.functionKindGroup = new FunctionKindGroup(parent, this.getWidgetFactory(), true){

                protected void selectButton(Button button, Enumerator enumerated) {
                    AbstractFunctionSection.this.conditionField.setEnabled(FunctionKind.ROUTE.equals((Object)enumerated) || FunctionKind.SELECT.equals((Object)enumerated));
                    super.selectButton(button, enumerated);
                }
            };
            this.functionKindGroup.setDisplayedInWizard(displayedInWizard);
            this.conditionField = new TextValueGroup(parent, Messages.AbstractFunctionSection_Condition_Label, this.getWidgetFactory());
            this.conditionField.setDisplayedInWizard(displayedInWizard);
        }
        this.availableInStatesField = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.AbstractFunctionSection_AvailableInStates_Label, this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractFunction_AvailableInStatesController());
        this.availableInStatesField.setDisplayedInWizard(displayedInWizard);
        if (this.showRealizations) {
            this.realizedWidget = new MultipleSemanticField((Composite)this.getReferencesGroup(), "", this.getWidgetFactory(), (IMultipleSemanticFieldController)new FunctionRealizationsController());
            this.realizedWidget.setDisplayedInWizard(displayedInWizard);
        }
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        if (this.functionKindGroup != null) {
            this.functionKindGroup.loadData(capellaElement, (EStructuralFeature)FaPackage.eINSTANCE.getAbstractFunction_Kind());
        }
        if (this.conditionField != null) {
            this.conditionField.loadData(capellaElement, (EStructuralFeature)FaPackage.eINSTANCE.getAbstractFunction_Condition());
        }
        if (this.availableInStatesField != null) {
            this.availableInStatesField.loadData(capellaElement, (EStructuralFeature)FaPackage.eINSTANCE.getAbstractFunction_AvailableInStates());
        }
        if (this.realizedWidget != null) {
            this.realizedWidget.loadData(capellaElement, (EStructuralFeature)FaPackage.eINSTANCE.getAbstractFunction_OwnedFunctionRealizations());
            if (EcoreUtil2.isContainedBy((EObject)capellaElement, (EClass)CtxPackage.Literals.SYSTEM_ANALYSIS)) {
                this.realizedWidget.setLabel(Messages.AbstractFunctionSection_RealizedActivities_Label);
            } else if (EcoreUtil2.isContainedBy((EObject)capellaElement, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE)) {
                this.realizedWidget.setLabel(Messages.AbstractFunctionSection_RealizedSystemFunctions_Label);
            } else if (EcoreUtil2.isContainedBy((EObject)capellaElement, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE)) {
                this.realizedWidget.setLabel(Messages.AbstractFunctionSection_RealizedLogicalFunctions_Label);
            } else if (EcoreUtil2.isContainedBy((EObject)capellaElement, (EClass)EpbsPackage.Literals.EPBS_ARCHITECTURE)) {
                this.realizedWidget.setLabel(Messages.AbstractFunctionSection_RealizedPhysicalFunctions_Label);
            } else {
                this.realizedWidget.setLabel(Messages.AbstractFunctionSection_RealizedFunctions_Label);
            }
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.functionKindGroup);
        fields.add((AbstractSemanticField)this.conditionField);
        fields.add((AbstractSemanticField)this.availableInStatesField);
        fields.add((AbstractSemanticField)this.realizedWidget);
        return fields;
    }
}

