/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.oa.RolePkg;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.Messages;

public class CreateOpAnalysisCmd
extends AbstractReadWriteCommand {
    private String _architectureName;
    private OperationalAnalysis _operationalAnalysis;
    private OperationalActivity _rootOperationalActivity;
    private SystemEngineering _systemEng;

    public CreateOpAnalysisCmd(SystemEngineering systemEng_p, String architectureName_p) {
        this._systemEng = systemEng_p;
        this._architectureName = architectureName_p;
    }

    public CreateOpAnalysisCmd(SystemEngineering systemEng_p, String architectureName_p, OperationalAnalysis createdElement) {
        this(systemEng_p, architectureName_p);
        this._operationalAnalysis = createdElement;
    }

    public void run() {
        if (this._operationalAnalysis == null) {
            this._operationalAnalysis = OaFactory.eINSTANCE.createOperationalAnalysis();
            this._systemEng.getOwnedArchitectures().add((Object)this._operationalAnalysis);
        }
        this._operationalAnalysis.setName(this._architectureName);
        OperationalActivityPkg activitiesPkg = OaFactory.eINSTANCE.createOperationalActivityPkg(NamingConstants.CreateOpAnalysisCmd_operationalActivities_pkg_name);
        this._operationalAnalysis.setOwnedFunctionPkg((FunctionPkg)activitiesPkg);
        this._rootOperationalActivity = OaFactory.eINSTANCE.createOperationalActivity(NamingConstants.CreateOpAnalysisCmd_operationalActivity_root_name);
        activitiesPkg.getOwnedOperationalActivities().add((Object)this._rootOperationalActivity);
        OperationalCapabilityPkg capabilitiesPkg = OaFactory.eINSTANCE.createOperationalCapabilityPkg(NamingConstants.CreateOpAnalysisCmd_operationalCapabilities_pkg_name);
        this._operationalAnalysis.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capabilitiesPkg);
        InterfacePkg interfacesPkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
        this._operationalAnalysis.setOwnedInterfacePkg(interfacesPkg);
        DataPkg dataPkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
        this._operationalAnalysis.setOwnedDataPkg(dataPkg);
        RolePkg rolesPkg = OaFactory.eINSTANCE.createRolePkg(NamingConstants.CreateOpAnalysisCmd_roles_pkg_name);
        this._operationalAnalysis.setOwnedRolePkg(rolesPkg);
        EntityPkg entitiesPkg = OaFactory.eINSTANCE.createEntityPkg(NamingConstants.CreateOpAnalysisCmd_operationalEntities_pkg_name);
        this._operationalAnalysis.setOwnedEntityPkg(entitiesPkg);
    }

    public String getName() {
        return Messages.getString("capella.op_analysis.create.cmd");
    }

    public OperationalAnalysis getOperationalAnalysis() {
        return this._operationalAnalysis;
    }

    public OperationalActivity getRootOperationalActivity() {
        return this._rootOperationalActivity;
    }
}

