/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.OperationalAnalysisRealization;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.Messages;
import org.polarsys.capella.core.model.skeleton.helpers.PredefinedTypesHelper;

public class CreateCtxArchiCmd
extends AbstractReadWriteCommand {
    private String _architectureName;
    private SystemAnalysis _SystemAnalysis;
    private OperationalActivity _opActivity;
    private OperationalAnalysis _opAnalysis;
    private SystemFunction _systemFunction;
    private SystemComponent _system;
    private FunctionRealization _functionRealisation;
    private OperationalAnalysisRealization _opAnalysisRealisation;
    private SystemEngineering _systemEng;

    public CreateCtxArchiCmd(SystemEngineering systemEng_p, String architectureName_p, OperationalAnalysis opAnalysis_p, OperationalActivity opActivity_p) {
        this._architectureName = architectureName_p;
        this._opActivity = opActivity_p;
        this._opAnalysis = opAnalysis_p;
        this._systemEng = systemEng_p;
    }

    public CreateCtxArchiCmd(SystemEngineering engineering, String createSysAnalysisCmd_name, OperationalAnalysis architecture, OperationalActivity rootFunction, SystemAnalysis createdElement) {
        this(engineering, createSysAnalysisCmd_name, architecture, rootFunction);
        this._SystemAnalysis = createdElement;
    }

    public void run() {
        if (this._SystemAnalysis == null) {
            this._SystemAnalysis = CtxFactory.eINSTANCE.createSystemAnalysis();
            this._systemEng.getOwnedArchitectures().add((Object)this._SystemAnalysis);
        }
        this._SystemAnalysis.setName(this._architectureName);
        SystemFunctionPkg systemFunctionPkg = CtxFactory.eINSTANCE.createSystemFunctionPkg(NamingConstants.CreateSysAnalysisCmd_system_functions_pkg_name);
        this._SystemAnalysis.setOwnedFunctionPkg((FunctionPkg)systemFunctionPkg);
        this._systemFunction = CtxFactory.eINSTANCE.createSystemFunction(NamingConstants.CreateSysAnalysisCmd_system_function_root_name);
        systemFunctionPkg.getOwnedSystemFunctions().add((Object)this._systemFunction);
        if (this._opActivity != null) {
            this._functionRealisation = FaFactory.eINSTANCE.createFunctionRealization();
            this._systemFunction.getOwnedFunctionRealizations().add((Object)this._functionRealisation);
            this._functionRealisation.setSourceElement((TraceableElement)this._systemFunction);
            this._functionRealisation.setTargetElement((TraceableElement)this._opActivity);
        }
        MissionPkg missionsPkg = CtxFactory.eINSTANCE.createMissionPkg(NamingConstants.CreateSysAnalysisCmd_missions_pkg_name);
        this._SystemAnalysis.setOwnedMissionPkg(missionsPkg);
        CapabilityPkg capabilitiesPkg = CtxFactory.eINSTANCE.createCapabilityPkg(NamingConstants.CreateSysAnalysisCmd_capabilities_pkg_name);
        this._SystemAnalysis.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capabilitiesPkg);
        InterfacePkg interfacesPkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
        this._SystemAnalysis.setOwnedInterfacePkg(interfacesPkg);
        DataPkg dataPkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
        PredefinedTypesHelper.createPredefinedDataTypes(dataPkg);
        this._SystemAnalysis.setOwnedDataPkg(dataPkg);
        SystemComponentPkg componentPkg = CtxFactory.eINSTANCE.createSystemComponentPkg(NamingConstants.CreateSysAnalysisCmd_actors_pkg_name);
        this._SystemAnalysis.setOwnedSystemComponentPkg(componentPkg);
        this._system = CtxFactory.eINSTANCE.createSystemComponent(NamingConstants.CreateSysAnalysisCmd_system_name);
        componentPkg.getOwnedSystemComponents().add((Object)this._system);
        Part systemPart = CsFactory.eINSTANCE.createPart(this._system.getName());
        componentPkg.getOwnedParts().add((Object)systemPart);
        systemPart.setAbstractType((AbstractType)this._system);
        StateMachine stateMachine = CapellacommonFactory.eINSTANCE.createStateMachine(NamingConstants.CreateSysAnalysisCmd_system_statemachine_name);
        this._system.getOwnedStateMachines().add((Object)stateMachine);
        Region region = CapellacommonFactory.eINSTANCE.createRegion(NamingConstants.Region_DefaultRegion);
        stateMachine.getOwnedRegions().add((Object)region);
        if (this._opAnalysis != null) {
            this._opAnalysisRealisation = CtxFactory.eINSTANCE.createOperationalAnalysisRealization();
            this._SystemAnalysis.getOwnedOperationalAnalysisRealizations().add((Object)this._opAnalysisRealisation);
            this._opAnalysisRealisation.setSourceElement((TraceableElement)this._SystemAnalysis);
            this._opAnalysisRealisation.setTargetElement((TraceableElement)this._opAnalysis);
        }
    }

    public SystemAnalysis getSystemAnalysis() {
        return this._SystemAnalysis;
    }

    public SystemFunction getSystemFunction() {
        return this._systemFunction;
    }

    public SystemComponent getSystem() {
        return this._system;
    }

    public FunctionRealization getFunctionRealization() {
        return this._functionRealisation;
    }

    public OperationalAnalysisRealization getOpAnalysisRealization() {
        return this._opAnalysisRealisation;
    }

    public String getName() {
        return Messages.getString("capella.ctx_archi.create.cmd");
    }
}

