/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.skeleton.EngineeringDomain;
import org.polarsys.capella.core.model.skeleton.impl.SkeletonServicesImpl;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateCapellaProjectCmd;

public class CapellaModelSkeleton
extends AdapterImpl {
    public static CapellaModelSkeleton asSkeleton(EObject capellaModelElement) {
        CapellaModelSkeleton sk;
        CapellaModelSkeleton result = null;
        EObject root = EcoreUtil.getRootContainer((EObject)capellaModelElement);
        result = (CapellaModelSkeleton)EcoreUtil.getExistingAdapter((Notifier)root, CapellaModelSkeleton.class);
        if (result == null && (sk = new CapellaModelSkeleton()).isAdapterForType(root)) {
            root.eAdapters().add((Object)sk);
            result = sk;
        }
        return result;
    }

    public Project getProject() {
        return (Project)this.getTarget();
    }

    public SystemEngineering getSystemEngineering() {
        return SystemEngineeringExt.getSystemEngineering((Project)this.getProject());
    }

    public PhysicalArchitecture getPhysicalArchitecture() {
        return SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)this.getSystemEngineering());
    }

    public LogicalArchitecture getLogicalArchitecture() {
        return SystemEngineeringExt.getLogicalArchitecture((SystemEngineering)this.getSystemEngineering());
    }

    public OperationalAnalysis getOperationalAnalysis() {
        return SystemEngineeringExt.getOperationalAnalysis((SystemEngineering)this.getSystemEngineering());
    }

    public SystemAnalysis getSystemAnalysis() {
        return SystemEngineeringExt.getSystemAnalysis((SystemEngineering)this.getSystemEngineering());
    }

    public EPBSArchitecture getEPBSArchitecture() {
        return SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)this.getSystemEngineering());
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Project;
    }

    public static class Builder {
        public static final URI DEFAULT_URI = URI.createURI((String)"skeleton.melodymodeller");
        public static final String DEFAULT_NAME = "Skeleton";
        public static final EngineeringDomain DEFAULT_ENGINEERING_DOMAIN = EngineeringDomain.System;
        public static final boolean DEFAULT_INCLUDE_OPERATIONAL_ANALYSIS = true;
        public static final CapellaProjectHelper.ProjectApproach DEFAULT_PROJECT_APPROACH = CapellaProjectHelper.ProjectApproach.SingletonComponents;
        public static final EClass DEFAULT_ROOT_TYPE = CapellamodellerPackage.Literals.PROJECT;
        private final ExecutionManager manager;
        private URI uri = DEFAULT_URI;
        private String name = "Skeleton";
        private EngineeringDomain domain = DEFAULT_ENGINEERING_DOMAIN;
        private boolean includeOperationalAnalysis = true;
        private CapellaProjectHelper.ProjectApproach pa = DEFAULT_PROJECT_APPROACH;
        private EClass rootType = DEFAULT_ROOT_TYPE;
        CapellaModelSkeleton result;

        public Builder(ExecutionManager manager) {
            this.manager = manager;
        }

        public Builder setURI(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setRootType(EClass rootType) {
            if (CapellamodellerPackage.Literals.PROJECT.isSuperTypeOf(rootType)) {
                this.rootType = rootType;
                return this;
            }
            throw new IllegalArgumentException("Argument must be a subtype of 'Project'");
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEngineeringDomain(EngineeringDomain domain) {
            this.domain = domain;
            return this;
        }

        public Builder setIncludeOperationalAnalysis(boolean include) {
            this.includeOperationalAnalysis = include;
            return this;
        }

        public CapellaModelSkeleton build() {
            if (this.result == null) {
                Resource existing = this.manager.getEditingDomain().getResourceSet().getResource(this.uri, false);
                Resource resource = existing == null ? this.manager.getEditingDomain().getResourceSet().createResource(this.uri) : existing;
                CreateCapellaProjectCmd cmd = new CreateCapellaProjectCmd(resource, this.name, this.pa){

                    @Override
                    protected Project createProject(String name) {
                        Project p = (Project)rootType.getEPackage().getEFactoryInstance().create(rootType);
                        p.setName(name);
                        return p;
                    }
                };
                this.manager.execute((ICommand)cmd);
                this.result = CapellaModelSkeleton.asSkeleton((EObject)cmd.getProject());
                SkeletonServicesImpl s = new SkeletonServicesImpl();
                s.doSystemEngineering(this.result.getProject(), this.name, this.domain, this.includeOperationalAnalysis);
            }
            return this.result;
        }
    }
}

