/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;

public abstract class ReferentialConstraintsValidationHelper<T> {
    final boolean liveValidation;

    public ReferentialConstraintsValidationHelper(boolean liveValidation) {
        this.liveValidation = liveValidation;
    }

    public List<T> validate(Collection<EObject> targets) {
        ArrayList result = new ArrayList();
        for (EObject e : targets) {
            if (this.liveValidation) {
                this.validateIncomingReferences(e, result, targets);
            }
            this.validateOutgoingReferences(e, result);
        }
        return result;
    }

    public Collection<EObject> getTargets(Collection<Notification> notifications) {
        ArrayList<EObject> targets = new ArrayList<EObject>();
        for (Notification n : notifications) {
            if (!(n.getNotifier() instanceof EObject) || !(n.getFeature() instanceof EReference) || !((EReference)n.getFeature()).isContainment()) continue;
            if (n.getEventType() == 4) {
                EObject e = (EObject)n.getOldValue();
                if (e.eResource() == null) continue;
                targets.add(e);
                continue;
            }
            if (n.getEventType() != 6) continue;
            Collection removed = (Collection)n.getOldValue();
            for (EObject e : removed) {
                if (e.eResource() == null) continue;
                targets.add(e);
            }
        }
        return targets;
    }

    private void validateSetting(EObject source, EReference ref, EObject target, Collection<T> results) {
        List currentElements;
        List availableElements;
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(source.eClass(), (EStructuralFeature)ref);
        if (query != null && !(availableElements = query.getAvailableElements(source)).contains(target) && (currentElements = query.getCurrentElements(source, false)).contains(target)) {
            results.add(this.createStatus(source, target, ref));
        }
    }

    public void validateOutgoingReferences(EObject element, Collection<T> results) {
        EContentsEList.FeatureIterator it = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
        while (it.hasNext()) {
            EObject target = (EObject)it.next();
            EReference ref = (EReference)it.feature();
            this.validateSetting(element, ref, target, results);
        }
        if (this.liveValidation) {
            for (EObject e : element.eContents()) {
                this.validateOutgoingReferences(e, results);
            }
        }
    }

    public void validateIncomingReferences(EObject element, Collection<T> results, Collection<EObject> sourceFilter) {
        SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionUtil.getEditingDomain((EObject)element);
        for (EStructuralFeature.Setting s : domain.getCrossReferencer().getInverseReferences(element)) {
            EReference ref;
            EObject source = s.getEObject();
            if (EcoreUtil.isAncestor(sourceFilter, (EObject)source) || (ref = (EReference)s.getEStructuralFeature()).isContainment() || ref.isContainer()) continue;
            this.validateSetting(source, ref, element, results);
        }
        if (this.liveValidation) {
            for (EObject e : element.eContents()) {
                this.validateIncomingReferences(e, results, sourceFilter);
            }
        }
    }

    protected abstract T createStatus(EObject var1, EObject var2, EReference var3);
}

