/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.updateconnections.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.re.updateconnections.ui.CatalogElementScope;
import org.polarsys.capella.core.re.updateconnections.ui.Connection;
import org.polarsys.capella.core.re.updateconnections.ui.SparseModelScope;

public class ConnectedCatalogElementsScope
implements SparseModelScope.AttachHandler {
    private final Collection<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>();
    private final Collection<FunctionalExchange> functionalExchanges = new ArrayList<FunctionalExchange>();
    private final Collection<PhysicalLink> physicalLinks = new ArrayList<PhysicalLink>();
    private final Collection<ComponentExchangeFunctionalExchangeAllocation> cefeAllocations = new ArrayList<ComponentExchangeFunctionalExchangeAllocation>();
    private final Collection<ComponentExchangeAllocation> plceAllocations = new ArrayList<ComponentExchangeAllocation>();
    private final Collection<AbstractExchangeItem> exchangeItems = new HashSet<AbstractExchangeItem>();
    private final Collection<Port> leftPorts = new LinkedHashSet<Port>();
    private final Collection<Port> rightPorts = new LinkedHashSet<Port>();
    private final Collection<PhysicalLinkEnd> leftPhysicalLinkEnds = new LinkedHashSet<PhysicalLinkEnd>();
    private final Collection<PhysicalLinkEnd> rightPhysicalLinkEnds = new LinkedHashSet<PhysicalLinkEnd>();
    private final Collection<ComponentExchangeEnd> leftComponentExchangeEnds = new LinkedHashSet<ComponentExchangeEnd>();
    private final Collection<ComponentExchangeEnd> rightComponentExchangeEnds = new LinkedHashSet<ComponentExchangeEnd>();
    private final Collection<Part> leftParts = new LinkedHashSet<Part>();
    private final Collection<Part> rightParts = new LinkedHashSet<Part>();
    private final Map<Object, Connection> connections = new HashMap<Object, Connection>();
    private final CatalogElement left;
    private final CatalogElement right;

    public ConnectedCatalogElementsScope(CatalogElement left, CatalogElement right) {
        this.left = left;
        this.right = right;
        CatalogElementScope leftScope = new CatalogElementScope(left);
        CatalogElementScope rightScope = new CatalogElementScope(right);
        this.initFunctionalExchanges(leftScope.getElements(FunctionPort.class), rightScope.getElements(FunctionPort.class));
        this.initComponentExchanges(leftScope, rightScope);
        this.initPhysicalLinks(leftScope.getElements(PhysicalPort.class), rightScope.getElements(PhysicalPort.class));
        this.initAllocations();
        this.initExchangeItems();
    }

    public Collection<Part> getLeftParts() {
        return Collections.unmodifiableCollection(this.leftParts);
    }

    public Collection<Part> getRightParts() {
        return Collections.unmodifiableCollection(this.rightParts);
    }

    public Collection<Port> getLeftPorts() {
        return Collections.unmodifiableCollection(this.leftPorts);
    }

    public Collection<Port> getRightPorts() {
        return Collections.unmodifiableCollection(this.rightPorts);
    }

    public Collection<PhysicalLinkEnd> getLeftPhysicalLinkEnds() {
        return Collections.unmodifiableCollection(this.leftPhysicalLinkEnds);
    }

    public Collection<PhysicalLinkEnd> getRightPhysicalLinkEnds() {
        return Collections.unmodifiableCollection(this.rightPhysicalLinkEnds);
    }

    public Collection<ComponentExchangeEnd> getLeftComponentExchangeEnds() {
        return Collections.unmodifiableCollection(this.leftComponentExchangeEnds);
    }

    public Collection<ComponentExchangeEnd> getRightComponentExchangeEnds() {
        return Collections.unmodifiableCollection(this.rightComponentExchangeEnds);
    }

    public Collection<FunctionalExchange> getFunctionalExchanges() {
        return Collections.unmodifiableCollection(this.functionalExchanges);
    }

    public Collection<ComponentExchange> getComponentExchanges() {
        return Collections.unmodifiableCollection(this.componentExchanges);
    }

    public Collection<PhysicalLink> getPhysicalLinks() {
        return Collections.unmodifiableCollection(this.physicalLinks);
    }

    public Collection<AbstractExchangeItem> getExchangeItems() {
        return Collections.unmodifiableCollection(this.exchangeItems);
    }

    public Connection adapt(Object connection) {
        return this.connections.get(connection);
    }

    public CatalogElement getLeftCatalogElement() {
        return this.left;
    }

    public CatalogElement getRightCatalogElement() {
        return this.right;
    }

    @Override
    public void attachContainment(EObject toAttach, EObject source, Role targetRole, IMapping mapping) {
        AbstractFunction container;
        EObject in;
        EObject out;
        if (toAttach instanceof FunctionalExchange) {
            FunctionalExchange sourceFE = (FunctionalExchange)source;
            out = this.getRoleElement(targetRole, (EObject)sourceFE.getSourceFunctionOutputPort(), mapping);
            in = this.getRoleElement(targetRole, (EObject)sourceFE.getTargetFunctionInputPort(), mapping);
            container = FunctionalExchangeExt.getDefaultContainer((AbstractFunction)((AbstractFunction)out.eContainer()), (AbstractFunction)((AbstractFunction)in.eContainer()));
            container.getOwnedFunctionalExchanges().add((Object)((FunctionalExchange)toAttach));
        }
        if (toAttach instanceof ComponentExchange) {
            CapellaElement container2;
            CapellaElement targetCETarget;
            CapellaElement targetCESource;
            Part sourceCETarget;
            ComponentExchange sourceCE = (ComponentExchange)source;
            Part sourceCESource = sourceCE.getSourcePart();
            if (sourceCESource == null) {
                sourceCESource = sourceCE.getSourcePort();
            }
            if ((sourceCETarget = sourceCE.getTargetPart()) == null) {
                sourceCETarget = sourceCE.getTargetPort();
            }
            if ((targetCESource = (CapellaElement)this.getRoleElement(targetRole, (EObject)sourceCESource, mapping)) instanceof ComponentPort) {
                targetCESource = (CapellaElement)targetCESource.eContainer();
            }
            if ((targetCETarget = (CapellaElement)this.getRoleElement(targetRole, (EObject)sourceCETarget, mapping)) instanceof ComponentPort) {
                targetCETarget = (CapellaElement)targetCESource.eContainer();
            }
            if ((container2 = ComponentExchangeExt.getDefaultContainer((CapellaElement)targetCESource, (CapellaElement)targetCETarget)) instanceof ComponentPkg) {
                ((ComponentPkg)container2).getOwnedComponentExchanges().add((Object)((ComponentExchange)toAttach));
            } else if (container2 instanceof Component) {
                ((Component)container2).getOwnedComponentExchanges().add((Object)((ComponentExchange)toAttach));
            }
        }
        if (toAttach instanceof PhysicalLink) {
            PhysicalLink sourcePL = (PhysicalLink)source;
            out = this.getRoleElement(targetRole, (EObject)sourcePL.getSourcePhysicalPort(), mapping);
            in = this.getRoleElement(targetRole, (EObject)sourcePL.getTargetPhysicalPort(), mapping);
            container = PhysicalLinkExt.getDefaultContainer((CapellaElement)((CapellaElement)out.eContainer()), (CapellaElement)((CapellaElement)in.eContainer()));
            if (container instanceof Component) {
                ((Component)container).getOwnedPhysicalLinks().add((Object)((PhysicalLink)toAttach));
            } else if (container instanceof ComponentPkg) {
                ((ComponentPkg)container).getOwnedPhysicalLinks().add((Object)((PhysicalLink)toAttach));
            }
        }
    }

    private EObject getRoleElement(Role role, EObject element, IMapping mapping) {
        return mapping.getMatchFor(element, role.opposite()).get(role);
    }

    private void initExchangeItems() {
        for (FunctionalExchange fe : this.getFunctionalExchanges()) {
            this.exchangeItems.addAll((Collection<AbstractExchangeItem>)fe.getExchangedItems());
        }
        for (ComponentExchange ce : this.getComponentExchanges()) {
            this.exchangeItems.addAll((Collection<AbstractExchangeItem>)ce.getConvoyedInformations());
        }
    }

    private void initAllocations() {
        for (FunctionalExchange fe : this.getFunctionalExchanges()) {
            for (ComponentExchangeFunctionalExchangeAllocation cefe : EObjectExt.getReferencers((EObject)fe, (EReference)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT)) {
                if (!this.componentExchanges.contains(cefe.getSourceElement())) continue;
                this.cefeAllocations.add(cefe);
            }
        }
        for (ComponentExchange ce : this.getComponentExchanges()) {
            for (ComponentExchangeAllocation plce : EObjectExt.getReferencers((EObject)ce, (EReference)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT)) {
                if (!this.physicalLinks.contains(plce.getSourceElement())) continue;
                this.plceAllocations.add(plce);
            }
        }
    }

    private void initComponentExchanges(CatalogElementScope leftScope, CatalogElementScope rightScope) {
        ArrayList<ComponentExchange> allExchanges = new ArrayList<ComponentExchange>();
        for (ComponentPort leftPort : leftScope.getElements(ComponentPort.class)) {
            for (ComponentExchange ex : leftPort.getComponentExchanges()) {
                allExchanges.add(ex);
            }
        }
        for (Part leftPart : leftScope.getElements(Part.class)) {
            for (AbstractInformationFlow aif : leftPart.getInformationFlows()) {
                if (!(aif instanceof ComponentExchange)) continue;
                ComponentExchange ce = (ComponentExchange)aif;
                allExchanges.add(ce);
            }
        }
        HashMap<ComponentExchange, Connection> ceConnections = new HashMap<ComponentExchange, Connection>();
        for (ComponentExchange componentExchange : allExchanges) {
            if (rightScope.getElements().contains(componentExchange.getTargetPart()) || rightScope.getElements().contains(componentExchange.getTargetPort())) {
                ceConnections.put(componentExchange, new Connection((EObject)componentExchange, (EObject)componentExchange.getSource(), (EObject)componentExchange.getTarget()));
                continue;
            }
            if (!rightScope.getElements().contains(componentExchange.getSourcePart()) && !rightScope.getElements().contains(componentExchange.getSourcePort())) continue;
            ceConnections.put(componentExchange, new Connection((EObject)componentExchange, (EObject)componentExchange.getTarget(), (EObject)componentExchange.getSource()));
        }
        for (Map.Entry entry : ceConnections.entrySet()) {
            Part x;
            Connection connection = (Connection)entry.getValue();
            if (connection.getSource() instanceof ComponentPort) {
                this.leftPorts.add((Port)((ComponentPort)connection.getSource()));
            } else if (connection.getSource() instanceof ComponentExchangeEnd) {
                x = ((ComponentExchangeEnd)connection.getSource()).getPart();
                if (x == null) continue;
                this.leftComponentExchangeEnds.add((ComponentExchangeEnd)connection.getSource());
                this.leftPorts.add(((ComponentExchangeEnd)connection.getSource()).getPort());
                this.leftParts.add(x);
            } else if (connection.getSource() instanceof Part) {
                this.leftParts.add((Part)connection.getSource());
            }
            if (connection.getTarget() instanceof ComponentPort) {
                this.rightPorts.add((Port)((ComponentPort)connection.getTarget()));
            } else if (connection.getTarget() instanceof ComponentExchangeEnd) {
                x = ((ComponentExchangeEnd)connection.getTarget()).getPart();
                if (x == null) continue;
                this.rightPorts.add(((ComponentExchangeEnd)connection.getTarget()).getPort());
                this.rightComponentExchangeEnds.add((ComponentExchangeEnd)connection.getTarget());
                this.rightParts.add(x);
            } else if (connection.getTarget() instanceof Part) {
                this.rightParts.add((Part)connection.getTarget());
            }
            this.connections.put(entry.getKey(), (Connection)entry.getValue());
            this.componentExchanges.add((ComponentExchange)entry.getKey());
        }
    }

    private void initFunctionalExchanges(Collection<FunctionPort> left, Collection<FunctionPort> right) {
        for (FunctionPort p : left) {
            if (p instanceof FunctionInputPort) {
                for (FunctionalExchange fe : ((FunctionInputPort)p).getIncomingFunctionalExchanges()) {
                    if (!right.contains(fe.getSourceFunctionOutputPort())) continue;
                    this.functionalExchanges.add(fe);
                    this.leftPorts.add((Port)p);
                    this.rightPorts.add((Port)fe.getSourceFunctionOutputPort());
                    this.connections.put(fe, new Connection((EObject)fe, (EObject)p, (EObject)fe.getSourceFunctionOutputPort()));
                }
            }
            if (!(p instanceof FunctionOutputPort)) continue;
            for (FunctionalExchange fe : ((FunctionOutputPort)p).getOutgoingFunctionalExchanges()) {
                if (!right.contains(fe.getTargetFunctionInputPort())) continue;
                this.functionalExchanges.add(fe);
                this.leftPorts.add((Port)p);
                this.rightPorts.add((Port)fe.getTargetFunctionInputPort());
                this.connections.put(fe, new Connection((EObject)fe, (EObject)p, (EObject)fe.getTargetFunctionInputPort()));
            }
        }
    }

    private void initPhysicalLinks(Collection<PhysicalPort> left, Collection<PhysicalPort> right) {
        for (PhysicalPort p : left) {
            for (PhysicalLink pl : p.getInvolvedLinks()) {
                Connection connection = null;
                EObject source = PhysicalLinkExt.getSource((PhysicalLink)pl);
                EObject target = PhysicalLinkExt.getTarget((PhysicalLink)pl);
                if (p == pl.getSourcePhysicalPort() && right.contains(pl.getTargetPhysicalPort())) {
                    connection = new Connection((EObject)pl, source, target);
                } else if (p == pl.getTargetPhysicalPort() && right.contains(pl.getSourcePhysicalPort())) {
                    connection = new Connection((EObject)pl, target, source);
                }
                if (connection == null) continue;
                this.physicalLinks.add((PhysicalLink)connection.getConnection());
                this.connections.put(pl, connection);
                if (connection.getSource() instanceof Port) {
                    this.leftPorts.add((Port)connection.getSource());
                } else if (connection.getSource() instanceof PhysicalLinkEnd) {
                    this.leftPhysicalLinkEnds.add((PhysicalLinkEnd)connection.getSource());
                    this.leftPorts.add((Port)((PhysicalLinkEnd)connection.getSource()).getPort());
                    this.leftParts.add(((PhysicalLinkEnd)connection.getSource()).getPart());
                }
                if (connection.getTarget() instanceof Port) {
                    this.rightPorts.add((Port)connection.getTarget());
                    continue;
                }
                if (!(connection.getTarget() instanceof PhysicalLinkEnd)) continue;
                this.rightPhysicalLinkEnds.add((PhysicalLinkEnd)connection.getTarget());
                this.rightPorts.add((Port)((PhysicalLinkEnd)connection.getTarget()).getPort());
                this.rightParts.add(((PhysicalLinkEnd)connection.getTarget()).getPart());
            }
        }
    }

    public static void complement(ConnectedCatalogElementsScope recScope, ConnectedCatalogElementsScope rplScope) {
        for (Port recPort : recScope.getLeftPorts()) {
            for (CatalogElementLink rplLink : rplScope.left.getOwnedLinks()) {
                if (rplLink.getOrigin().getTarget() != recPort) continue;
                rplScope.leftPorts.add((Port)rplLink.getTarget());
            }
        }
        for (Port recPort : recScope.getRightPorts()) {
            for (CatalogElementLink rplLink : rplScope.right.getOwnedLinks()) {
                if (rplLink.getOrigin().getTarget() != recPort) continue;
                rplScope.rightPorts.add((Port)rplLink.getTarget());
            }
        }
        for (Port port : rplScope.getLeftPorts()) {
            for (CatalogElementLink rplLink : rplScope.left.getOwnedLinks()) {
                if (rplLink.getTarget() != port) continue;
                recScope.leftPorts.add((Port)rplLink.getOrigin().getTarget());
            }
        }
        for (Port port : rplScope.getRightPorts()) {
            for (CatalogElementLink rplLink : rplScope.right.getOwnedLinks()) {
                if (rplLink.getTarget() != port) continue;
                recScope.rightPorts.add((Port)rplLink.getOrigin().getTarget());
            }
        }
        for (Part part : rplScope.getRightParts()) {
            for (CatalogElementLink rplLink : rplScope.right.getOwnedLinks()) {
                if (rplLink.getTarget() != part) continue;
                recScope.rightParts.add((Part)rplLink.getOrigin().getTarget());
            }
        }
        for (Part part : rplScope.getLeftParts()) {
            for (CatalogElementLink rplLink : rplScope.left.getOwnedLinks()) {
                if (rplLink.getTarget() != part) continue;
                recScope.leftParts.add((Part)rplLink.getOrigin().getTarget());
            }
        }
        for (Part recPart : recScope.getLeftParts()) {
            for (CatalogElementLink rplLink : rplScope.left.getOwnedLinks()) {
                if (rplLink.getOrigin().getTarget() != recPart) continue;
                rplScope.leftParts.add((Part)rplLink.getTarget());
            }
        }
        for (Part recPart : recScope.getRightParts()) {
            for (CatalogElementLink rplLink : rplScope.right.getOwnedLinks()) {
                if (rplLink.getOrigin().getTarget() != recPart) continue;
                rplScope.rightParts.add((Part)rplLink.getTarget());
            }
        }
        recScope.exchangeItems.addAll(rplScope.getExchangeItems());
        rplScope.exchangeItems.addAll(recScope.getExchangeItems());
    }

    public SparseModelScope asDiffmergeScope() {
        HashSet<Object> elements = new HashSet<Object>();
        elements.addAll(this.getComponentExchanges());
        elements.addAll(this.getFunctionalExchanges());
        elements.addAll(this.getPhysicalLinks());
        elements.addAll(this.getLeftPorts());
        elements.addAll(this.getRightPorts());
        elements.addAll(this.getLeftPhysicalLinkEnds());
        elements.addAll(this.getRightPhysicalLinkEnds());
        elements.addAll(this.getRightComponentExchangeEnds());
        elements.addAll(this.getLeftComponentExchangeEnds());
        elements.addAll(this.getLeftParts());
        elements.addAll(this.getRightParts());
        elements.addAll(this.cefeAllocations);
        elements.addAll(this.plceAllocations);
        elements.addAll(this.exchangeItems);
        SparseModelScope result = new SparseModelScope(elements);
        result.getExternalReferenceElements().addAll(this.getLeftPorts());
        result.getExternalReferenceElements().addAll(this.getRightPorts());
        result.getExternalReferenceElements().addAll(this.getLeftParts());
        result.getExternalReferenceElements().addAll(this.getRightParts());
        result.getExternalReferenceElements().addAll(this.exchangeItems);
        result.setAttachHandler(this);
        return result;
    }
}

