/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext.fields;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.ui.properties.helpers.NotificationHelper;
import org.polarsys.capella.core.ui.properties.richtext.RichtextManager;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.intf.SaveStrategy;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.widget.helper.MDERichtextWidgetHelper;

public abstract class ElementDescriptionGroup {
    private static final String FAMILY_DEFERRED_REFRESH = "org.polarsys.capella.core.ui.properties.richtext.refreshJobFamily";
    private static final String FAMILY_LOAD_DATA_REFRESH = "org.polarsys.capella.core.ui.properties.richtext.loadDataJobFamily";
    protected EObject semanticElement;
    protected EStructuralFeature semanticFeature;
    private ISection section;
    protected MDERichTextWidget descriptionTextField;
    protected Composite descriptionContainer;
    protected GridData infoLabelGridData;
    protected Label infoLabel;
    protected Button reloadBtn;
    protected GridData reloadBtnGridData;
    protected Composite parentComposite;
    private String baseHrefPath;
    private static final String EXISTED_EDITOR_TEXT = "The description is currently opened in an editor. Please use this editor to edit your description.";
    private static final String EDITOR_LOADING_TEXT = "Attempt(s) loading the editor: ";

    public ElementDescriptionGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, ISection section) {
        this.parentComposite = parent;
        this.infoLabel = widgetFactory.createLabel(parent, EXISTED_EDITOR_TEXT);
        this.reloadBtn = widgetFactory.createButton(parent, "Reload", 8);
        this.reloadBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementDescriptionGroup.this.loadData(ElementDescriptionGroup.this.semanticElement, ElementDescriptionGroup.this.semanticFeature);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.infoLabelGridData = new GridData(4, 0x1000000, false, false);
        this.infoLabel.setLayoutData((Object)this.infoLabelGridData);
        this.hideInfoText();
        this.reloadBtnGridData = new GridData(1, 0x1000000, false, false);
        this.reloadBtn.setLayoutData((Object)this.reloadBtnGridData);
        this.hideReloadButton();
        this.descriptionContainer = new Composite(parent, 0){

            public boolean setFocus() {
                return true;
            }

            protected void checkSubclass() {
            }
        };
        if (widgetFactory != null) {
            widgetFactory.adapt(this.descriptionContainer);
        }
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(this.descriptionContainer);
        this.descriptionContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionTextField = RichtextManager.getInstance().getRichtextWidget(this.descriptionContainer);
        this.descriptionTextField.setSaveStrategy((SaveStrategy)new SavingStrategy());
        this.section = section;
    }

    public void aboutToBeShown() {
        if (this.updateDescriptionEditability(this.semanticElement, this.semanticFeature)) {
            try {
                if (this.semanticElement != null && this.semanticFeature != null) {
                    ((SavingStrategy)this.descriptionTextField.getSaveStrategy()).ensureLastSave();
                    this.descriptionTextField.bind(this.semanticElement, this.semanticFeature);
                    this.descriptionTextField.setSaveStrategy((SaveStrategy)new SavingStrategy(this.semanticElement, this.semanticFeature));
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    public void aboutToBeHidden() {
        this.hideEditor();
    }

    public void dispose() {
    }

    protected void executeCommand(final ICommand command, final EObject owner, final EStructuralFeature feature) {
        ExecutionManager executionManager;
        if (command == null) {
            return;
        }
        Object cmd = command;
        if (command instanceof AbstractReadWriteCommand) {
            cmd = new AbstractReadWriteCommand(){

                public void run() {
                    command.run();
                }

                public Collection<?> getAffectedObjects() {
                    return Collections.singletonList(owner);
                }

                public String getName() {
                    return "Model Edition";
                }

                public void commandInterrupted() {
                    this.commandRolledBack();
                }

                public void commandRolledBack() {
                    IReadOnlySectionHandler roHandler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
                    if (roHandler != null && roHandler.isLockedByOthers(owner)) {
                        return;
                    }
                    ElementDescriptionGroup.this.loadData(owner, feature);
                }
            };
        }
        if ((executionManager = TransactionHelper.getExecutionManager((EObject)owner)) != null) {
            executionManager.execute(cmd);
        }
    }

    public void setEnabled(boolean enabled) {
        try {
            if (this.descriptionTextField.isReady()) {
                this.descriptionTextField.setEditable(enabled);
            } else {
                this.scheduleDeferredRefresh();
            }
        }
        catch (Exception e) {
            this.scheduleDeferredRefresh();
        }
        this.descriptionContainer.setEnabled(enabled);
    }

    protected void scheduleDeferredRefresh() {
        Job[] jobs = Job.getJobManager().find((Object)FAMILY_DEFERRED_REFRESH);
        if (this.section != null && jobs.length == 0) {
            UIJob job = new UIJob("Refresh of Description editor"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ElementDescriptionGroup.this.section.refresh();
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return ElementDescriptionGroup.FAMILY_DEFERRED_REFRESH.equals(family);
                }
            };
            job.setSystem(true);
            job.schedule(1000L);
        }
    }

    public void loadData(EObject element, EStructuralFeature feature) {
        if (!this.parentComposite.isDisposed() && this.parentComposite.isVisible()) {
            try {
                if (this.updateDescriptionEditability(element, feature)) {
                    this.loadEditorContent(element, feature);
                } else if (element != this.semanticElement) {
                    this.semanticElement = element;
                    this.semanticFeature = feature;
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    protected void loadEditorContent(EObject element, EStructuralFeature feature) {
        this.semanticElement = element;
        this.semanticFeature = feature;
        if (this.descriptionTextField instanceof MDENebulaBasedRichTextWidget) {
            ((MDENebulaBasedRichTextWidget)this.descriptionTextField).setDirtyStateUpdated(true);
        }
        ((SavingStrategy)this.descriptionTextField.getSaveStrategy()).ensureLastSave();
        this.descriptionTextField.bind(this.semanticElement, this.semanticFeature);
        this.descriptionTextField.setSaveStrategy((SaveStrategy)new SavingStrategy(this.semanticElement, this.semanticFeature));
    }

    protected void setDataValue(final EObject object, final EStructuralFeature feature, final Object value) {
        if (NotificationHelper.isNotificationRequired((EObject)object, (EStructuralFeature)feature, (Object)value)) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    object.eSet(feature, value);
                }
            };
            this.executeCommand((ICommand)command, object, feature);
        }
    }

    public void saveDescription(String newDescription) {
        this.descriptionTextField.setText(newDescription);
        this.descriptionTextField.saveContent();
    }

    public void save(String value) {
        this.saveDescription(value);
    }

    public void save() {
        if (this.descriptionTextField.getElement() != null && this.descriptionTextField.getFeature() != null) {
            this.descriptionTextField.saveContent();
        }
    }

    public String getValueToSave() {
        return this.descriptionTextField.getText();
    }

    protected boolean updateDescriptionEditability(EObject object, EStructuralFeature feature) {
        boolean isValidState;
        boolean isEditable = MDERichtextWidgetHelper.getActiveMDERichTextEditors((EObject)object).isEmpty();
        boolean isOn = RichtextManager.getInstance().isOnWidget(this.descriptionContainer);
        boolean isVisible = this.descriptionContainer.isVisible();
        boolean bl = isValidState = isEditable && isVisible && isOn || !isEditable && !isVisible && !isOn;
        if (!isValidState) {
            this.descriptionContainer.setVisible(isEditable);
            if (isEditable) {
                this.hideInfoText();
                this.hideReloadButton();
                this.descriptionTextField = this.showEditor();
                this.descriptionTextField.setSaveStrategy((SaveStrategy)new SavingStrategy(this.semanticElement, this.semanticFeature));
            } else {
                this.showExistedEditorText();
                this.hideEditor();
            }
            isValidState = true;
            if (this.descriptionTextField.isLoading()) {
                final int[] counter = new int[]{1};
                Job[] jobs = Job.getJobManager().find((Object)FAMILY_LOAD_DATA_REFRESH);
                if (jobs.length == 0) {
                    UIJob job = new UIJob("Load editor data"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (ElementDescriptionGroup.this.descriptionTextField.isLoading()) {
                                ElementDescriptionGroup.this.hideEditor();
                                int n = counter[0];
                                counter[0] = n + 1;
                                ElementDescriptionGroup.this.showEditorLoadingText(n);
                                if (counter[0] > 10) {
                                    ElementDescriptionGroup.this.showReloadButton();
                                } else {
                                    this.schedule(1000L);
                                }
                            } else {
                                ElementDescriptionGroup.this.loadData(ElementDescriptionGroup.this.semanticElement, ElementDescriptionGroup.this.semanticFeature);
                            }
                            return Status.OK_STATUS;
                        }

                        public boolean belongsTo(Object family) {
                            return ElementDescriptionGroup.FAMILY_LOAD_DATA_REFRESH.equals(family);
                        }
                    };
                    job.setSystem(true);
                    job.schedule(1000L);
                }
                return false;
            }
        }
        return isValidState && isEditable;
    }

    protected void showEditorLoadingText(int counter) {
        this.infoLabel.setText(EDITOR_LOADING_TEXT + counter);
        this.infoLabel.setVisible(true);
        this.infoLabelGridData.exclude = false;
        this.parentComposite.layout(true);
    }

    protected void showExistedEditorText() {
        this.infoLabel.setText(EXISTED_EDITOR_TEXT);
        this.infoLabel.setVisible(true);
        this.infoLabelGridData.exclude = false;
        this.parentComposite.layout(true);
    }

    protected void hideInfoText() {
        this.infoLabel.setVisible(false);
        this.infoLabelGridData.exclude = true;
        this.parentComposite.layout(true);
    }

    protected void showReloadButton() {
        this.reloadBtn.setVisible(true);
        this.reloadBtnGridData.exclude = false;
        this.parentComposite.layout(true);
    }

    protected void hideReloadButton() {
        this.reloadBtn.setVisible(false);
        this.reloadBtnGridData.exclude = true;
        this.parentComposite.layout(true);
    }

    protected MDERichTextWidget showEditor() {
        MDERichTextWidget widget = !RichtextManager.getInstance().isOnWidget(this.descriptionContainer) ? RichtextManager.getInstance().addWidget(this.descriptionContainer) : RichtextManager.getInstance().getRichtextWidget(this.descriptionContainer);
        widget.setBaseHrefPath(this.baseHrefPath);
        return widget;
    }

    protected void hideEditor() {
        if (!this.descriptionContainer.isDisposed() && RichtextManager.getInstance().isOnWidget(this.descriptionContainer)) {
            RichtextManager.getInstance().removeWidget(this.descriptionContainer);
        }
    }

    public boolean shouldRefresh() {
        return this.descriptionTextField == null || !this.descriptionTextField.hasFocus();
    }

    public String getBaseHrefPath() {
        return this.baseHrefPath;
    }

    public void setBaseHrefPath(String baseHrefPath) {
        this.baseHrefPath = baseHrefPath;
    }

    private class SavingStrategy
    implements SaveStrategy {
        EObject owner;
        EStructuralFeature feature;
        Boolean lastSave = null;

        public SavingStrategy() {
        }

        public SavingStrategy(EObject owner, EStructuralFeature feature) {
            this.owner = owner;
            this.feature = feature;
        }

        public void save(String editorText, EObject owner, EStructuralFeature feature) {
            if (this.lastSave == null && this.owner == owner && this.feature == feature) {
                ElementDescriptionGroup.this.setDataValue(owner, feature, editorText);
            } else if (Boolean.TRUE.equals(this.lastSave)) {
                ElementDescriptionGroup.this.setDataValue(owner, feature, editorText);
                this.lastSave = Boolean.FALSE;
            }
        }

        public void ensureLastSave() {
            if (this.lastSave == null) {
                this.lastSave = Boolean.TRUE;
            }
        }
    }
}

