/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.preferences;

import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.core.transition.system.topdown.preferences.BooleanPropertyPreference;

public class PreferenceHelper {
    private IProperties properties = new PropertiesLoader().getProperties("capella.core.transition.system.topdown.preferences");
    private IPropertyContext propertyContext = new PropertyContext(this.properties);
    private static PreferenceHelper instance;

    private PreferenceHelper() {
    }

    public static PreferenceHelper getInstance() {
        if (instance == null) {
            instance = new PreferenceHelper();
        }
        return instance;
    }

    public IPropertyContext getPropertyContext() {
        return this.propertyContext;
    }

    public IProperties getProperties() {
        return this.properties;
    }

    protected boolean getBooleanValue(String id) {
        IProperty property = this.properties.getProperty(id);
        if (property != null) {
            Object value = property.getValue(this.propertyContext);
            if (value instanceof String) {
                try {
                    return Boolean.valueOf((String)value);
                }
                catch (Exception exception) {
                }
            } else if (value instanceof Boolean) {
                return (Boolean)value;
            }
        }
        return false;
    }

    protected String getStringValue(String id, String defaultValue) {
        Object value;
        IProperty property = this.properties.getProperty(id);
        if (property != null && (value = property.getValue(this.propertyContext)) != null) {
            return value.toString();
        }
        return defaultValue;
    }

    public void setBooleanValue(String id, Boolean value) {
        IProperty property = this.properties.getProperty(id);
        this.propertyContext.setCurrentValue(property, (Object)value);
        if (property instanceof BooleanPropertyPreference) {
            BooleanPropertyPreference booleanPreference = (BooleanPropertyPreference)property;
            booleanPreference.setValue(this.propertyContext);
        }
    }

    public boolean isLC2PCLeafStrategy() {
        return this.getBooleanValue("projection.lcpc.mode");
    }

    public boolean transitionExchangeItemWhileInterfaceTransition() {
        return this.getBooleanValue("projection.exchangeItems");
    }

    public boolean transitionFunctionalElementWhileComponentTransition() {
        return this.getBooleanValue("projection.functional");
    }

    public boolean transitionExchangeItemWhileFunctionalTransition() {
        return this.getBooleanValue("projection.exchangeItems");
    }

    public boolean transitionExchangeItemWhileComponentTransition() {
        return this.getBooleanValue("projection.exchangeItems");
    }

    public boolean transitionDatatypeWhileExchangeItemTransition() {
        return this.getBooleanValue("projection.dataType");
    }

    public boolean transitionStateMachineWhileComponentTransition() {
        return this.getBooleanValue("projection.component.stateMachine");
    }

    public boolean transitionInterfaceWhileComponentTransition() {
        return this.getBooleanValue("interface.mode");
    }

    public boolean generateInterfacesPropagateExchangeItems() {
        return this.getBooleanValue("projection.interfaces.propagateEI");
    }

    public boolean generateInterfacesCreateComponentExchange() {
        return this.getBooleanValue("projection.interfaces.createCE");
    }

    public boolean isFC2FSCreateMsgWithReply() {
        return "fc2fs.msg.with.reply".equals(this.getStringValue("transition.fc2fs.sequence.message.strategy", "fc2fs.msg.one.way"));
    }

    public boolean isOP2OASCreateMsgWithReply() {
        return "op2oas.msg.with.reply".equals(this.getStringValue("transition.op2oas.sequence.message.strategy", "op2oas.msg.one.way"));
    }

    public boolean transitionInitializeTransitionedScenario() {
        return this.getBooleanValue("transition.scenario.initialize");
    }

    public boolean isFC2FSLogEnabled() {
        return this.getBooleanValue("log.enabled");
    }

    public boolean transitionPC2CIWhileScenarioTransition() {
        return this.getBooleanValue("projection.pc2ci.enabled");
    }

    public String getConfigurationItemKind() {
        return this.getStringValue("projection.pc2ci.kind", "COTSCI");
    }
}

