/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.DiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class DefaultDiffLabelDecorator
extends DiffLabelDecorator {
    private static DefaultDiffLabelDecorator __instance = null;
    private final Map<DifferenceColorKind, Integer> _differenceColors = new HashMap<DifferenceColorKind, Integer>();

    public DefaultDiffLabelDecorator() {
        this.initializeDifferenceColors(this._differenceColors);
    }

    public Color getDifferenceColor(DifferenceColorKind colorKind_p) {
        int colorCode = 2;
        Integer colorCodeI = this._differenceColors.get((Object)colorKind_p);
        if (colorCodeI != null) {
            colorCode = colorCodeI;
        }
        return UIUtil.getColor(colorCode);
    }

    protected DifferenceColorKind getDifferenceColorKind(DifferenceKind originKind_p) {
        DifferenceColorKind result;
        if (originKind_p == null) {
            result = DifferenceColorKind.DEFAULT;
        } else {
            switch (originKind_p) {
                case NONE: {
                    result = DifferenceColorKind.NONE;
                    break;
                }
                case CONFLICT: {
                    result = DifferenceColorKind.CONFLICT;
                    break;
                }
                case FROM_LEFT: 
                case FROM_RIGHT: 
                case FROM_BOTH: 
                case MODIFIED: {
                    result = DifferenceColorKind.BOTH;
                    break;
                }
                case FROM_LEFT_ADD: 
                case FROM_RIGHT_DEL: {
                    result = DifferenceColorKind.LEFT;
                    break;
                }
                case FROM_LEFT_DEL: 
                case FROM_RIGHT_ADD: {
                    result = DifferenceColorKind.RIGHT;
                    break;
                }
                case COUNTED: {
                    result = DifferenceColorKind.NONE;
                    break;
                }
                default: {
                    result = DifferenceColorKind.DEFAULT;
                }
            }
        }
        return result;
    }

    @Override
    public Font getFont(Object object_p, Font base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        Font result = super.getFont(object_p, base_p, diffKind_p, side_p, node_p);
        if (result != null && diffKind_p == DifferenceKind.COUNTED) {
            result = UIUtil.getItalic(result);
        }
        if (result != null && diffKind_p != null && !diffKind_p.isNeutral()) {
            result = UIUtil.getBold(result);
        }
        return result;
    }

    @Override
    public Color getForeground(Object object_p, Color base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        DifferenceColorKind colorKind = DifferenceColorKind.NONE;
        if (side_p != null && node_p != null && (diffKind_p != null && !diffKind_p.isNeutral() || object_p == node_p.getActualComparison().getScope(side_p))) {
            boolean isLeftSide = this.isLeftSide(side_p, node_p);
            colorKind = isLeftSide ? DifferenceColorKind.LEFT : DifferenceColorKind.RIGHT;
        } else if (side_p == null) {
            colorKind = this.getDifferenceColorKind(diffKind_p);
            if (object_p instanceof EStructuralFeature && colorKind == DifferenceColorKind.NONE) {
                colorKind = DifferenceColorKind.DEFAULT;
            }
        }
        Color result = this.getDifferenceColor(colorKind);
        return result;
    }

    @Override
    protected EMFDiffMergeUIPlugin.ImageID getImageOverlay(Object object_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        EMFDiffMergeUIPlugin.ImageID result = null;
        if (diffKind_p != null) {
            switch (diffKind_p) {
                case FROM_LEFT: {
                    result = EMFDiffMergeUIPlugin.ImageID.OUT_STAT;
                    break;
                }
                case FROM_LEFT_ADD: {
                    result = EMFDiffMergeUIPlugin.ImageID.OUT_ADD_STAT;
                    break;
                }
                case FROM_LEFT_DEL: {
                    result = EMFDiffMergeUIPlugin.ImageID.OUT_REM_STAT;
                    break;
                }
                case FROM_RIGHT: {
                    result = EMFDiffMergeUIPlugin.ImageID.INC_STAT;
                    break;
                }
                case FROM_RIGHT_ADD: {
                    result = EMFDiffMergeUIPlugin.ImageID.INC_ADD_STAT;
                    break;
                }
                case FROM_RIGHT_DEL: {
                    result = EMFDiffMergeUIPlugin.ImageID.INC_REM_STAT;
                    break;
                }
                case FROM_BOTH: 
                case MODIFIED: {
                    result = EMFDiffMergeUIPlugin.ImageID.MODIFIED_STAT;
                    break;
                }
                case CONFLICT: {
                    result = EMFDiffMergeUIPlugin.ImageID.CONFLICT_STAT;
                    break;
                }
            }
        }
        return result;
    }

    public static DefaultDiffLabelDecorator getInstance() {
        if (__instance == null) {
            __instance = new DefaultDiffLabelDecorator();
        }
        return __instance;
    }

    protected void initializeDifferenceColors(Map<DifferenceColorKind, Integer> differenceColorsMap_p) {
        differenceColorsMap_p.put(DifferenceColorKind.LEFT, 4);
        differenceColorsMap_p.put(DifferenceColorKind.RIGHT, 9);
        differenceColorsMap_p.put(DifferenceColorKind.BOTH, 12);
        differenceColorsMap_p.put(DifferenceColorKind.NONE, 16);
        differenceColorsMap_p.put(DifferenceColorKind.CONFLICT, 3);
        differenceColorsMap_p.put(DifferenceColorKind.DEFAULT, 2);
    }

    public void setDifferenceColor(DifferenceColorKind colorKind_p, int swtColor_p) {
        this._differenceColors.put(colorKind_p, new Integer(swtColor_p));
    }

    public static enum DifferenceColorKind {
        LEFT,
        RIGHT,
        BOTH,
        NONE,
        CONFLICT,
        DEFAULT;

    }
}

