/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.resource.ImageRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModelEvent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModelListener;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;

public class DecompositionModel {
    protected boolean hideTechnicalInterfaces = true;
    private List<DecompositionItem> decompositionItemRemoved;
    private List<Decomposition> decompositions;
    private ImageRegistry imgRegistry;
    private List<DecompositionModelListener> listenersList;
    private List<DecompositionComponent> reusableComponents;
    private DecompositionComponent sourceComponent;

    protected DecompositionModel() {
        this.setSourceComponent(null);
        this.setDecompositions(new ArrayList<Decomposition>(1));
        this.listenersList = new ArrayList<DecompositionModelListener>(1);
        this.setReusableComponents(new ArrayList<DecompositionComponent>(1));
        this.decompositionItemRemoved = new ArrayList<DecompositionItem>();
    }

    public DecompositionModel(DecompositionComponent sourceComponent) {
        this();
        this.setSourceComponent(sourceComponent);
    }

    public boolean doesHideTechnicalInterfaces() {
        return this.hideTechnicalInterfaces;
    }

    public void setHideTechnicalInterfaces(boolean state) {
        this.hideTechnicalInterfaces = state;
    }

    public boolean addDecomposition(Decomposition decomposition) {
        decomposition.setDecompositionModel(this);
        decomposition.setValue(Decomposition.DUMMY_VALUE);
        this.decompositions.add(decomposition);
        this.fireDecompositionAdded(decomposition);
        return true;
    }

    public boolean addDecomposition(Decomposition decomposition, boolean alreadyCreated) {
        decomposition.setDecompositionModel(this);
        this.decompositions.add(decomposition);
        return true;
    }

    public boolean addDecomposition(String name) {
        Decomposition decomposition = new Decomposition();
        decomposition.setName(name);
        return this.addDecomposition(decomposition);
    }

    public void addDecompositionItemRemoved(DecompositionItem decItem) {
        this.decompositionItemRemoved.add(decItem);
    }

    public void addDecompositionModelListener(DecompositionModelListener listener) {
        this.listenersList.add(listener);
    }

    public boolean addNewTargetComponent(Decomposition decomposition, DecompositionComponent targetComp) {
        decomposition.addTargetComponent(targetComp);
        this.fireTargetComponentAdded(this.decompositions.size() == 1 ? null : decomposition, targetComp);
        this.setPathForNewTargetComponent(targetComp);
        return true;
    }

    public void addReusedComponent(DecompositionComponent comp) {
        this.reusableComponents.add(comp);
    }

    public boolean attachInterface(DecompositionComponent component_p, DecompositionItem item_p) {
        component_p.addItem(item_p);
        item_p.setParentComponent(component_p);
        this.fireInterfaceAttached(component_p, item_p);
        this.refreshStatus(component_p.getParentDecomposition(), item_p.isInterfaceUsage());
        return true;
    }

    public boolean attachService(DecompositionComponent component_p, DecompositionItemService itemSce_p) {
        return this.attachService(component_p, itemSce_p, null);
    }

    public boolean attachService(DecompositionComponent component, DecompositionItemService itemSce, DecompositionItem item) {
        List<DecompositionItem> itfWithScesFoundList = this.getItemInterfaceListContainSce(component.getItems(), itemSce, INTERFACE_KIND.External);
        for (DecompositionItem currentItf : itfWithScesFoundList) {
            this.detachInterface(component, currentItf);
        }
        DecompositionItem decItem = new DecompositionItem(this.getUniqName(component.getItems()), null, 2);
        decItem.setInterfaceUsage(itemSce.isUsed());
        decItem.addServiceItems(itemSce);
        decItem.addOriginInterfaces(item.getValue());
        itemSce.setParentDecompositionItem(decItem);
        return this.attachInterface(component, decItem);
    }

    public boolean attachService(DecompositionItem itf, DecompositionItemService sce) {
        return this.attachService(itf, sce, itf);
    }

    public boolean attachService(DecompositionItem itf, DecompositionItemService sce, DecompositionItem item) {
        List<DecompositionItem> itfWithScesFoundList = this.getItemInterfaceListContainSce(itf.getParentComponent().getItems(), sce, INTERFACE_KIND.External);
        for (DecompositionItem currentItf : itfWithScesFoundList) {
            this.detachInterface(itf.getParentComponent(), currentItf);
        }
        itf.addServiceItems(sce);
        itf.addOriginInterfaces(item.getValue());
        sce.setParentDecompositionItem(itf);
        this.fireInterfaceAttached(itf.getParentComponent(), itf);
        this.refreshStatus(itf.getParentComponent().getParentDecomposition(), itf.isInterfaceUsage());
        return true;
    }

    private boolean checkServiceDelegated(DecompositionItemService itemSce, List<DecompositionItem> itemListItf, boolean isUsed) {
        for (DecompositionItem itemItf : itemListItf) {
            if (itemItf.isInterfaceUsage() != isUsed) continue;
            for (DecompositionItemService serviceItem : itemItf.getServiceItems()) {
                CapellaElement opOrigin;
                if (this.checkEqualDecompositionItemService(itemSce, serviceItem)) {
                    return true;
                }
                List listMelo = RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)((CapellaElement)serviceItem.getValue()), (EClass)InformationPackage.Literals.OPERATION);
                if (listMelo.size() == 0 || (opOrigin = (CapellaElement)listMelo.get(0)) != itemSce.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkEqualDecompositionItemService(DecompositionItemService itemSce1, DecompositionItemService itemSce2) {
        if (itemSce1.getValue() instanceof ExchangeItemAllocation && itemSce2.getValue() instanceof ExchangeItemAllocation) {
            return ((ExchangeItemAllocation)itemSce1.getValue()).getAllocatedItem() == ((ExchangeItemAllocation)itemSce2.getValue()).getAllocatedItem();
        }
        return itemSce1.getValue() == itemSce2.getValue();
    }

    private boolean checkServicesDelegated(DecompositionItem itemItf_p, List<DecompositionItem> itemListItf_p) {
        for (DecompositionItemService itemSce : itemItf_p.getServiceItems()) {
            if (!this.checkServiceDelegated(itemSce, itemListItf_p, itemItf_p.isInterfaceUsage())) continue;
            return true;
        }
        return false;
    }

    public boolean detachInterface(DecompositionComponent component, DecompositionItem item) {
        component.removeItem(item);
        this.fireInterfaceDetached(component, item);
        this.refreshStatus(component.getParentDecomposition(), item.isInterfaceUsage());
        return true;
    }

    public boolean detachService(DecompositionItem itemItf, DecompositionItemService itemSce) {
        DecompositionComponent component = itemItf.getParentComponent();
        itemItf.removeItem(itemSce);
        this.fireInterfaceAttached(component, itemItf);
        this.refreshStatus(component.getParentDecomposition(), itemItf.isInterfaceUsage());
        return true;
    }

    public boolean finishDecomposition() {
        DecompositionModelEvent event = new DecompositionModelEvent(this, null, null, null, null, 12);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireAllDecompositionRemoved() {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), null, null, null, 3);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireAllTargetComponentRemoved(Decomposition decomposition) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), null, decomposition, null, 7);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireDecompositionAdded(Decomposition newDecomposition) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), null, newDecomposition, null, 1);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireDecompositionRemoved(Decomposition decomposition) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), null, decomposition, null, 2);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireDecompositionRenamed(Decomposition decomposition, String newName) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), null, decomposition, newName, 4);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireInterfaceAttached(DecompositionComponent targetComponent, DecompositionItem decompositionItem) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), targetComponent, null, decompositionItem, 9);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireInterfaceDetached(DecompositionComponent targetComponent, DecompositionItem decompositionItem) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), targetComponent, null, decompositionItem, 10);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected void fireModelChanged(DecompositionModelEvent event) {
        for (DecompositionModelListener listener : this.getListeners()) {
            listener.decompositionChanged(event);
        }
    }

    protected boolean fireTargetComponentAdded(Decomposition decomposition, DecompositionComponent comp) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), comp, decomposition, null, 5);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireTargetComponentRemoved(Decomposition decomposition, DecompositionComponent targetComp) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), targetComp, decomposition, null, 6);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    protected boolean fireTargetComponentRenamed(DecompositionComponent targetComp, String newName) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), targetComp, null, newName, 8);
        this.fireModelChanged(event);
        return event.isOperationSuccess();
    }

    public int getAssignmentCount(DecompositionItem decompositionItem, Decomposition decomp) {
        int count = 0;
        for (DecompositionComponent comp : decomp.getTargetComponents()) {
            for (DecompositionItem item : comp.getItems()) {
                if (!item.equals(decompositionItem)) continue;
                ++count;
            }
        }
        if (count == 0) {
            for (DecompositionItemService itemSce : decompositionItem.getServiceItems()) {
                boolean assigned = false;
                for (DecompositionComponent comp : decomp.getTargetComponents()) {
                    if (!this.checkServiceDelegated(itemSce, comp.getItems(), decompositionItem.isInterfaceUsage())) continue;
                    assigned = true;
                }
                if (assigned) continue;
                return count;
            }
            if (decompositionItem.getServiceItems().isEmpty()) {
                return count;
            }
            count = 1;
        }
        return count;
    }

    public List<DecompositionItem> getDecompositionItemRemoved() {
        return this.decompositionItemRemoved;
    }

    public List<Decomposition> getDecompositions() {
        return this.decompositions;
    }

    public ImageRegistry getImgRegistry() {
        return this.imgRegistry;
    }

    private List<DecompositionItem> getItemInterfaceListContainSce(List<DecompositionItem> decompositionItems, DecompositionItemService itemSce, INTERFACE_KIND itfKind) {
        ArrayList<DecompositionItem> itemItfContainSc = new ArrayList<DecompositionItem>();
        for (DecompositionItem currentItf : decompositionItems) {
            if (itfKind == INTERFACE_KIND.Internal) {
                if (!currentItf.isInternal() || !this.isServiceDefinedInDecompositionItem(currentItf.getServiceItems(), itemSce)) continue;
                itemItfContainSc.add(currentItf);
                continue;
            }
            if (itfKind != INTERFACE_KIND.External || currentItf.isInternal() || !this.isServiceDefinedInDecompositionItem(currentItf.getServiceItems(), itemSce)) continue;
            itemItfContainSc.add(currentItf);
        }
        return itemItfContainSc;
    }

    public List<DecompositionModelListener> getListeners() {
        return this.listenersList;
    }

    public List<DecompositionComponent> getReusableComponents() {
        return this.reusableComponents;
    }

    public DecompositionComponent getSourceComponent() {
        return this.sourceComponent;
    }

    private String getUniqName(List<DecompositionItem> itemsList) {
        String prefixName = "Interface";
        int i = -1;
        ArrayList<String> nameList = new ArrayList<String>();
        for (DecompositionItem itemItf : itemsList) {
            int pos = itemItf.getName().lastIndexOf(" [Refined]");
            if (pos != -1) {
                nameList.add(itemItf.getName().substring(0, pos));
                continue;
            }
            nameList.add(itemItf.getName());
        }
        String uniqName = prefixName;
        while (nameList.contains(uniqName)) {
            uniqName = prefixName.concat(" " + Integer.toString(++i));
        }
        return uniqName;
    }

    private DecompositionComponent getWrappedReusedComponent(Object value) {
        DecompositionModelEvent event = new DecompositionModelEvent(this.getSourceComponent(), null, null, value, 11);
        this.fireModelChanged(event);
        return event.getReusedComponent();
    }

    public boolean isDetachAllowed(Object data) {
        if (data instanceof DecompositionItem) {
            DecompositionItem item = (DecompositionItem)data;
            return !item.getParentComponent().isReusedComponent();
        }
        return false;
    }

    public boolean isDragAllowed(Object source) {
        boolean flag = false;
        if (source == null) {
            return false;
        }
        if (source instanceof DecompositionItem) {
            flag = true;
            if (((DecompositionItem)source).getParentComponent().isReusedComponent()) {
                flag = false;
            }
        } else if (source instanceof DecompositionItemService) {
            flag = this.isOperationDelegated((DecompositionItemService)source);
        }
        return flag;
    }

    public boolean isDropAllowed(Object target) {
        if (target == null) {
            return false;
        }
        if (target instanceof DecompositionComponent) {
            return true;
        }
        return target instanceof DecompositionItem;
    }

    public boolean isDropPossible(Object node, Object item) {
        if (node == null) {
            return false;
        }
        if (node instanceof DecompositionComponent && item instanceof DecompositionItem) {
            DecompositionComponent comp = (DecompositionComponent)node;
            DecompositionItem itemItf = (DecompositionItem)item;
            List<DecompositionItem> items = comp.getItems();
            for (DecompositionItem decompositionItem : items) {
                if (!decompositionItem.equals(item)) continue;
                if (decompositionItem.isInterfaceUsage() && ((DecompositionItem)item).isInterfaceUsage()) {
                    return false;
                }
                if (decompositionItem.isInterfaceUsage() || ((DecompositionItem)item).isInterfaceUsage()) continue;
                return false;
            }
            return !this.checkServicesDelegated(itemItf, comp.getItems()) && !comp.isReusedComponent();
        }
        if (item instanceof DecompositionItemService) {
            if (node instanceof DecompositionItem) {
                DecompositionItem itemItf = (DecompositionItem)node;
                DecompositionItemService itemSce = (DecompositionItemService)item;
                return itemItf.isInternal() && itemItf.isInterfaceUsage() == itemSce.isUsed() && this.getItemInterfaceListContainSce(itemItf.getParentComponent().getItems(), itemSce, INTERFACE_KIND.Internal).size() == 0;
            }
            if (node instanceof DecompositionComponent) {
                DecompositionComponent itemComponent = (DecompositionComponent)node;
                DecompositionItemService itemSce = (DecompositionItemService)item;
                return this.getItemInterfaceListContainSce(itemComponent.getItems(), itemSce, INTERFACE_KIND.Internal).size() == 0;
            }
        }
        return false;
    }

    private boolean isOperationDelegated(DecompositionItemService itemSce) {
        boolean flag = true;
        CapellaElement op = (CapellaElement)itemSce.getValue();
        if (RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)op, (EClass)InformationPackage.Literals.OPERATION).size() == 0) {
            ArrayList<CapellaElement> listOp = new ArrayList<CapellaElement>();
            for (DecompositionItem decItemSrc : this.sourceComponent.getItems()) {
                for (DecompositionItemService itemSceSrc : decItemSrc.getServiceItems()) {
                    listOp.add((CapellaElement)itemSceSrc.getValue());
                }
            }
            if (!listOp.contains(op)) {
                flag = false;
            }
        }
        return flag;
    }

    public boolean isRemoveAllowed(Object target) {
        if (target instanceof DecompositionComponent) {
            return true;
        }
        return target instanceof DecompositionItem && ((DecompositionItem)target).isInternal();
    }

    public boolean isRenameAllowed(Object target) {
        return target instanceof DecompositionComponent;
    }

    private boolean isServiceDefinedInDecompositionItem(List<DecompositionItemService> serviceItems, DecompositionItemService itemSce) {
        for (DecompositionItemService currentItemSce : serviceItems) {
            CapellaElement opOrigin;
            if (this.checkEqualDecompositionItemService(currentItemSce, itemSce)) {
                return true;
            }
            List listMelo = RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)((CapellaElement)currentItemSce.getValue()), (EClass)InformationPackage.Literals.OPERATION);
            if (listMelo.size() == 0 || (opOrigin = (CapellaElement)listMelo.get(0)) != itemSce.getValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isValidName(String name) {
        for (Decomposition decomp : this.decompositions) {
            if (!decomp.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void refreshStatus(Decomposition decomposition) {
        for (DecompositionItem item : this.sourceComponent.getItems()) {
            int count = this.getAssignmentCount(item, decomposition);
            this.setStatus(item, count);
        }
    }

    public void refreshStatus(Decomposition decomposition, boolean isUsed) {
        for (DecompositionItem item : this.sourceComponent.getItems()) {
            if (item.isInterfaceUsage() != isUsed) continue;
            int count = this.getAssignmentCount(item, decomposition);
            this.setStatus(item, count);
        }
    }

    public void refreshStatusForSynthesisCheck() {
        for (DecompositionItem item : this.sourceComponent.getItems()) {
            item.clearMessages();
            for (Decomposition decomp : this.getDecompositions()) {
                int count = this.getAssignmentCount(item, decomp);
                if (count == 0) {
                    item.setStatus(2);
                } else if (count == 1) {
                    item.setStatus(1);
                    item.removeStatus(decomp.getName());
                } else if (count > 1) {
                    item.setStatus(3);
                }
                if (count == 1) continue;
                item.addDecompositionNameForStatus(item.getStatus(), decomp.getName());
            }
            Set<Integer> keys = item.getStatusKeys();
            if (keys.contains(2)) {
                for (String name : item.getDecompositionNames(2)) {
                    item.addStatusMessage(String.valueOf(Messages.getString("LCDecomp.interface.child.unassignedmsg")) + name);
                }
                item.setStatus(2);
            }
            if (!keys.contains(3)) continue;
            for (String name : item.getDecompositionNames(3)) {
                item.addStatusMessage(String.valueOf(Messages.getString("LCDecomp.interface.child.ambiguousmsg")) + name);
            }
            item.setStatus(3);
        }
    }

    public boolean removeAllDecomposition() {
        this.decompositions.clear();
        this.fireAllDecompositionRemoved();
        return true;
    }

    public boolean removeAllTargetComponents(Decomposition decomposition) {
        decomposition.removeAllTargetComponents();
        this.reusableComponents.clear();
        this.fireAllTargetComponentRemoved(decomposition);
        this.refreshStatus(decomposition);
        return true;
    }

    public boolean removeDecomposition(Decomposition decomposition) {
        this.decompositions.remove(decomposition);
        this.fireDecompositionRemoved(decomposition);
        return true;
    }

    public void removeDecompositionModelListener(DecompositionModelListener listener) {
        this.listenersList.remove(listener);
    }

    public void removeReusedComponent(DecompositionComponent comp) {
        this.reusableComponents.remove(comp);
    }

    public boolean removeTargetComponent(Decomposition decomposition, DecompositionComponent targetComp) {
        decomposition.removeTargetComponent(targetComp);
        if (targetComp.isReusedComponent()) {
            this.removeReusedComponent(targetComp);
        }
        this.fireTargetComponentRemoved(decomposition, targetComp);
        this.refreshStatus(targetComp.getParentDecomposition());
        return true;
    }

    public boolean renameDecomposition(Decomposition decomposition, String name) {
        decomposition.setName(name);
        this.fireDecompositionRenamed(decomposition, name);
        for (DecompositionComponent comp : decomposition.getTargetComponents()) {
            this.setPathForNewTargetComponent(comp);
        }
        return true;
    }

    public boolean renameTargetComponent(DecompositionComponent targetComp, String newName) {
        targetComp.setName(newName);
        this.fireTargetComponentRenamed(targetComp, newName);
        return true;
    }

    public boolean reuseTargetComponent(Decomposition decomposition, Object value) {
        for (DecompositionComponent comp : decomposition.getTargetComponents()) {
            if (!value.equals(comp.getReusedTarget())) continue;
            return false;
        }
        DecompositionComponent shortcutComp = this.getWrappedReusedComponent(value);
        decomposition.addTargetComponent(shortcutComp);
        this.addReusedComponent(shortcutComp);
        this.fireTargetComponentAdded(this.decompositions.size() == 1 ? null : decomposition, shortcutComp);
        this.refreshStatus(decomposition);
        return true;
    }

    protected void setDecompositions(List<Decomposition> decompositions) {
        this.decompositions = decompositions;
    }

    public void setImgRegistry(ImageRegistry imgRegistry) {
        this.imgRegistry = imgRegistry;
    }

    public void setPathForNewTargetComponent(DecompositionComponent targetComponent) {
        if (targetComponent != null && !targetComponent.isReusedComponent()) {
            StringBuilder builder = new StringBuilder(this.getSourceComponent().getPath());
            builder.append("::");
            if (this.getDecompositions().size() > 1) {
                builder.append(targetComponent.getParentDecomposition().getName());
                builder.append("::");
            }
            builder.append(targetComponent.getName());
            targetComponent.setPath(builder.toString());
        }
    }

    public void setReusableComponents(List<DecompositionComponent> reusedComponents) {
        this.reusableComponents = reusedComponents;
    }

    protected void setSourceComponent(DecompositionComponent sourceData) {
        this.sourceComponent = sourceData;
    }

    public void setStatus(DecompositionItem item, int count) {
        if (count == 0) {
            item.setStatus(2);
            item.setStatusMessage(Messages.getString("LCDecomp.interface.unassigned.tooltip"));
        } else if (count == 1) {
            item.setStatus(1);
            item.setStatusMessage(Messages.getString("LCDecomp.interface.assigned.tooltip"));
        } else if (count > 1) {
            item.setStatus(3);
            item.setStatusMessage(Messages.getString("LCDecomp.interface.ambiguous.tooltip"));
        }
    }

    public boolean isTechnicalInterface(DecompositionItem item) {
        Object value = item.getValue();
        return value instanceof Interface && !((Interface)value).isStructural();
    }

    public static enum INTERFACE_KIND {
        External,
        Internal;

    }
}

