/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.oa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.helpers.fa.delegates.AbstractFunctionHelper;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalProcess;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.Swimlane;

public class OperationalActivityHelper {
    private static OperationalActivityHelper instance;

    private OperationalActivityHelper() {
    }

    public static OperationalActivityHelper getInstance() {
        if (instance == null) {
            instance = new OperationalActivityHelper();
        }
        return instance;
    }

    public Object doSwitch(OperationalActivity element, EStructuralFeature feature) {
        List<ActivityAllocation> ret = null;
        if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__OWNED_SWIMLANES)) {
            ret = this.getOwnedSwimlanes(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__OWNED_PROCESS)) {
            ret = this.getOwnedProcess(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__ACTIVITY_ALLOCATIONS)) {
            ret = this.getActivityAllocations(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__ALLOCATOR_ENTITIES)) {
            ret = this.getAllocatorEntities(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__REALIZING_SYSTEM_FUNCTIONS)) {
            ret = this.getRealizingSystemFunctions(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__ALLOCATING_ROLES)) {
            ret = this.getAllocatingRoles(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__CONTAINED_OPERATIONAL_ACTIVITIES)) {
            ret = this.getContainedOperationalActivities(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ACTIVITY__CHILDREN_OPERATIONAL_ACTIVITIES)) {
            ret = this.getChildrenOperationalActivities(element);
        }
        if (ret == null) {
            ret = AbstractFunctionHelper.getInstance().doSwitch((AbstractFunction)element, feature);
        }
        return ret;
    }

    protected List<ActivityAllocation> getActivityAllocations(OperationalActivity element) {
        ArrayList<ActivityAllocation> ret = new ArrayList<ActivityAllocation>();
        for (AbstractTrace abstractTrace : element.getIncomingTraces()) {
            if (!(abstractTrace instanceof ActivityAllocation)) continue;
            ret.add((ActivityAllocation)abstractTrace);
        }
        return ret;
    }

    protected List<OperationalProcess> getOwnedProcess(OperationalActivity element) {
        ArrayList<OperationalProcess> ret = new ArrayList<OperationalProcess>();
        for (FunctionalChain functionalChain : element.getOwnedFunctionalChains()) {
            if (!(functionalChain instanceof OperationalProcess)) continue;
            ret.add((OperationalProcess)functionalChain);
        }
        return ret;
    }

    protected List<OperationalActivity> getContainedOperationalActivities(OperationalActivity element) {
        ArrayList<OperationalActivity> ret = new ArrayList<OperationalActivity>();
        for (AbstractFunction function : element.getOwnedFunctions()) {
            if (!(function instanceof OperationalActivity)) continue;
            ret.add((OperationalActivity)function);
        }
        return ret;
    }

    protected List<OperationalActivity> getChildrenOperationalActivities(OperationalActivity element) {
        ArrayList<OperationalActivity> ret = new ArrayList<OperationalActivity>();
        for (AbstractFunction function : element.getSubFunctions()) {
            if (!(function instanceof OperationalActivity)) continue;
            ret.add((OperationalActivity)function);
        }
        return ret;
    }

    protected List<Swimlane> getOwnedSwimlanes(OperationalActivity element) {
        ArrayList<Swimlane> ret = new ArrayList<Swimlane>();
        return ret;
    }

    protected List<Entity> getAllocatorEntities(OperationalActivity element) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ComponentFunctionalAllocation) || !((src = trace.getSourceElement()) instanceof Entity)) continue;
            ret.add((Entity)src);
        }
        return ret;
    }

    protected List<SystemFunction> getRealizingSystemFunctions(OperationalActivity element) {
        ArrayList<SystemFunction> ret = new ArrayList<SystemFunction>();
        for (FunctionRealization functionRealization : element.getInFunctionRealizations()) {
            AbstractFunction abstractFunction = functionRealization.getAllocatingFunction();
            if (!(abstractFunction instanceof SystemFunction)) continue;
            ret.add((SystemFunction)abstractFunction);
        }
        return ret;
    }

    protected List<Role> getAllocatingRoles(OperationalActivity element) {
        ArrayList<Role> ret = new ArrayList<Role>();
        for (ActivityAllocation activityAllocation : element.getActivityAllocations()) {
            Role role = activityAllocation.getRole();
            if (role == null) continue;
            ret.add(role);
        }
        return ret;
    }
}

