/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.AbstractTypeHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.helpers.information.delegates.PortHelper;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.information.PortRealization;

public class FunctionPortHelper {
    private static FunctionPortHelper instance;

    private FunctionPortHelper() {
    }

    public static FunctionPortHelper getInstance() {
        if (instance == null) {
            instance = new FunctionPortHelper();
        }
        return instance;
    }

    public Object doSwitch(FunctionPort element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(FaPackage.Literals.FUNCTION_PORT__ALLOCATOR_COMPONENT_PORTS)) {
            ret = this.getAllocatorComponentPorts(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTION_PORT__REALIZED_FUNCTION_PORTS)) {
            ret = this.getRealizedFunctionPorts(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTION_PORT__REALIZING_FUNCTION_PORTS)) {
            ret = this.getRealizingFunctionPorts(element);
        }
        if (ret == null) {
            ret = PortHelper.getInstance().doSwitch((Port)element, feature);
        }
        if (ret == null) {
            ret = AbstractTypeHelper.getInstance().doSwitch((AbstractType)element, feature);
        }
        return ret;
    }

    protected List<ComponentPort> getAllocatorComponentPorts(FunctionPort element) {
        ArrayList<ComponentPort> ret = new ArrayList<ComponentPort>();
        for (PortAllocation portAllocation : element.getIncomingPortAllocations()) {
            Port port = portAllocation.getAllocatingPort();
            if (!(port instanceof ComponentPort)) continue;
            ret.add((ComponentPort)port);
        }
        return ret;
    }

    protected List<FunctionPort> getRealizedFunctionPorts(FunctionPort element) {
        ArrayList<FunctionPort> result = new ArrayList<FunctionPort>();
        for (PortRealization portAllocation : element.getOutgoingPortRealizations()) {
            Port port = portAllocation.getRealizedPort();
            if (!(port instanceof FunctionPort) || result.contains(port)) continue;
            result.add((FunctionPort)port);
        }
        return result;
    }

    protected List<FunctionPort> getRealizingFunctionPorts(FunctionPort element) {
        ArrayList<FunctionPort> result = new ArrayList<FunctionPort>();
        for (PortRealization portAllocation : element.getIncomingPortRealizations()) {
            Port port = portAllocation.getRealizingPort();
            if (!(port instanceof FunctionPort) || result.contains(port)) continue;
            result.add((FunctionPort)port);
        }
        return result;
    }
}

