/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cache;

import java.util.function.Function;
import org.polarsys.capella.core.data.helpers.cache.Cache;

public class ModelCache {
    private static final Cache cache = new Cache();
    private static boolean enabled = false;

    private ModelCache() {
    }

    public static <P, R> R getCache(Function<P, R> function, P parameter) {
        if (enabled) {
            return cache.get(function, parameter);
        }
        return function.apply(parameter);
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
        cache.clearCache();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void clearCache() {
        cache.clearCache();
    }
}

