/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public class LogExt {
    public static String toPriority(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                return "INFO";
            }
            case 8: {
                return "WARN";
            }
            case 2: {
                return "WARN";
            }
            case 4: {
                return "ERROR";
            }
            case 1: {
                return "INFO";
            }
        }
        return "INFO";
    }

    public static Priority convertSeverityToPriority(Diagnostic diag) {
        Level prio = null;
        switch (diag.getSeverity()) {
            case 4: {
                prio = Level.ERROR;
                break;
            }
            case 2: {
                prio = Level.WARN;
                break;
            }
            default: {
                prio = Level.INFO;
            }
        }
        return prio;
    }

    public static void log(Logger logger, IStatus status) {
        logger.log((Priority)Level.toLevel((String)LogExt.toPriority(status)), (Object)status);
    }

    public static void log(String model, IStatus status) {
        LogExt.log(ReportManagerRegistry.getInstance().subscribe(model), status);
    }
}

