/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.registry;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.spi.Filter;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.osgi.framework.Bundle;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.EmbeddedMessageRenderer;
import org.polarsys.capella.common.tools.report.ReportManagerActivator;
import org.polarsys.capella.common.tools.report.StatusRenderer;
import org.polarsys.capella.common.tools.report.appenders.IFlushableAppenders;
import org.polarsys.capella.common.tools.report.appenders.ReportManagerFilter;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.CreateXmlConfiguration;
import org.polarsys.capella.common.tools.report.util.IJobConstants;
import org.polarsys.capella.common.tools.report.util.LogExt;

public class ReportManagerRegistry {
    private static final Logger logger = Logger.getLogger((String)ReportManagerRegistry.class.getName());
    private final Object lockObj = new Object();
    private Map<String, ConfigurationInstance> configurations = new HashMap<String, ConfigurationInstance>(1);
    private static ReportManagerRegistry instance;

    protected ReportManagerRegistry() {
        Collection<String> kinds = this.getAppenderKinds();
        CreateXmlConfiguration configuration = new CreateXmlConfiguration();
        ConfigurationInstance defaultConfInstance = configuration.createDefaultConfiguration("Default", kinds);
        this.configurations.put(defaultConfInstance.getComponentName(), defaultConfInstance);
        if (configuration.isConfigurationFileExists()) {
            Map<String, ConfigurationInstance> persisted = configuration.loadConfiguration();
            HashMap<String, ConfigurationInstance> result = new HashMap<String, ConfigurationInstance>(1);
            for (Map.Entry<String, ConfigurationInstance> entry : persisted.entrySet()) {
                if (entry.getKey() == null) continue;
                ConfigurationInstance newConf = configuration.createDefaultConfiguration(entry.getKey(), kinds);
                newConf.merge(entry.getValue());
                result.put(entry.getKey(), newConf);
            }
            this.configurations.putAll(result);
        }
        this.setConfigurations(this.configurations);
        this.initRootLogger();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Object property = event.getJob().getProperty(IJobConstants.ALWAYS_LOG_STATUS);
                if (Boolean.TRUE.equals(property)) {
                    IStatus status = event.getResult();
                    if (!status.matches(4) && !status.matches(2)) {
                        RuntimeLog.log((IStatus)status);
                    }
                    LogExt.log("Default", status);
                }
            }
        });
    }

    public Collection<String> getAppenderKinds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        List<Appender> appenders = ReportManagerActivator.getDefault().getAppenders();
        for (Appender appender : appenders) {
            ids.add(appender.getName());
        }
        return ids;
    }

    public static String getConfigurationFile(Bundle bundle, String path) {
        try {
            URL confURL = bundle.getEntry(path);
            return FileLocator.toFileURL((URL)confURL).getPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static synchronized ReportManagerRegistry getInstance() {
        if (instance == null) {
            instance = new ReportManagerRegistry();
            instance.subscribe("Default");
        }
        return instance;
    }

    protected void initRootLogger() {
        try {
            Logger root = Logger.getRootLogger();
            root.setLevel(Level.DEBUG);
            Enumeration e = root.getAllAppenders();
            while (e.hasMoreElements()) {
                Appender appender = (Appender)e.nextElement();
                if (!(appender instanceof ConsoleAppender)) continue;
                appender.addFilter((Filter)new ReportManagerFilter("Console"));
            }
            for (Appender appender : ReportManagerActivator.getDefault().getAppenders()) {
                root.addAppender(appender);
                appender.addFilter((Filter)new ReportManagerFilter(appender));
            }
            Hierarchy h = (Hierarchy)root.getLoggerRepository();
            EmbeddedMessageRenderer emRenderer = new EmbeddedMessageRenderer();
            h.addRenderer(EmbeddedMessage.class, (ObjectRenderer)emRenderer);
            StatusRenderer stRenderer = new StatusRenderer();
            h.addRenderer(IStatus.class, (ObjectRenderer)stRenderer);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public Logger subscribe(String componentName) {
        return this.subscribe(componentName, null);
    }

    public Logger subscribe(String componentName, String defaultConfigurationPath) {
        this.getComponentConfiguration(componentName, defaultConfigurationPath);
        return Logger.getLogger((String)componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(String componentName) {
        if (this.configurations.containsKey(componentName)) {
            Object object = this.lockObj;
            synchronized (object) {
                this.configurations.remove(componentName);
            }
        }
    }

    protected List<IFlushableAppenders> getFlushableAppenders() {
        ReportManagerActivator act = ReportManagerActivator.getDefault();
        return act.getFlushableAppenders();
    }

    public void beginLoggingSession() {
        this.beginLoggingSession("ALL");
    }

    public void beginLoggingSession(String componentName) {
        this.beginLoggingSession(componentName, null);
    }

    public void beginLoggingSession(String componentName, Object loggedElement) {
        for (IFlushableAppenders appender : this.getFlushableAppenders()) {
            appender.flush(componentName, loggedElement);
        }
    }

    public Object[] getComponentsList() {
        return this.configurations.keySet().toArray();
    }

    public ConfigurationInstance getComponentConfiguration(String componentName) {
        return this.getComponentConfiguration(componentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationInstance getComponentConfiguration(String componentName, String defaultConfigurationPath) {
        Map<String, ConfigurationInstance> map = this.configurations;
        synchronized (map) {
            ConfigurationInstance cfgInstance = this.configurations.get(componentName);
            if (cfgInstance == null && defaultConfigurationPath != null) {
                cfgInstance = this.loadFromFile(defaultConfigurationPath, componentName);
            }
            if (cfgInstance == null) {
                cfgInstance = this.configurations.get("Default").clone();
                cfgInstance.setComponentName(componentName);
            }
            this.configurations.put(componentName, cfgInstance);
            return cfgInstance;
        }
    }

    private ConfigurationInstance loadFromFile(String defaultConfigurationPath, String componentName) {
        try {
            return new CreateXmlConfiguration(defaultConfigurationPath).loadConfiguration().get(componentName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration() {
        CreateXmlConfiguration configuration = new CreateXmlConfiguration();
        Map<String, ConfigurationInstance> map = this.configurations;
        synchronized (map) {
            configuration.saveConfiguration(this.configurations);
        }
    }

    public Map<String, ConfigurationInstance> getConfigurations() {
        return this.configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurations(Map<String, ConfigurationInstance> map) {
        Object object = this.lockObj;
        synchronized (object) {
            this.configurations = map;
        }
    }

    public String toString() {
        return "ReportManager";
    }
}

