/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.ObjectFactory;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;
import org.polarsys.capella.common.tools.report.config.persistence.ReportConfigurationFile;

public class CreateXmlConfiguration {
    private static final String FILE_PATH = String.valueOf(System.getProperty("osgi.configuration.area")) + "ReportConfiguration.xml";
    private final ObjectFactory objectFactory = new ObjectFactory();
    private String filePath = null;

    public CreateXmlConfiguration() {
        this.filePath = URI.createURI((String)FILE_PATH).toFileString();
    }

    public CreateXmlConfiguration(String filePath) {
        this.filePath = filePath;
    }

    public ConfigurationInstance createDefaultConfiguration(String componentName, Collection<String> appenders) {
        ConfigurationInstance confInstance = this.objectFactory.createConfigurationInstance();
        confInstance.setComponentName(componentName);
        List<OutputConfiguration> opConfList = confInstance.getOutputConfiguration();
        for (String appenderName : appenders) {
            OutputConfiguration currentConfig = this.objectFactory.createOutputConfiguration();
            currentConfig.setOutputName(appenderName);
            opConfList.add(currentConfig);
            this.createLogConfig(currentConfig);
        }
        return confInstance;
    }

    private void createLogConfig(OutputConfiguration outputConfiguration) {
        List<LogLevel> logLevelListFile = outputConfiguration.getLogLevel();
        logLevelListFile.clear();
        boolean value = "Information".equals(outputConfiguration.getOutputName());
        logLevelListFile.add(this.buildLogLevel(value, "INFO"));
        logLevelListFile.add(this.buildLogLevel(value, "WARN"));
        logLevelListFile.add(this.buildLogLevel(value, "ERROR"));
        logLevelListFile.add(this.buildLogLevel(value, "FATAL"));
        logLevelListFile.add(this.buildLogLevel(false, "DEBUG"));
    }

    private LogLevel buildLogLevel(boolean logLevelValue, String logLevelInfo) {
        LogLevel infoLevelFile = this.objectFactory.createLogLevel();
        infoLevelFile.setName(logLevelInfo);
        infoLevelFile.setValue(logLevelValue);
        return infoLevelFile;
    }

    public boolean isConfigurationFileExists() {
        File file = new File(this.filePath);
        return file.exists();
    }

    public Map<String, ConfigurationInstance> loadConfiguration() {
        if (this.isConfigurationFileExists()) {
            HashMap<String, ConfigurationInstance> configurationMap = new HashMap<String, ConfigurationInstance>(1);
            try {
                JAXBContext jc = this.getJAXBContext();
                Unmarshaller marshaller = jc.createUnmarshaller();
                ReportConfigurationFile file = (ReportConfigurationFile)marshaller.unmarshal((InputStream)new FileInputStream(this.filePath));
                configurationMap.putAll(this.getConfiguration(file));
            }
            catch (IOException | JAXBException exception) {
                exception.printStackTrace();
                return configurationMap;
            }
            return configurationMap;
        }
        return null;
    }

    public Map<String, ConfigurationInstance> getConfiguration(ReportConfigurationFile file) {
        HashMap<String, ConfigurationInstance> configurationMap = new HashMap<String, ConfigurationInstance>(1);
        List<ConfigurationInstance> confInst = file.getConfigurationInstance();
        for (ConfigurationInstance configurationInstance : confInst) {
            configurationMap.put(configurationInstance.getComponentName(), configurationInstance);
        }
        return configurationMap;
    }

    public void saveConfiguration(Map<String, ConfigurationInstance> configurationMap) {
        ReportConfigurationFile repConffile = this.objectFactory.createReportConfigurationFile();
        repConffile.setFileFormatVersion("1.0.1");
        repConffile.setReportManagerVersion("1.1");
        Collection<ConfigurationInstance> confInst = configurationMap.values();
        List<ConfigurationInstance> confInstanceList = repConffile.getConfigurationInstance();
        confInstanceList.addAll(confInst);
        repConffile.setConfigurationInstance(confInstanceList);
        this.doSaveConfigurationFile(repConffile);
    }

    private void doSaveConfigurationFile(ReportConfigurationFile repConffile) {
        try {
            JAXBContext jc = this.getJAXBContext();
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)repConffile, (OutputStream)new FileOutputStream(this.filePath));
        }
        catch (FileNotFoundException | JAXBException exception) {
            exception.printStackTrace();
        }
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        ClassLoader theClassLoader = this.getClass().getClassLoader();
        return JAXBContext.newInstance((String)"org.polarsys.capella.common.tools.report.config.persistence", (ClassLoader)theClassLoader);
    }
}

