/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.extensions.DefaultSemanticMapping;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.Entity;

public class CapellaSemanticMapping
extends DefaultSemanticMapping {
    private static final Collection<String> DUMMY_MAPPING_NAMES = Collections.unmodifiableCollection(Arrays.asList("lab sub components", "dt_datavalue", "ca dummy"));
    private static final Collection<String> ALLOCATED_FUNCTION_MAPPING_NAMES = Arrays.asList("oab_activity", "ca system function", "lab_function", "pab_physicalfunction");
    private static final String PHYSICAL_COMPONENT_MAPPING_NAME = "pab_pc";
    private static final String DEPLOYMENT_MAPPING_NAME = "pab_deployment";
    private static final Collection<String> SUBCOMPONENT_MAPPING_NAMES = Arrays.asList("lab logical component", "pab_pc");

    public boolean conformsToMapping(EObject semanticElt, AbstractNodeMapping mapping, boolean considerPrecondition, boolean considerCandidates, Object containerView) {
        boolean checkSemanticCandidates;
        boolean businessOk;
        boolean bl = businessOk = !this.isDummyMapping(mapping);
        if (considerPrecondition && considerCandidates && (containerView instanceof DDiagram || containerView instanceof DDiagramElementContainer)) {
            businessOk = businessOk && (!this.isSubcomponentMapping(mapping) || this.checkSubcomponent(SiriusLayersUtil.getSemanticElement((Object)containerView), semanticElt));
            businessOk = businessOk && (!this.isPhysicalComponentMapping(mapping) || !this.isDeployed(semanticElt));
            businessOk = businessOk && (!this.isDeploymentMapping(mapping) || this.checkDeployment(SiriusLayersUtil.getSemanticElement((Object)containerView), semanticElt));
            businessOk = businessOk && (!this.isAllocatedFunctionMapping(mapping) || this.checkAllocation(SiriusLayersUtil.getSemanticElement((Object)containerView), semanticElt));
        }
        boolean checkPrecondition = considerPrecondition && this.preconditionCanBeChecked(mapping);
        boolean bl2 = checkSemanticCandidates = considerCandidates && this.semanticCandidatesCanBeChecked(mapping);
        return businessOk && super.conformsToMapping(semanticElt, mapping, checkPrecondition, checkSemanticCandidates, containerView);
    }

    public Collection<EObject> getSemanticCandidatesForGraphicalStorage(EObject element, Object diagram) {
        Component component;
        EObject candidate1;
        Collection result = super.getSemanticCandidatesForGraphicalStorage(element, diagram);
        if (result.size() == 1 && (candidate1 = (EObject)result.iterator().next()) instanceof Component && candidate1.eContainer() instanceof ModellingArchitecture && diagram instanceof DDiagram && (component = (Component)candidate1).getTypedElements().size() == 1) {
            TypedElement part = (TypedElement)component.getTypedElements().get(0);
            result.add(part);
            if (this.isLAB((DDiagram)diagram)) {
                result.remove(candidate1);
            }
        }
        return result;
    }

    public Collection<EObject> getSemanticSelection(Object decorator) {
        Entity entity;
        EList typedElements;
        FOrderedSet result = new FOrderedSet();
        result.addAll(super.getSemanticSelection(decorator));
        EObject current = (EObject)result.iterator().next();
        if (current instanceof Part) {
            Part part = (Part)current;
            AbstractType type = part.getAbstractType();
            if (type instanceof Component) {
                result.add(type);
            }
        } else if (current instanceof Entity && (typedElements = (entity = (Entity)current).getTypedElements()).size() == 1) {
            result.add((EObject)typedElements.get(0));
        }
        return result;
    }

    public EObject getSemanticStorage(Object decorator) {
        DSemanticDiagram diagram;
        EObject result = super.getSemanticStorage(decorator);
        if (result instanceof Part) {
            result = ((Part)result).getAbstractType();
        }
        if (decorator instanceof DSemanticDiagram && this.diagramTargetIsExplicitlyRepresented(diagram = (DSemanticDiagram)decorator)) {
            if (this.isLAB((DDiagram)diagram)) {
                Component rootLc = this.getLogicalArchitecture(diagram.getTarget()).getSystem();
                if (rootLc != null) {
                    result = rootLc;
                }
            } else {
                result = result.eContainer();
            }
        }
        return result;
    }

    private boolean checkAllocation(EObject container, EObject target) {
        boolean result = false;
        if (target instanceof AbstractFunction) {
            AbstractFunctionalBlock refinedContainer = null;
            if (container instanceof Part) {
                Type type = ((Part)container).getType();
                if (type instanceof AbstractFunctionalBlock) {
                    refinedContainer = (AbstractFunctionalBlock)type;
                }
            } else if (container instanceof AbstractFunctionalBlock) {
                refinedContainer = (AbstractFunctionalBlock)container;
            }
            if (refinedContainer != null) {
                result = refinedContainer.getAllocatedFunctions().contains((Object)target);
            }
        }
        return result;
    }

    private boolean checkDeployment(EObject container, EObject target) {
        Part locationPart = null;
        Object locationType = null;
        if (!(container instanceof Part)) {
            return false;
        }
        locationPart = (Part)container;
        Part targetPart = null;
        if (!(target instanceof Part)) {
            return false;
        }
        targetPart = (Part)target;
        EList deployments = targetPart.getDeployingLinks();
        for (AbstractDeploymentLink deployment : deployments) {
            DeploymentTarget currentLocation = deployment.getLocation();
            if (currentLocation != locationPart && (!(currentLocation instanceof Part) || ((Part)currentLocation).getAbstractType() != locationType)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSubcomponent(EObject container, EObject target) {
        if (!(container instanceof Component) || !(target instanceof AbstractType) && !(target instanceof Part)) {
            return true;
        }
        Component partitionableElement = (Component)container;
        AbstractType subComponentType = target instanceof Part ? ((Part)target).getAbstractType() : (AbstractType)target;
        for (Part part : partitionableElement.getContainedParts()) {
            if (part.getAbstractType() != subComponentType) continue;
            return true;
        }
        return false;
    }

    private boolean diagramTargetIsExplicitlyRepresented(DSemanticDiagram diagram) {
        EObject diagramTarget = diagram.getTarget();
        if (diagramTarget == null) {
            return false;
        }
        ArrayList subNodes = new ArrayList();
        subNodes.addAll(diagram.getContainers());
        subNodes.addAll(diagram.getNodeListElements());
        subNodes.addAll(diagram.getNodes());
        for (AbstractDNode currentNode : subNodes) {
            if (diagramTarget != currentNode.getTarget()) continue;
            return true;
        }
        return false;
    }

    private LogicalArchitecture getLogicalArchitecture(EObject current) {
        if (current == null) {
            return null;
        }
        if (current instanceof LogicalArchitecture) {
            return (LogicalArchitecture)current;
        }
        return this.getLogicalArchitecture(current.eContainer());
    }

    private boolean isAllocatedFunctionMapping(AbstractNodeMapping mapping) {
        return ALLOCATED_FUNCTION_MAPPING_NAMES.contains(this.getLowerCaseName(mapping));
    }

    private boolean isDeployed(EObject element) {
        boolean result = false;
        if (element instanceof DeployableElement) {
            DeployableElement deployable = (DeployableElement)element;
            result = !deployable.getDeployingLinks().isEmpty();
        }
        return result;
    }

    private boolean isDeploymentMapping(AbstractNodeMapping mapping) {
        return DEPLOYMENT_MAPPING_NAME.equals(this.getLowerCaseName(mapping));
    }

    private boolean isDummyMapping(AbstractNodeMapping mapping) {
        boolean result = false;
        if (mapping != null && mapping.getName() != null) {
            String name = mapping.getName().toLowerCase();
            result = DUMMY_MAPPING_NAMES.contains(name);
            result = result || name.endsWith("_dummy");
        }
        return result;
    }

    private boolean isLAB(DDiagram diagram) {
        boolean result = false;
        String descName = diagram.getDescription().getName();
        if (descName != null) {
            result = descName.toLowerCase().contains("logical architecture");
        }
        return result;
    }

    private boolean isPhysicalComponentMapping(AbstractNodeMapping mapping) {
        return PHYSICAL_COMPONENT_MAPPING_NAME.equals(this.getLowerCaseName(mapping));
    }

    private boolean isSubcomponentMapping(AbstractNodeMapping mapping) {
        return mapping != null && mapping.getName() != null && SUBCOMPONENT_MAPPING_NAMES.contains(this.getLowerCaseName(mapping));
    }

    private String getLowerCaseName(AbstractNodeMapping mapping) {
        String result = null;
        if (mapping != null && mapping.getName() != null) {
            result = mapping.getName().toLowerCase();
        }
        return result;
    }

    private boolean preconditionCanBeChecked(AbstractNodeMapping mapping) {
        return !this.isDeploymentMapping(mapping);
    }

    private boolean semanticCandidatesCanBeChecked(AbstractNodeMapping mapping) {
        return this.preconditionCanBeChecked(mapping);
    }
}

