/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.refactoring;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.Messages;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.sirius.ui.helper.ResourceHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class WorkspaceImagePathChange
extends Change {
    private int position;
    private RenameArguments renameArguments;
    private IContainer container;

    public WorkspaceImagePathChange(IContainer container, RenameArguments renameArguments) {
        this.container = container;
        this.renameArguments = renameArguments;
        this.position = this.getPosition();
    }

    public String getName() {
        return org.polarsys.capella.core.sirius.ui.internal.Messages.update_workspace_image_paths;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.container.isAccessible()) {
            IProject project = this.container.getProject();
            Collection<Session> existingSessions = SessionHelper.getExistingSessions(project);
            if (existingSessions.isEmpty()) {
                this.openSession(project, pm);
                existingSessions = SessionHelper.getExistingSessions(project);
            }
            return this.performChange(existingSessions, pm);
        }
        return null;
    }

    private Change performChange(Collection<Session> sessions, final IProgressMonitor pm) {
        for (final Session session : sessions) {
            ExecutionManager manager = TransactionHelper.getExecutionManager((Session)session);
            manager.execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    if (WorkspaceImagePathChange.this.renameArguments.getUpdateReferences() && (WorkspaceImagePathChange.this.position > 0 || WorkspaceImagePathChange.this.position == 0 && !ResourceHelper.collectImageFiles(WorkspaceImagePathChange.this.container).isEmpty())) {
                        pm.subTask(org.polarsys.capella.core.sirius.ui.internal.Messages.collecting_diagrams);
                        Collection descriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
                        for (DRepresentationDescriptor descriptor : descriptors) {
                            pm.subTask(NLS.bind((String)org.polarsys.capella.core.sirius.ui.internal.Messages.updating_diagram, (Object)descriptor.getName()));
                            WorkspaceImagePathChange.this.updateWorkspaceImagePath(descriptor.getRepresentation());
                        }
                    }
                    if (WorkspaceImagePathChange.this.position == 0) {
                        WorkspaceImagePathChange.this.renameRelevantCapellaObjects(session);
                    }
                }
            });
            this.saveSession(session, pm);
        }
        return null;
    }

    private void renameRelevantCapellaObjects(Session session) {
        Project capellaProject = SessionHelper.getCapellaProject(session);
        if (capellaProject != null) {
            capellaProject.setName(this.renameArguments.getNewName());
            SystemEngineering systemEngineering = SystemEngineeringExt.getSystemEngineering((Project)capellaProject);
            if (systemEngineering != null) {
                systemEngineering.setName(this.renameArguments.getNewName());
            }
        }
    }

    private void saveSession(Session session, IProgressMonitor pm) {
        pm.subTask(Messages.DAnalysisSessionImpl_saveMsg);
        session.save(pm);
    }

    private void updateWorkspaceImagePath(DRepresentation representation) {
        if (representation != null) {
            for (DRepresentationElement element : representation.getOwnedRepresentationElements()) {
                TreeIterator iterator = element.eAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (!ResourceHelper.isCustomizedWorkspaceImageWorkspacePath(eObject)) continue;
                    this.updatePath((WorkspaceImage)eObject);
                }
            }
        }
    }

    private void updatePath(WorkspaceImage workspaceImage) {
        String workspacePath = workspaceImage.getWorkspacePath();
        Path path = new Path(workspacePath);
        String segment = path.segment(this.position);
        String oldName = this.container.getName();
        if (oldName.equals(segment)) {
            workspacePath = workspacePath.replace(oldName, this.renameArguments.getNewName());
            workspaceImage.setWorkspacePath(workspacePath);
        }
    }

    private void openSession(IProject project, IProgressMonitor monitor) {
        Collection<IFile> airdFiles = ResourceHelper.getAirdFilesToOpen(project);
        for (IFile airdFile : airdFiles) {
            monitor.subTask(Messages.DAnalysisSessionImpl_openMsg);
            SessionManager.INSTANCE.openSession(EcoreUtil2.getURI((IFile)airdFile), monitor, (UICallBack)new NoUICallback());
        }
    }

    private int getPosition() {
        if (this.container instanceof IProject) {
            return 0;
        }
        IPath location = this.container.getFullPath();
        if (location != null) {
            return location.segments().length - 1;
        }
        return -1;
    }

    public Object getModifiedElement() {
        return null;
    }
}

