/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;

public class ResourceHelper {
    private ResourceHelper() {
    }

    public static Collection<IFile> getAirdFilesToOpen(IProject project) {
        return ResourceHelper.collectFiles((IContainer)project, new Predicate<String>(){

            @Override
            public boolean test(String fileExtension) {
                return "aird".equals(fileExtension);
            }
        });
    }

    public static Collection<IFile> collectImageFiles(IContainer container) {
        return ResourceHelper.collectFiles(container, new Predicate<String>(){

            @Override
            public boolean test(String fileExtension) {
                return ResourceHelper.isSupportedImageFormat(fileExtension);
            }
        });
    }

    private static Collection<IFile> collectFiles(IContainer container, Predicate<String> predicate) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (container.isAccessible()) {
            try {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    switch (resource.getType()) {
                        case 1: {
                            String fileExtension = resource.getFileExtension();
                            if (!predicate.test(fileExtension)) break;
                            result.add((IFile)resource);
                            break;
                        }
                        case 2: {
                            IFolder subFolder = (IFolder)resource;
                            result.addAll(ResourceHelper.collectFiles((IContainer)subFolder, predicate));
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Status status = new Status(e.getStatus().getSeverity(), SiriusUIPlugin.getDefault().getPluginId(), "Erros while collecting files!", (Throwable)e);
                SiriusUIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    public static boolean isCustomizedWorkspaceImageWorkspacePath(EObject obj) {
        if (obj instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)obj;
            return workspaceImage.getCustomFeatures().contains((Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName());
        }
        return false;
    }

    private static boolean isSupportedImageFormat(String fileExtension) {
        boolean isSupportedImageFormat = false;
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.VALUES;
        int n = ImageFileFormat.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat element = imageFileFormatArray[n2];
            if (element.getName().equalsIgnoreCase(fileExtension)) {
                isSupportedImageFormat = true;
                break;
            }
            ++n2;
        }
        return isSupportedImageFormat;
    }
}

