/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.sirius.ui.handlers.AbstractDiagramCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.DeleteHiddenElementsJob;
import org.polarsys.capella.core.sirius.ui.handlers.Messages;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class RemoveHiddenElementsHandler
extends AbstractDiagramCommandHandler {
    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        Object selectedElement = this.getSelection().getFirstElement();
        Session session = this.getSession(selectedElement);
        Collection<Object> representationsToRefresh = Collections.emptyList();
        if (selectedElement instanceof ModelElement) {
            representationsToRefresh = new ArrayList();
            Collection allSessionRepresentations = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
            for (DRepresentationDescriptor representation : allSessionRepresentations) {
                EObject associatedModelElement = representation.getTarget();
                if (!EcoreUtil.isAncestor((EObject)((ModelElement)selectedElement), (EObject)associatedModelElement)) continue;
                representationsToRefresh.add(representation);
            }
        } else if (selectedElement instanceof IFile) {
            representationsToRefresh = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
        }
        if (representationsToRefresh.isEmpty()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RemoveHiddenElementsHandler_ConfirmRefreshDialog_Title, (String)Messages.RemoveHiddenElementsHandler_NoDiagramDialog_Text);
            return null;
        }
        MessageDialogWithToggle messageDialogWithToggle = new MessageDialogWithToggle(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.RemoveHiddenElementsHandler_ConfirmRefreshDialog_Title, null, Messages.RemoveHiddenElementsHandler_ConfirmRefreshDialog_Text, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1, "Unsynchronize diagrams", true);
        int returnCode = messageDialogWithToggle.open();
        boolean deleteHiddenConfirmed = returnCode == 0;
        boolean unsyncDiagrams = messageDialogWithToggle.getToggleState();
        if (!deleteHiddenConfirmed) {
            return null;
        }
        DeleteHiddenElementsJob job = new DeleteHiddenElementsJob(representationsToRefresh, session, unsyncDiagrams);
        job.setThread(Display.getDefault().getThread());
        job.setUser(true);
        job.schedule();
        return null;
    }

    protected Session getSession(Object object_p) {
        Session session = null;
        if (object_p instanceof IFile) {
            session = SessionHelper.getSessionForDiagramFile((IFile)object_p);
        } else if (object_p instanceof ModelElement) {
            session = SessionManager.INSTANCE.getSession((EObject)((ModelElement)object_p));
        }
        return session;
    }

    @Override
    public boolean isEnabled() {
        IStructuredSelection currentSelection = this.getSelection();
        if (currentSelection.isEmpty()) {
            return false;
        }
        Object selectedElement = currentSelection.getFirstElement();
        Session selectedElementSession = this.getSession(selectedElement);
        return selectedElementSession != null;
    }
}

