/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.handlers.RefreshDiagramsCommandHandler;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class RefreshDiagramJob
extends Job {
    IFile file;

    public RefreshDiagramJob(IFile file) {
        super(NLS.bind((String)"Refresh diagrams on {0}", (Object)file.getName()));
        this.file = file;
        this.setUser(false);
    }

    public boolean belongsTo(Object family) {
        return family.getClass().equals(RefreshDiagramJob.class);
    }

    public IStatus run(IProgressMonitor monitor) {
        RefreshDiagramsCommandHandler handler;
        URI selectedUri = EcoreUtil2.getURI((IFile)this.file);
        Session session = SessionManager.INSTANCE.getSession(selectedUri, monitor);
        if (!session.isOpen()) {
            session.open(monitor);
        }
        Project capellaProject = SessionHelper.getCapellaProject(session);
        RefreshDiagramsCommandHandler refreshDiagramsCommandHandler = handler = new RefreshDiagramsCommandHandler();
        ((Object)((Object)refreshDiagramsCommandHandler)).getClass();
        RefreshDiagramsCommandHandler.RefreshDiagramsJob job = new RefreshDiagramsCommandHandler.RefreshDiagramsJob(refreshDiagramsCommandHandler, handler.getSubRepresentations(capellaProject, session), session, Display.getDefault());
        job.setUser(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        return job.getResult();
    }

    public IFile getFile() {
        return this.file;
    }
}

