/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.commandline;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.commandline.core.ui.AbstractWorkbenchCommandLine;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;
import org.polarsys.capella.core.sirius.ui.commandline.RemoveHiddenElementsArgumentHelper;
import org.polarsys.capella.core.sirius.ui.handlers.DeleteHiddenElementsJob;

public class RemoveHiddenElementsCommandLine
extends AbstractWorkbenchCommandLine {
    public RemoveHiddenElementsCommandLine() {
        super(false);
        this.argHelper = new RemoveHiddenElementsArgumentHelper();
    }

    protected IStatus executeWithinWorkbench() {
        RemoveHiddenElementsArgumentHelper args = (RemoveHiddenElementsArgumentHelper)this.argHelper;
        boolean unsyncDiags = args.getUnsyncDiags();
        List airdFiles = this.getAirdFilesFromInput();
        for (IFile file : airdFiles) {
            URI uri = EcoreUtil2.getURI((IFile)file);
            Session session = SessionManager.INSTANCE.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
            if (session == null) {
                return new Status(4, SiriusUIPlugin.getDefault().getPluginId(), "No aird model found!");
            }
            if (!session.isOpen()) {
                session.open((IProgressMonitor)new NullProgressMonitor());
            }
            if (!CapellaResourceHelper.isAirdResource((URI)uri)) continue;
            Collection representations = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
            DeleteHiddenElementsJob job = new DeleteHiddenElementsJob(representations, session, unsyncDiags);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                return Status.CANCEL_STATUS;
            }
            session.save((IProgressMonitor)new NullProgressMonitor());
            try {
                session.close((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }

    public void printHelp() {
        super.printHelp();
        this.printArgumentsFromTable("removeHiddenElementsParameters", false, Collections.emptyList());
    }
}

