/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.dialog.RenameDialog;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.sirius.ui.Messages;

public class RenameRepresentationAction
extends BaseSelectionListenerAction {
    public RenameRepresentationAction() {
        super("Rename");
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return !this.getRenamableRepresentationDescriptors(selection).isEmpty();
    }

    private List<DRepresentationDescriptor> getRenamableRepresentationDescriptors(IStructuredSelection selection) {
        IReadOnlySectionHandler handler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
        return RepresentationHelper.getSelectedDescriptors((Collection)selection.toList()).stream().filter(RepresentationHelper::isValid).filter(descriptor -> handler == null || handler != null && !handler.isLockedByOthers((EObject)descriptor)).collect(Collectors.toList());
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        List<DRepresentationDescriptor> descriptors = this.getRenamableRepresentationDescriptors(selection);
        for (DRepresentationDescriptor descriptor : descriptors) {
            String newName;
            final String oldName = descriptor.getName() != null ? descriptor.getName() : "";
            RenameDialog dialog = new RenameDialog(Display.getDefault().getActiveShell(), oldName){

                public int open() {
                    this.create();
                    return super.open();
                }

                public void create() {
                    super.create();
                    this.setTitle(Messages.RenameRepresentationAction_Title);
                    this.setOldName(oldName);
                    this.getShell().setSize(this.getShell().computeSize(-1, -1));
                }
            };
            if (dialog.open() != 0 || oldName.equals(newName = dialog.getNewName())) continue;
            TransactionHelper.getExecutionManager((EObject)descriptor).execute((ICommand)new RenameRepresentationCommand(descriptor, newName));
        }
    }

    private class RenameRepresentationCommand
    extends AbstractReadWriteCommand {
        private String newName;
        private DRepresentationDescriptor selectedRepresentation;

        public String getName() {
            return RenameRepresentationAction.this.getText();
        }

        public RenameRepresentationCommand(DRepresentationDescriptor representation, String name) {
            this.newName = name;
            this.selectedRepresentation = representation;
        }

        public void run() {
            if (!this.selectedRepresentation.isLoadedRepresentation()) {
                this.selectedRepresentation.getRepresentation();
            }
            this.selectedRepresentation.setName(this.newName);
        }
    }
}

