/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionHelper;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.platform.sirius.ui.session.CapellaSessionHelper;
import org.polarsys.capella.core.sirius.ui.Messages;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;

public class OpenSessionAction
extends BaseSelectionListenerAction {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    public static final String ACTIVITY_EXPLORER_EDITOR = "org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor";
    private static boolean shouldOpenActivityExplorer;
    private boolean shouldRunInProgressService;
    private Map<IFile, IStatus> failedOpeningSessions;

    public OpenSessionAction() {
        super(Messages.OpenSessionAction_Title);
        shouldOpenActivityExplorer = true;
        this.shouldRunInProgressService = true;
    }

    protected void doOpenSessions(IProgressMonitor monitor) {
        this.failedOpeningSessions = new HashMap<IFile, IStatus>();
        for (Object selectedElement : this.getStructuredSelection().toList()) {
            if (!(selectedElement instanceof IFile)) continue;
            IFile selectedFile = (IFile)selectedElement;
            Session session = null;
            String eventName = "Open Session";
            String eventContext = selectedFile.getName();
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE);
            try {
                if (org.polarsys.capella.core.sirius.ui.helper.SessionHelper.getSession(selectedFile) != null) continue;
                URI selectedUri = EcoreUtil2.getURI((IFile)selectedFile);
                session = SessionManager.INSTANCE.getSession(selectedUri, monitor);
                if (session == null) {
                    this.failedOpeningSessions.put(selectedFile, (IStatus)new Status(4, SiriusUIPlugin.getDefault().getPluginId(), "Session can't be opened (null session)"));
                    continue;
                }
                IStatus checkLibraryCompliancyResult = CapellaSessionHelper.checkLibrariesAvailability((Session)session);
                if (!checkLibraryCompliancyResult.isOK()) {
                    this.failedOpeningSessions.put(selectedFile, checkLibraryCompliancyResult);
                    continue;
                }
                session.open(monitor);
                if (!session.isOpen()) {
                    this.failedOpeningSessions.put(selectedFile, (IStatus)new Status(4, SiriusUIPlugin.getDefault().getPluginId(), NLS.bind((String)"Session can't be opened (null session)", (Object)selectedFile)));
                    continue;
                }
                IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(session);
                editingSession.open();
                if (session != null) {
                    SessionHelper.openStartupRepresentations((Session)session, (IProgressMonitor)new NullProgressMonitor());
                }
                if (shouldOpenActivityExplorer) {
                    OpenSessionAction.openActivityExplorer(session);
                }
                UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK);
            }
            catch (Exception ex) {
                CapellaSessionHelper.reportException((Exception)ex);
                UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.ERROR);
            }
        }
    }

    public Map<IFile, IStatus> getFailedOpeningSessions() {
        if (this.failedOpeningSessions == null) {
            this.failedOpeningSessions = Collections.emptyMap();
        }
        return this.failedOpeningSessions;
    }

    public void run() {
        if (this.getStructuredSelection().isEmpty()) {
            return;
        }
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    OpenSessionAction.this.doOpenSessions(monitor);
                }
            };
            if (this.shouldRunInProgressService) {
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            logger.debug((Object)new EmbeddedMessage(ex.getMessage(), "User Interface"));
        }
    }

    public void setOpenActivityExplorer(boolean open) {
        shouldOpenActivityExplorer = open;
    }

    public void setRunInProgressService(boolean runInProgressService) {
        this.shouldRunInProgressService = runInProgressService;
    }

    public static boolean openActivityExplorer(final Session session) {
        if (session == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (session.isOpen() || shouldOpenActivityExplorer) {
                        activePage.openEditor((IEditorInput)new ActivityExplorerEditorInput(session, (EObject)org.polarsys.capella.core.sirius.ui.helper.SessionHelper.getCapellaProject(session)), OpenSessionAction.ACTIVITY_EXPLORER_EDITOR, true, 3);
                    }
                    result[0] = true;
                }
                catch (PartInitException exception) {
                    StringBuilder loggerMessage = new StringBuilder(".run(..) _ Activity Explorer not Found.");
                    loggerMessage.append(exception.getMessage());
                    logger.warn((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"), (Throwable)exception);
                }
            }
        };
        Display display = Display.getCurrent();
        if (display == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
        return result[0];
    }
}

