/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.helpers.TransactionHelper;

public class AddSemanticResourceAction
extends BaseSelectionListenerAction {
    public AddSemanticResourceAction() {
        super("Add Semantic Resource");
    }

    public void run() {
        Collection<URI> selectedResourcesURIs = this.selectResources();
        if (selectedResourcesURIs != null && !selectedResourcesURIs.isEmpty()) {
            for (Object object : this.getStructuredSelection()) {
                if (!(object instanceof Session)) continue;
                TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((Session)((Session)object));
                AddSemanticResourceCommand command = new AddSemanticResourceCommand(domain, "Add Semantic Resource", Collections.singletonList((Session)object), selectedResourcesURIs);
                domain.getCommandStack().execute((Command)command);
            }
        }
    }

    private Collection<URI> selectResources() {
        Shell activeShell = Display.getCurrent().getActiveShell();
        ResourceDialog resourceDialog = new ResourceDialog(activeShell, "Select resources to add", 4098);
        if (resourceDialog.open() == 0) {
            return resourceDialog.getURIs();
        }
        return Collections.emptyList();
    }

    private class AddSemanticResourceCommand
    extends RecordingCommand {
        private List<Session> _selectedSessions;
        private TransactionalEditingDomain _domain;
        private Collection<URI> _uris;

        public AddSemanticResourceCommand(TransactionalEditingDomain domain_p, String label_p, List<Session> sessions_p, Collection<URI> uris_p) {
            super(domain_p, label_p);
            this._selectedSessions = sessions_p;
            this._domain = domain_p;
            this._uris = uris_p;
        }

        protected void doExecute() {
            for (URI uri : this._uris) {
                for (Session session : this._selectedSessions) {
                    session.addSemanticResource(uri, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }
}

