/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.components;

import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.requirement.RequirementsTrace;
import org.polarsys.capella.core.data.sharedmodel.SharedmodelPackage;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.MDTrace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.TraceNameHelper;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.TraceUtil;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.TraceTreeSelectionDialog;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.ViewEditPage;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.CapellaModelLabelProvider;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.CapellaModelTreeContentProvider;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.ElementLabelProvider;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.SourceElementContentProvider;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.TargetElementContentProvider;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.TypeElementFilter;

public class TraceTreeViewer
implements IDoubleClickListener {
    public static final String PATH_SEPARATOR = "::";
    protected Menu _additionMenu;
    private Combo _comboType;
    public TraceableElement _currentNamedElement;
    public TypeElementFilter _eltFilter = new TypeElementFilter();
    private ListenerList _listeners = new ListenerList();
    private SelectionListener _menuSelectionListener;
    ToolItem _removeItem;
    ToolItem _addItem;
    public SourceElementContentProvider _srcEltContentProvider;
    public TargetElementContentProvider _targetEltContentProvider;
    public TraceType _traceType;
    public TreeViewer _treeViewer;
    private ViewEditPage _wizardPage;
    ToolBar toolBar;

    public TreeViewer getClientViewer() {
        return this._treeViewer;
    }

    public TraceTreeViewer(TraceableElement firstInput_p, TraceType traceType_p) {
        this._traceType = traceType_p;
        this._currentNamedElement = firstInput_p;
        this._menuSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (e_p.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e_p.widget;
                    TraceTreeViewer.this.showWizard(item.getText(), true);
                }
            }
        };
    }

    public void addListener(IDoubleClickListener listener_p) {
        this._listeners.add((Object)listener_p);
    }

    private void addToolbarListeners() {
        this._addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selectedElement = TraceTreeViewer.this._treeViewer.getSelection();
                Object elem = null;
                if (selectedElement instanceof IStructuredSelection && ((IStructuredSelection)selectedElement).size() == 1) {
                    elem = ((IStructuredSelection)selectedElement).getFirstElement();
                }
                if (e.detail == 4) {
                    if (!(elem instanceof Trace)) {
                        Point point = new Point(e.x, e.y);
                        point = Display.getCurrent().map((Control)TraceTreeViewer.this.toolBar, null, point);
                        TraceTreeViewer.this._additionMenu.setLocation(point);
                        TraceTreeViewer.this._additionMenu.setVisible(true);
                    }
                } else {
                    boolean flag = false;
                    if (elem instanceof Class) {
                        boolean bl = flag = GenericTrace.class.isAssignableFrom((Class)elem) || RequirementsTrace.class.isAssignableFrom((Class)elem);
                    }
                    if (elem instanceof Trace || elem instanceof Class && flag) {
                        String traceType = null;
                        boolean isNewTrace = false;
                        IBaseLabelProvider baseProvider = TraceTreeViewer.this._treeViewer.getLabelProvider();
                        if (!(baseProvider instanceof LabelProvider)) {
                            return;
                        }
                        LabelProvider labelProvider = (LabelProvider)baseProvider;
                        if (elem instanceof Trace) {
                            Object parent = ((ITreeContentProvider)TraceTreeViewer.this._treeViewer.getContentProvider()).getParent(elem);
                            traceType = labelProvider.getText(parent);
                        } else {
                            traceType = labelProvider.getText(elem);
                            isNewTrace = true;
                        }
                        TraceTreeViewer.this.showWizard(traceType, isNewTrace);
                    }
                }
            }
        });
        this._removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceUtil.removeTraces(TraceTreeViewer.this._traceType, TraceTreeViewer.this._treeViewer);
                if (TraceUtil.isIsVoidTrace()) {
                    TraceTreeViewer.this._wizardPage.setErrorMessage(Messages.getString("TraceTreeViewer.void_trace_error"));
                    TraceTreeViewer.this._wizardPage.setPageComplete(false);
                } else {
                    TraceTreeViewer.this._wizardPage.setErrorMessage(null);
                    TraceTreeViewer.this._wizardPage.setPageComplete(true);
                }
                TraceTreeViewer.this.updateComponent(TraceTreeViewer.this._currentNamedElement);
            }
        });
    }

    public void doubleClick(DoubleClickEvent event_p) {
        ISelection selection = event_p.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof CapellaElement) {
                this.updateComponent((TraceableElement)((CapellaElement)elem));
                this.notifyObservers((EventObject)event_p);
            } else if (this._treeViewer.getExpandedState(elem)) {
                this._treeViewer.collapseToLevel(elem, -1);
            } else {
                this._treeViewer.expandToLevel(elem, 1);
            }
        }
    }

    public Composite getControl(Composite parent_p) {
        Composite compo = new Composite(parent_p, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        compo.setLayout((Layout)layout);
        this.toolBar = new ToolBar(compo, 8);
        GridData gData = new GridData();
        gData.horizontalAlignment = 4;
        gData.grabExcessHorizontalSpace = true;
        this.toolBar.setLayoutData((Object)gData);
        this._additionMenu = new Menu((Control)compo.getShell());
        this._addItem = new ToolItem(this.toolBar, 4);
        this._addItem.setToolTipText(Messages.getString("TraceTreeViewer.addTrace_tooltip"));
        this._addItem.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.platform.eclipse.ui.trace", (String)"icons/add.gif").createImage());
        this.prepareMenuItems();
        this._removeItem = new ToolItem(this.toolBar, 8);
        this._removeItem.setToolTipText(Messages.getString("TraceTreeViewer.removeTrace_tooltip"));
        this._removeItem.setImage(MDTrace.imageDescriptorFromPlugin("org.polarsys.capella.core.platform.eclipse.ui.trace", "icons/remove.gif").createImage());
        this._removeItem.setEnabled(false);
        this.addToolbarListeners();
        Label label = new Label(compo, 2060);
        if (this._traceType.equals((Object)TraceType.SOURCE_ELEMENT)) {
            label.setText(Messages.getString("TraceTreeViewer.source_elt_linked"));
        } else {
            label.setText(Messages.getString("TraceTreeViewer.target_elt_linked"));
        }
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        label.setLayoutData((Object)layoutData);
        this._treeViewer = new TreeViewer(compo, 18440);
        this._treeViewer.setUseHashlookup(true);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this._treeViewer.getControl().setLayoutData((Object)layoutData);
        if (this._traceType.equals((Object)TraceType.SOURCE_ELEMENT)) {
            this._srcEltContentProvider = new SourceElementContentProvider();
            this._treeViewer.setContentProvider((IContentProvider)this._srcEltContentProvider);
        } else {
            this._targetEltContentProvider = new TargetElementContentProvider();
            this._treeViewer.setContentProvider((IContentProvider)this._targetEltContentProvider);
        }
        this._treeViewer.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this._treeViewer.setInput((Object)this._currentNamedElement);
        this._treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this._treeViewer.expandAll();
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection selection = event_p.getSelection();
                TraceTreeViewer.this._addItem.setEnabled(true);
                TraceTreeViewer.this._removeItem.setEnabled(!selection.isEmpty());
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                    Object elem = ((IStructuredSelection)selection).getFirstElement();
                    Object parent = null;
                    if (elem instanceof CapellaElement) {
                        parent = ((ITreeContentProvider)TraceTreeViewer.this._treeViewer.getContentProvider()).getParent(elem);
                    }
                    boolean canEnableRemoveItem = TraceUtil.canAddRemoveItemsToTrace(parent != null ? parent : elem);
                    TraceTreeViewer.this._removeItem.setEnabled(canEnableRemoveItem);
                    boolean canEnableAddItem = TraceUtil.canEnableAddItem(elem);
                    TraceTreeViewer.this._addItem.setEnabled(canEnableAddItem);
                }
            }
        });
        Composite compositeComboBox = new Composite(compo, 0);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 2;
        compositeComboBox.setLayout((Layout)gl2);
        new Label(compositeComboBox, 0x1000000).setText(Messages.getString("TraceTreeViewer.trace_type"));
        this._comboType = new Combo(compositeComboBox, 2060);
        this._comboType.setLayoutData((Object)new GridData(768));
        this.setComboInput();
        this._treeViewer.addFilter((ViewerFilter)this._eltFilter);
        this._comboType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e_p) {
            }

            public void widgetSelected(SelectionEvent e_p) {
                if (e_p.getSource() instanceof Combo) {
                    Combo combo = (Combo)e_p.getSource();
                    TraceTreeViewer.this._eltFilter.setComboBoxValue(combo.getText());
                    TraceTreeViewer.this._treeViewer.refresh();
                }
            }
        });
        return compo;
    }

    public ViewEditPage getWizardPage() {
        return this._wizardPage;
    }

    private void notifyObservers(EventObject event_p) {
        Object[] listeners;
        Object[] objectArray = listeners = this._listeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (event_p instanceof DoubleClickEvent) {
                ((IDoubleClickListener)listener).doubleClick((DoubleClickEvent)event_p);
            }
            ++n2;
        }
    }

    public void prepareMenuItems() {
        for (String traceName : TraceNameHelper.getManualTraceTypes()) {
            MenuItem item = new MenuItem(this._additionMenu, 8);
            item.setText(traceName);
            item.addSelectionListener(this._menuSelectionListener);
        }
    }

    public void removeListener(IDoubleClickListener listener_p) {
        this._listeners.remove((Object)listener_p);
    }

    public void setComboInput() {
        this._comboType.removeAll();
        this._comboType.add(Messages.getString("TraceTreeViewer.all_traces"));
        this._comboType.select(0);
        this._eltFilter.setComboBoxValue(this._comboType.getText());
        this._treeViewer.refresh();
        if (this._traceType.equals((Object)TraceType.SOURCE_ELEMENT)) {
            List<Class<? extends AbstractTrace>> traceType = this._srcEltContentProvider.getTraceType();
            for (Class<? extends AbstractTrace> class1 : traceType) {
                this._comboType.add(TraceNameHelper.getTraceNameFromClass(class1));
            }
        } else {
            List<Class<? extends AbstractTrace>> traceType = this._targetEltContentProvider.getTraceType();
            for (Class<? extends AbstractTrace> class1 : traceType) {
                this._comboType.add(TraceNameHelper.getTraceNameFromClass(class1));
            }
        }
    }

    public void setWizardPage(ViewEditPage wizardPage_p) {
        this._wizardPage = wizardPage_p;
    }

    private void showWizard(String traceType_p, boolean isNewTrace_p) {
        Object obj;
        SystemEngineering root = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)this._currentNamedElement);
        if (root == null) {
            root = EcoreUtil2.getFirstContainer((EObject)this._currentNamedElement, (EClass)SharedmodelPackage.Literals.SHARED_PKG);
        }
        if (root == null) {
            root = CapellaQueries.getInstance().getRootQueries().getProject((ModelElement)this._currentNamedElement);
        }
        CapellaModelTreeContentProvider contentProvider = new CapellaModelTreeContentProvider();
        contentProvider.setRootPkg((ModelElement)root);
        TraceTreeSelectionDialog dlg = new TraceTreeSelectionDialog(this._treeViewer.getControl().getShell(), (ILabelProvider)new CapellaModelLabelProvider((CapellaElement)this._currentNamedElement, isNewTrace_p), contentProvider, this._currentNamedElement, isNewTrace_p);
        SystemEngineering container = root instanceof Project ? root : root.eContainer();
        dlg.setInput(container);
        dlg.setHelpAvailable(true);
        dlg.setTitle(Messages.getString("TraceTreeViewer.window_title"));
        dlg.setAllowMultiple(false);
        if (dlg.open() == 0 && dlg.getResult().length > 0 && (obj = dlg.getResult()[0]) instanceof TraceableElement) {
            ISelection selectedElement = this._treeViewer.getSelection();
            Object elem = null;
            if (selectedElement instanceof IStructuredSelection && ((IStructuredSelection)selectedElement).size() == 1) {
                elem = ((IStructuredSelection)selectedElement).getFirstElement();
            }
            TraceUtil.addTraces(this._currentNamedElement, (TraceableElement)obj, traceType_p, this._traceType, elem);
            if (TraceUtil.isIsVoidTrace()) {
                this._wizardPage.setErrorMessage(Messages.getString("TraceTreeViewer.void_trace_error"));
                this._wizardPage.setPageComplete(false);
            } else {
                this._wizardPage.setErrorMessage(null);
                this._wizardPage.setPageComplete(true);
            }
            this._treeViewer.refresh();
            this._treeViewer.expandAll();
            this.setComboInput();
        }
    }

    public void updateComponent(TraceableElement newNamedElement_p) {
        this._currentNamedElement = newNamedElement_p;
        this._treeViewer.setInput((Object)newNamedElement_p);
        this._treeViewer.refresh();
        this._treeViewer.expandAll();
        this.setComboInput();
    }

    public static enum TraceType {
        SOURCE_ELEMENT,
        TARGET_ELEMENT;

    }
}

