/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForNoteItem;

public class CapellaSearchSettings {
    private boolean isCaseSensitive = false;
    private boolean isRegExSearch = false;
    private boolean isWholeWord = false;
    private String textPattern = null;
    private String replaceTextPattern = null;
    private Set<Object> objectsToSearch = new HashSet<Object>();
    private Set<Object> searchAttributeItems = new HashSet<Object>();
    private Set<Object> searchMetaClassItems = new HashSet<Object>();
    private boolean abstractChecked = true;
    private boolean nonSemanticChecked = true;
    private int scope;

    public void addObjectToSearch(Object objectToSearch) {
        this.objectsToSearch.add(objectToSearch);
    }

    public Set<Object> getObjectsToSearch() {
        return Collections.unmodifiableSet(this.objectsToSearch);
    }

    public boolean containProject(String name) {
        return this.objectsToSearch.contains(name);
    }

    public void clearProjects() {
        this.objectsToSearch.clear();
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isRegExSearch() {
        return this.isRegExSearch;
    }

    public void setRegExSearch(boolean isRegExSearch) {
        this.isRegExSearch = isRegExSearch;
    }

    public boolean isWholeWord() {
        return this.isWholeWord;
    }

    public void setWholeWord(boolean isWholeWord) {
        this.isWholeWord = isWholeWord;
    }

    public String getTextPattern() {
        return this.textPattern;
    }

    public void setTextPattern(String textPattern) {
        this.textPattern = textPattern;
    }

    public String getReplaceTextPattern() {
        return this.replaceTextPattern;
    }

    public void setReplaceTextPattern(String replaceTextPattern) {
        this.replaceTextPattern = replaceTextPattern;
    }

    public Set<Object> getSearchAttributeItems() {
        return this.searchAttributeItems;
    }

    public void setSearchAttributeItems(Set<Object> searchAttributeItems) {
        this.searchAttributeItems = searchAttributeItems;
    }

    public Set<Object> getSearchClassItems() {
        return this.searchMetaClassItems;
    }

    public void setSearchClassItems(Set<Object> searchClassItems) {
        this.searchMetaClassItems = searchClassItems;
    }

    public void setAbstractChecked(boolean abstractChecked) {
        this.abstractChecked = abstractChecked;
    }

    public void setNonSemanticChecked(boolean nonSemanticChecked) {
        this.nonSemanticChecked = nonSemanticChecked;
    }

    public boolean isAbstractChecked() {
        return this.abstractChecked;
    }

    public boolean isNonSemanticChecked() {
        return this.nonSemanticChecked;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getScope() {
        return this.scope;
    }

    public IStatus validate() {
        if (this.textPattern == null || this.textPattern.isEmpty()) {
            return new Status(4, "org.polarsys.capella.core.ui.search", "Search pattern must not be empty");
        }
        if (this.isRegExSearch) {
            if (this.isWholeWord) {
                return new Status(4, "org.polarsys.capella.core.ui.search", "The 'Whole word' option is unsupported together with 'Regular expression'");
            }
            try {
                CapellaSearchSettings.createPattern(this.textPattern, this.isCaseSensitive, this.isRegExSearch, this.isWholeWord);
            }
            catch (PatternSyntaxException e) {
                return new Status(4, "org.polarsys.capella.core.ui.search", e.getDescription());
            }
        }
        if (this.searchMetaClassItems.isEmpty()) {
            return new Status(4, "org.polarsys.capella.core.ui.search", "At least one metaclass must be selected");
        }
        if (this.searchAttributeItems.isEmpty()) {
            if (!this.searchMetaClassItems.stream().anyMatch(SearchForNoteItem.class::isInstance)) {
                return new Status(4, "org.polarsys.capella.core.ui.search", "At least one attribute must be selected");
            }
        }
        return Status.OK_STATUS;
    }

    public static Pattern createPattern(String textPattern, boolean isCaseSensitive, boolean isRegExSearch, boolean isWholeWord) {
        return PatternConstructor.createPattern((String)textPattern, (boolean)isRegExSearch, (boolean)true, (boolean)isCaseSensitive, (boolean)isWholeWord);
    }

    public Pattern createPattern() {
        return CapellaSearchSettings.createPattern(this.textPattern, this.isCaseSensitive, this.isRegExSearch, this.isWholeWord);
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof CapellaSearchSettings)) {
            return false;
        }
        CapellaSearchSettings that = (CapellaSearchSettings)arg0;
        if (this.isCaseSensitive != that.isCaseSensitive) {
            return false;
        }
        if (this.isRegExSearch != that.isRegExSearch) {
            return false;
        }
        if (this.textPattern == null ? that.textPattern != null : !this.textPattern.equals(that.textPattern)) {
            return false;
        }
        if (this.searchAttributeItems == null ? that.searchAttributeItems != null : !this.searchAttributeItems.equals(that.searchAttributeItems)) {
            return false;
        }
        if (this.searchMetaClassItems == null ? that.searchMetaClassItems != null : !this.searchMetaClassItems.equals(that.searchMetaClassItems)) {
            return false;
        }
        if (this.objectsToSearch == null ? that.objectsToSearch != null : !this.objectsToSearch.equals(that.objectsToSearch)) {
            return false;
        }
        return this.scope == that.scope;
    }

    public int hashCode() {
        int hashCode = 3;
        hashCode += 7 * hashCode + (this.isCaseSensitive ? 1 : 0);
        hashCode += 7 * hashCode + (this.isRegExSearch ? 1 : 0);
        hashCode += 7 * hashCode + (this.textPattern == null ? 0 : this.textPattern.hashCode());
        hashCode += 7 * hashCode + (this.replaceTextPattern == null ? 0 : this.replaceTextPattern.hashCode());
        hashCode += 7 * hashCode + this.searchAttributeItems.hashCode();
        hashCode += 7 * hashCode + this.searchMetaClassItems.hashCode();
        hashCode += 7 * hashCode + this.objectsToSearch.hashCode();
        hashCode += 7 * hashCode + this.scope;
        return hashCode;
    }
}

