/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.ui.search.CapellaReplaceDialog;
import org.polarsys.capella.core.ui.search.CapellaReplaceQuery;
import org.polarsys.capella.core.ui.search.CapellaSearchQuery;
import org.polarsys.capella.core.ui.search.match.SearchMatch;

public class CapellaReplaceRunnable
implements IRunnableWithProgress {
    private final CapellaSearchQuery searchQuery;
    private final Set<SearchMatch> matches;
    private String replacement = null;
    private final boolean rerunQueryAfterReplacement;
    private final CapellaReplaceQuery replaceQuery;

    public CapellaReplaceRunnable(CapellaSearchQuery searchQuery, Set<SearchMatch> matches, boolean rerunQueryAfterReplacement) {
        this.searchQuery = searchQuery;
        this.matches = matches;
        this.rerunQueryAfterReplacement = rerunQueryAfterReplacement;
        this.replaceQuery = new CapellaReplaceQuery(searchQuery.getCapellaSearchSettings());
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        IStatus replaceStatus = this.replaceQuery.run(monitor, this.matches, this.replacement);
        if (replaceStatus.getSeverity() == 4) {
            throw new InterruptedException(replaceStatus.getMessage());
        }
    }

    public boolean askForReplacementText() {
        int occurrencesCount = this.matches.size();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String pattern = this.searchQuery.getCapellaSearchSettings().getTextPattern();
        String title = String.format("Replace:", occurrencesCount);
        CapellaReplaceDialog capellaReplaceDialog = new CapellaReplaceDialog(shell, pattern, title);
        if (capellaReplaceDialog.open() == 0) {
            this.replacement = capellaReplaceDialog.getReplacement();
            this.searchQuery.getCapellaSearchSettings().setReplaceTextPattern(this.replacement);
            return true;
        }
        return false;
    }

    public CapellaSearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public CapellaReplaceQuery getReplaceQuery() {
        return this.replaceQuery;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean isRerunQueryAfterReplacement() {
        return this.rerunQueryAfterReplacement;
    }
}

