/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;
import org.polarsys.capella.core.ui.search.match.SearchMatch;

public class CapellaReplaceQuery {
    private final CapellaSearchSettings capellaSearchSettings;
    Set<EObject> replacedElements = new HashSet<EObject>();
    Set<IProject> replacedProjects = new HashSet<IProject>();
    int replacedOccurrenceCount = 0;

    public CapellaReplaceQuery(CapellaSearchSettings capellaSearchSettings) {
        this.capellaSearchSettings = capellaSearchSettings;
    }

    public IStatus run(IProgressMonitor monitor, Set<SearchMatch> allMatches, String replacement) {
        this.replacedElements = new HashSet<EObject>();
        this.replacedProjects = new HashSet<IProject>();
        this.replacedOccurrenceCount = 0;
        if (replacement == null) {
            return new Status(4, "org.polarsys.capella.core.ui.search", "The replacement must not be null");
        }
        try {
            Pattern searchPattern = this.capellaSearchSettings.createPattern();
            Set<SearchMatch> matches = this.getMinimalSearchMatches(allMatches);
            int countTotalOccurrences = matches.size();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)countTotalOccurrences);
            subMonitor.setTaskName(String.format("Replacing occurrences by '%s'...", replacement));
            for (SearchMatch match : matches) {
                int countOccurrences = 1;
                String projectName = match.getProject().getName();
                subMonitor.subTask(String.format("Replace %d occurrence(s) in the project: %s", countOccurrences, projectName));
                this.replace(match, searchPattern, replacement);
                subMonitor.split(countOccurrences);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e instanceof PatternSyntaxException) {
                message = String.format("The search pattern '%s' is not validated because: %s", ((PatternSyntaxException)e).getPattern(), ((PatternSyntaxException)e).getDescription());
            }
            return new Status(4, "org.polarsys.capella.core.ui.search", message);
        }
    }

    public void replace(SearchMatch capellaMatch, Pattern searchPattern, String replacement) {
        boolean replaced = capellaMatch.replace(searchPattern, replacement);
        if (replaced) {
            this.replacedProjects.add(capellaMatch.getProject());
            this.replacedElements.add((EObject)capellaMatch.getElement());
            this.replacedOccurrenceCount += capellaMatch.getChildren().isEmpty() ? 1 : capellaMatch.getChildren().size();
        }
    }

    public int getReplacedOccurrenceCount() {
        return this.replacedOccurrenceCount;
    }

    public int getReplacedElementCount() {
        return this.replacedElements.size();
    }

    public int getReplacedProjectCount() {
        return this.replacedProjects.size();
    }

    private Set<SearchMatch> getMinimalSearchMatches(Set<SearchMatch> allMatches) {
        HashSet<SearchMatch> minimalMatches = new HashSet<SearchMatch>(allMatches);
        for (SearchMatch originalMatch : allMatches) {
            minimalMatches.removeAll(originalMatch.getChildren());
        }
        return minimalMatches;
    }
}

