/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.diagram.helpers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;

public class DAnnotationHelper {
    public static DAnnotation createAnnotation(String source, DModelElement representation) {
        DAnnotation annotation = DescriptionFactory.eINSTANCE.createDAnnotation();
        annotation.setSource(source);
        representation.getEAnnotations().add((Object)annotation);
        return annotation;
    }

    public static DAnnotation getAnnotation(String source, DModelElement representation, boolean create) {
        for (DAnnotation annotation : representation.getEAnnotations()) {
            if (annotation.getSource() == null || !annotation.getSource().equals(source)) continue;
            return annotation;
        }
        if (create) {
            return DAnnotationHelper.createAnnotation(source, representation);
        }
        return null;
    }

    public static boolean hasAnnotation(String source, DModelElement representation) {
        return DAnnotationHelper.getAnnotation(source, representation, false) != null;
    }

    public static boolean deleteAnnotation(String source, DModelElement representation) {
        DAnnotation annotation = DAnnotationHelper.getAnnotation(source, representation, false);
        if (annotation != null) {
            SiriusUtil.delete((EObject)annotation);
            return true;
        }
        return false;
    }
}

