/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.model.helpers.listeners.EObjectNotificationMap;
import org.polarsys.capella.core.model.helpers.listeners.EventProcessor;

public class MoveElementEventProcessor
implements EventProcessor {
    EObjectNotificationMap newValueNotificationMap = new EObjectNotificationMap();
    EObjectNotificationMap oldValueNotificationMap = new EObjectNotificationMap();

    @Override
    public void add(Notification notif) {
        Object oldValue;
        Object newValue;
        if (notif.getEventType() == 3 && (newValue = notif.getNewValue()) instanceof EObject) {
            this.newValueNotificationMap.add((EObject)newValue, notif);
        }
        if (notif.getEventType() == 4 && (oldValue = notif.getOldValue()) instanceof EObject) {
            this.oldValueNotificationMap.add((EObject)oldValue, notif);
        }
    }

    @Override
    public void clearConsumed() {
        for (Map.Entry entry : this.oldValueNotificationMap.entrySet()) {
            this.clearNotificationChains((NotificationChainImpl)entry.getValue(), (NotificationChainImpl)this.newValueNotificationMap.get(entry.getKey()));
        }
        this.clearMaps();
    }

    @Override
    public void process() {
    }

    private void clearNotificationChains(NotificationChainImpl notifChain1, NotificationChainImpl notifChain2) {
        if (notifChain1 == null || notifChain2 == null) {
            return;
        }
        if (notifChain1.size() == notifChain2.size()) {
            notifChain1.clear();
            notifChain2.clear();
        } else {
            ArrayList<Notification> toRemoveFrom1 = new ArrayList<Notification>();
            ArrayList<Notification> toRemoveFrom2 = new ArrayList<Notification>();
            for (Notification n1 : notifChain1) {
                for (Notification n2 : notifChain2) {
                    if (n1.getNotifier() != n2.getNotifier()) continue;
                    toRemoveFrom1.add(n1);
                    toRemoveFrom2.add(n2);
                }
            }
            notifChain1.removeAll(toRemoveFrom1);
            notifChain1.removeAll(toRemoveFrom2);
        }
    }

    private void clearMaps() {
        NotificationChainImpl chain;
        HashSet<EObject> toRemoveFromNew = new HashSet<EObject>();
        HashSet toRemoveFromOld = new HashSet();
        for (Map.Entry entry : this.newValueNotificationMap.entrySet()) {
            chain = (NotificationChainImpl)entry.getValue();
            if (chain != null && !chain.isEmpty()) continue;
            toRemoveFromNew.add((EObject)entry.getKey());
        }
        for (Map.Entry entry : this.oldValueNotificationMap.entrySet()) {
            chain = (NotificationChainImpl)entry.getValue();
            if (chain == null || chain.isEmpty()) {
                toRemoveFromNew.add((EObject)entry.getKey());
            }
            for (EObject c : toRemoveFromOld) {
                this.oldValueNotificationMap.remove(c);
            }
            for (EObject c : toRemoveFromNew) {
                this.newValueNotificationMap.remove(c);
            }
        }
    }
}

