/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;

public class ComponentPkgExt {
    public static List<Component> getSubDefinedComponents(ComponentPkg componentPkg) {
        ArrayList<Component> components;
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            components = new ArrayList<Component>();
                            if (componentPkg == null) {
                                return Collections.emptyList();
                            }
                            if (!(componentPkg instanceof EntityPkg)) break block6;
                            EntityPkg entityPkg = (EntityPkg)componentPkg;
                            components.addAll((Collection<Component>)entityPkg.getOwnedEntities());
                            for (EntityPkg pkg : entityPkg.getOwnedEntityPkgs()) {
                                components.addAll(ComponentPkgExt.getSubDefinedComponents((ComponentPkg)pkg));
                            }
                            break block7;
                        }
                        if (!(componentPkg instanceof SystemComponentPkg)) break block8;
                        SystemComponentPkg systemComponentPkg = (SystemComponentPkg)componentPkg;
                        components.addAll((Collection<Component>)systemComponentPkg.getOwnedSystemComponents());
                        for (SystemComponentPkg pkg : systemComponentPkg.getOwnedSystemComponentPkgs()) {
                            components.addAll(ComponentPkgExt.getSubDefinedComponents((ComponentPkg)pkg));
                        }
                        break block7;
                    }
                    if (!(componentPkg instanceof LogicalComponentPkg)) break block9;
                    LogicalComponentPkg logicalComponentPkg = (LogicalComponentPkg)componentPkg;
                    components.addAll((Collection<Component>)logicalComponentPkg.getOwnedLogicalComponents());
                    for (LogicalComponentPkg pkg : logicalComponentPkg.getOwnedLogicalComponentPkgs()) {
                        components.addAll(ComponentPkgExt.getSubDefinedComponents((ComponentPkg)pkg));
                    }
                    break block7;
                }
                if (!(componentPkg instanceof PhysicalComponentPkg)) break block10;
                PhysicalComponentPkg physicalComponentPkg = (PhysicalComponentPkg)componentPkg;
                components.addAll((Collection<Component>)physicalComponentPkg.getOwnedPhysicalComponents());
                for (PhysicalComponentPkg pkg : physicalComponentPkg.getOwnedPhysicalComponentPkgs()) {
                    components.addAll(ComponentPkgExt.getSubDefinedComponents((ComponentPkg)pkg));
                }
                break block7;
            }
            if (!(componentPkg instanceof ConfigurationItemPkg)) break block7;
            ConfigurationItemPkg configurationItemComponentPkg = (ConfigurationItemPkg)componentPkg;
            components.addAll((Collection<Component>)configurationItemComponentPkg.getOwnedConfigurationItems());
            for (ConfigurationItemPkg pkg : configurationItemComponentPkg.getOwnedConfigurationItemPkgs()) {
                components.addAll(ComponentPkgExt.getSubDefinedComponents((ComponentPkg)pkg));
            }
        }
        return components;
    }

    public static List<Component> getAllSubDefinedComponents(ComponentPkg componentPkg) {
        ArrayList<Component> components = new ArrayList<Component>();
        List<Component> subDefinedComponents = ComponentPkgExt.getSubDefinedComponents(componentPkg);
        components.addAll(subDefinedComponents);
        subDefinedComponents.stream().forEach(c -> {
            boolean bl = components.addAll(ComponentExt.getAllSubDefinedComponents(c));
        });
        return components;
    }

    public static List<Component> getAllActors(ComponentPkg componentPkg) {
        return ComponentPkgExt.getAllSubDefinedComponents(componentPkg).stream().filter(ComponentExt::isActor).collect(Collectors.toList());
    }

    public static List<Component> getExternalActors(ComponentPkg componentPkg) {
        return ComponentPkgExt.getAllActors(componentPkg).stream().filter(ComponentExt::isExternalActor).collect(Collectors.toList());
    }

    public static List<Component> getSubUsedComponents(ComponentPkg componentPkg) {
        return PartExt.getComponentsOfParts(ComponentPkgExt.getSubParts(componentPkg));
    }

    public static List<Part> getSubParts(ComponentPkg componentPkg) {
        ArrayList<Part> result = new ArrayList<Part>();
        result.addAll((Collection<Part>)componentPkg.getOwnedParts());
        ComponentPkgExt.getContainedComponentPkgs(componentPkg).stream().forEach(pkg -> {
            boolean bl = result.addAll(ComponentPkgExt.getSubParts(pkg));
        });
        return result;
    }

    public static List<ComponentPkg> getContainedComponentPkgs(ComponentPkg componentPkg) {
        if (componentPkg == null) {
            return Collections.emptyList();
        }
        ArrayList<ComponentPkg> componentPkgs = new ArrayList<ComponentPkg>();
        if (componentPkg instanceof EntityPkg) {
            componentPkgs.addAll((Collection<ComponentPkg>)((EntityPkg)componentPkg).getOwnedEntityPkgs());
        } else if (componentPkg instanceof SystemComponentPkg) {
            componentPkgs.addAll((Collection<ComponentPkg>)((SystemComponentPkg)componentPkg).getOwnedSystemComponentPkgs());
        } else if (componentPkg instanceof LogicalComponentPkg) {
            componentPkgs.addAll((Collection<ComponentPkg>)((LogicalComponentPkg)componentPkg).getOwnedLogicalComponentPkgs());
        } else if (componentPkg instanceof PhysicalComponentPkg) {
            componentPkgs.addAll((Collection<ComponentPkg>)((PhysicalComponentPkg)componentPkg).getOwnedPhysicalComponentPkgs());
        } else if (componentPkg instanceof ConfigurationItemPkg) {
            componentPkgs.addAll((Collection<ComponentPkg>)((ConfigurationItemPkg)componentPkg).getOwnedConfigurationItemPkgs());
        }
        return componentPkgs;
    }

    public static Component getParentComponent(ComponentPkg componentPkg) {
        EObject object = componentPkg.eContainer();
        while (object != null) {
            if (object instanceof BlockArchitecture) {
                return null;
            }
            if (object instanceof Component) {
                return (Component)object;
            }
            object = object.eContainer();
        }
        return null;
    }

    public static boolean isRootComponentPkg(EObject object) {
        return object instanceof ComponentPkg && object.eContainer() instanceof BlockArchitecture;
    }

    /*
     * Unable to fully structure code
     */
    public static ComponentPkg getRootComponentPkg(EObject object) {
        parent = object.eContainer();
        if (!(parent instanceof BlockArchitecture) || !(object instanceof ComponentPkg)) ** GOTO lbl8
        return (ComponentPkg)object;
lbl-1000:
        // 1 sources

        {
            grandParent = parent.eContainer();
            if (parent instanceof ComponentPkg && grandParent instanceof BlockArchitecture) {
                return (ComponentPkg)parent;
            }
            parent = grandParent;
lbl8:
            // 2 sources

            ** while (parent != null)
        }
lbl9:
        // 1 sources

        return null;
    }

    public static List<Component> getContainedComponents(ComponentPkg componentPkg) {
        if (componentPkg == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        if (componentPkg instanceof EntityPkg) {
            components.addAll((Collection<Component>)((EntityPkg)componentPkg).getOwnedEntities());
        } else if (componentPkg instanceof SystemComponentPkg) {
            components.addAll((Collection<Component>)((SystemComponentPkg)componentPkg).getOwnedSystemComponents());
        } else if (componentPkg instanceof LogicalComponentPkg) {
            components.addAll((Collection<Component>)((LogicalComponentPkg)componentPkg).getOwnedLogicalComponents());
        } else if (componentPkg instanceof PhysicalComponentPkg) {
            components.addAll((Collection<Component>)((PhysicalComponentPkg)componentPkg).getOwnedPhysicalComponents());
        }
        return components;
    }

    public static boolean canMoveInto(Component source, ComponentPkg target) {
        Component parentComponent = ComponentPkgExt.getParentComponent(target);
        if (parentComponent != null) {
            return ComponentExt.canMoveInto(source, parentComponent);
        }
        return (!ComponentExt.isActor(source) || ComponentExt.canCreateABActor((EObject)target)) && (ComponentExt.isActor(source) || ComponentExt.canCreateABComponent((EObject)target));
    }
}

