/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.KeyPart;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.information.communication.Exception;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;

public class ClassExt {
    public static boolean containsKeyPart(Class class1, Property property1) {
        return ClassExt.getRelatedKeyPart(class1, property1) != null;
    }

    public static Collection<Class> getAllClasses(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_CLASSES, (Object)context);
    }

    public static Map<AbstractDependenciesPkg, Collection<EObject>> getClassDependencies2(Class class1) {
        HashMap<AbstractDependenciesPkg, Collection<EObject>> result = new HashMap<AbstractDependenciesPkg, Collection<EObject>>();
        for (Property aProperty : class1.getContainedProperties()) {
            AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)aProperty.getType());
            ClassExt.checkDependenciesAndAddToResult(result, aProperty.getOwnedMaxCard());
            ClassExt.checkDependenciesAndAddToResult(result, aProperty.getOwnedMinCard());
        }
        for (Operation anOperation : class1.getContainedOperations()) {
            if (anOperation instanceof Service) {
                for (Exception anException : ((Service)anOperation).getThrownExceptions()) {
                    AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)anException);
                }
            }
            for (Parameter aParameter : anOperation.getOwnedParameters()) {
                AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)aParameter.getType());
                ClassExt.checkDependenciesAndAddToResult(result, aParameter.getOwnedMaxCard());
                ClassExt.checkDependenciesAndAddToResult(result, aParameter.getOwnedMinCard());
            }
        }
        for (Generalization aGeneralization : class1.getSuperGeneralizations()) {
            AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)aGeneralization.getSuper());
        }
        return result;
    }

    private static void checkDependenciesAndAddToResult(Map<AbstractDependenciesPkg, Collection<EObject>> result, NumericValue card) {
        if (card instanceof NumericReference) {
            AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)((NumericReference)card).getReferencedValue());
        }
    }

    public static Collection<AbstractDependenciesPkg> getClassDependencies(Class class1) {
        return ClassExt.getClassDependencies2(class1).keySet();
    }

    public static DataPkg getOwnerDataPkg(Class class1) {
        if (class1.eContainer() instanceof Class) {
            return ClassExt.getOwnerDataPkg((Class)class1.eContainer());
        }
        if (class1.eContainer() instanceof DataPkg) {
            return (DataPkg)class1.eContainer();
        }
        return null;
    }

    public static KeyPart getRelatedKeyPart(Class class1, Property property) {
        for (KeyPart keyPart : class1.getKeyParts()) {
            if (keyPart.getProperty() == null || !keyPart.getProperty().equals(property)) continue;
            return keyPart;
        }
        return null;
    }

    public static DataPkg getRootOwnerDataPkg(Class class1) {
        if (class1.eContainer() instanceof Class) {
            return ClassExt.getRootOwnerDataPkg((Class)class1.eContainer());
        }
        if (class1.eContainer() instanceof DataPkg) {
            return DataPkgExt.getRootDataPkg((DataPkg)class1.eContainer());
        }
        return null;
    }

    public static List<Association> getOutgoingAssociations(Classifier classif) {
        ArrayList<Association> result = new ArrayList<Association>();
        List<Association> allAssociations = ClassExt.getAllAssociations(classif);
        for (Association assoc : allAssociations) {
            if (!AssociationExt.isUnidirectional((EObject)assoc) || !AssociationExt.getOwnedMembersClassifiers(assoc).contains(classif)) continue;
            result.add(assoc);
        }
        return result;
    }

    public static List<Association> getIncomingAssociations(Classifier classif) {
        ArrayList<Association> result = new ArrayList<Association>();
        List<Association> allAssociations = ClassExt.getAllAssociations(classif);
        for (Association assoc : allAssociations) {
            if (!AssociationExt.isUnidirectional((EObject)assoc) || !AssociationExt.getNavigableMembersClassifiers(assoc).contains(classif)) continue;
            result.add(assoc);
        }
        return result;
    }

    public static List<Association> getNondirectionalAssociations(Classifier classif) {
        List<Association> allAssociations = ClassExt.getAllAssociations(classif);
        ArrayList<Association> result = new ArrayList<Association>();
        for (Association assoc : allAssociations) {
            if (!AssociationExt.isNondirectional((EObject)assoc) || !AssociationExt.getOwnedMembersClassifiers(assoc).contains(classif)) continue;
            result.add(assoc);
        }
        return result;
    }

    public static List<Association> getBidirectionalAssociations(Classifier classif) {
        List<Association> allAssociations = ClassExt.getAllAssociations(classif);
        ArrayList<Association> result = new ArrayList<Association>();
        for (Association assoc : allAssociations) {
            if (!AssociationExt.isBidirectional((EObject)assoc) || !AssociationExt.getNavigableMembersClassifiers(assoc).contains(classif)) continue;
            result.add(assoc);
        }
        return result;
    }

    public static List<Association> getAllAssociationsButIncoming(Classifier classif) {
        ArrayList<Association> result = new ArrayList<Association>();
        result.addAll(ClassExt.getOutgoingAssociations(classif));
        result.addAll(ClassExt.getBidirectionalAssociations(classif));
        result.addAll(ClassExt.getNondirectionalAssociations(classif));
        return result;
    }

    public static List<Association> getAllAssociations(Classifier classif) {
        List<Association> result = new ArrayList<Association>();
        BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)classif);
        if (arch != null) {
            DataPkg dataPkg = arch.getOwnedDataPkg();
            result = DataPkgExt.getAllAssociations(dataPkg);
        }
        return result;
    }
}

