/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.helpers.ctx.services.CapabilityExt;
import org.polarsys.capella.core.data.helpers.ctx.services.OperationalCapabilityExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractFunctionAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.interaction.FunctionalChainAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.model.helpers.CapabilityRealizationExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;

public class AbstractCapabilityExt {
    public static void addInvolvedComponent(AbstractCapability capability, Component component) {
        if (capability instanceof OperationalCapability && component instanceof Entity) {
            OperationalCapabilityExt.addInvolvedEntity((OperationalCapability)((OperationalCapability)capability), (Entity)((Entity)component));
        } else if (capability instanceof Capability && component instanceof SystemComponent) {
            CapabilityExt.addInvolvedSystemComponent((Capability)((Capability)capability), (SystemComponent)((SystemComponent)component));
        } else if (capability instanceof CapabilityRealization) {
            CapabilityRealizationExt.addInvolvedComponent((CapabilityRealization)capability, component);
        }
    }

    public static List<Scenario> getAllScenarios(AbstractCapability currentElement) {
        ArrayList<Scenario> scList = new ArrayList<Scenario>();
        Set scSet = EObjectExt.getAll((EObject)currentElement, (EClass)InteractionPackage.Literals.SCENARIO);
        if (scSet != null) {
            for (EObject obj : scSet) {
                scList.add((Scenario)obj);
            }
        }
        return scList;
    }

    public static List<Component> getInvolvedComponents(AbstractCapability capability) {
        ArrayList<Component> involvedComponents = new ArrayList<Component>();
        if (capability instanceof OperationalCapability) {
            involvedComponents.addAll(OperationalCapabilityExt.getInvolvedEntities((OperationalCapability)((OperationalCapability)capability)));
        } else if (capability instanceof Capability) {
            involvedComponents.addAll(CapabilityExt.getInvolvedSystemComponents((Capability)((Capability)capability)));
        } else if (capability instanceof CapabilityRealization) {
            involvedComponents.addAll(((CapabilityRealization)capability).getInvolvedComponents().stream().filter(Component.class::isInstance).map(Component.class::cast).collect(Collectors.toList()));
        }
        return involvedComponents;
    }

    public static AbstractCapabilityPkg getOwnerAbstractCapabilityPkg(AbstractCapability capability) {
        AbstractCapabilityPkg aspectPkg = null;
        if (capability != null) {
            aspectPkg = (AbstractCapabilityPkg)EcoreUtil2.getFirstContainer((EObject)capability, (EClass)CapellacommonPackage.Literals.ABSTRACT_CAPABILITY_PKG);
        }
        return aspectPkg;
    }

    public static void removeInvolvedComponent(AbstractCapability capability, Component component) {
        if (capability instanceof Capability && component instanceof SystemComponent) {
            CapabilityExt.removeInvolvedSystemComponent((Capability)((Capability)capability), (SystemComponent)((SystemComponent)component));
        } else if (capability instanceof CapabilityRealization) {
            CapabilityRealizationExt.removeInvolvedComponent((CapabilityRealization)capability, component);
        }
    }

    public static List<Component> getComponentsFromAbstractCapabilityScenarios(AbstractCapability abstractCapability) {
        ArrayList<Component> result = new ArrayList<Component>();
        EList scenarios = abstractCapability.getOwnedScenarios();
        for (Scenario scenario : scenarios) {
            List<Component> components = ScenarioExt.getOwnedComponents(scenario);
            if (components.isEmpty()) continue;
            result.addAll(components);
        }
        return result;
    }

    public static List<Component> getComponentsFromAbstractCapabilityFunctionalChains(AbstractCapability abstractCapability) {
        ArrayList<Component> result = new ArrayList<Component>();
        List<FunctionalChain> funcionalChains = AbstractCapabilityExt.getFunctionalChains(abstractCapability);
        for (FunctionalChain chain : funcionalChains) {
            List<Component> components = FunctionalChainExt.getComponents(chain);
            if (components.isEmpty()) continue;
            result.addAll(components);
        }
        return result;
    }

    public static List<FunctionalChain> getFunctionalChains(AbstractCapability abstractCapability) {
        ArrayList<FunctionalChain> functionalChains = new ArrayList<FunctionalChain>();
        EList chainsLink = abstractCapability.getOwnedFunctionalChainAbstractCapabilityInvolvements();
        for (FunctionalChainAbstractCapabilityInvolvement chainL : chainsLink) {
            FunctionalChain functionalChain = chainL.getFunctionalChain();
            if (functionalChain == null) continue;
            functionalChains.add(functionalChain);
        }
        return functionalChains;
    }

    public static void addInvolvedFunction(AbstractCapability capability, AbstractFunction function) {
        if (!capability.getInvolvedAbstractFunctions().contains((Object)function)) {
            AbstractFunctionAbstractCapabilityInvolvement link = InteractionFactory.eINSTANCE.createAbstractFunctionAbstractCapabilityInvolvement();
            link.setInvolved((InvolvedElement)function);
            capability.getOwnedAbstractFunctionAbstractCapabilityInvolvements().add((Object)link);
        }
    }

    public static void addInvolvedFunctionalChain(AbstractCapability capability, FunctionalChain functionalChain) {
        if (!capability.getInvolvedFunctionalChains().contains((Object)functionalChain)) {
            FunctionalChainAbstractCapabilityInvolvement link = InteractionFactory.eINSTANCE.createFunctionalChainAbstractCapabilityInvolvement();
            link.setInvolved((InvolvedElement)functionalChain);
            capability.getOwnedFunctionalChainAbstractCapabilityInvolvements().add((Object)link);
        }
    }
}

