/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceInfo;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.Messages;

public class PortReferenceUpdater {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
    private final InterfaceInfo info;

    PortReferenceUpdater(InterfaceInfo info) {
        this.info = info;
    }

    private Object[] getArgs(EObject ... args) {
        Object[] result = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            result[i] = EObjectLabelProviderHelper.getText((Object)args[i]);
            ++i;
        }
        return result;
    }

    void updatePortReferences() {
        Interface iface = this.info.getInterface(false);
        if (iface != null) {
            EObject port;
            for (EObject pre : EObjectExt.getReferencers((EObject)iface, (EReference)InformationPackage.Literals.PORT__PROVIDED_INTERFACES)) {
                if (this.info.getProvider() != null && this.info.getProvider().getEObject() == pre) continue;
                ((Port)pre).getProvidedInterfaces().remove((Object)iface);
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)new EmbeddedMessage(NLS.bind((String)Messages.PortReferenceUpdater_remove_provided_interface, (Object[])this.getArgs(new EObject[]{pre, pre.eContainer(), iface})), logger.getName(), (Object)new Object[]{pre, iface}));
            }
            if (this.info.getProvider() != null && this.info.getProvider().addProvidedInterface(iface)) {
                port = this.info.getProvider().getEObject();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)new EmbeddedMessage(NLS.bind((String)Messages.PortReferenceUpdater_add_provided_interface, (Object[])this.getArgs(new EObject[]{port, port.eContainer(), iface})), logger.getName(), (Object)new Object[]{port, iface}));
                }
            }
            for (EObject pre : EObjectExt.getReferencers((EObject)iface, (EReference)InformationPackage.Literals.PORT__REQUIRED_INTERFACES)) {
                if (this.info.getRequirer() != null && this.info.getRequirer().getEObject() == pre) continue;
                ((Port)pre).getRequiredInterfaces().remove((Object)iface);
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)new EmbeddedMessage(NLS.bind((String)Messages.PortReferenceUpdater_remove_required_interface, (Object[])this.getArgs(new EObject[]{pre, pre.eContainer(), iface})), logger.getName(), (Object)new Object[]{pre, iface}));
            }
            if (this.info.getRequirer() != null && this.info.getRequirer().addRequiredInterface(iface) && logger.isInfoEnabled()) {
                port = this.info.getRequirer().getEObject();
                logger.info((Object)new EmbeddedMessage(NLS.bind((String)Messages.PortReferenceUpdater_add_required_interface, (Object[])this.getArgs(new EObject[]{port, port.eContainer(), iface})), logger.getName(), (Object)new Object[]{port, iface}));
            }
        }
    }
}

