/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.widgets.filter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class CapellaPatternFilter
extends PatternFilter {
    private String pattern;
    StringMatcher matcher;
    private boolean caseSensitiveEnabled = false;

    protected String getText(Viewer viewer, Object element) {
        return ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText = this.getText(viewer, element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    public void setPattern(String patternString) {
        super.setPattern(patternString);
        if (patternString != null) {
            this.pattern = patternString;
            if (!patternString.endsWith(" ")) {
                patternString = String.valueOf(patternString) + "*";
            }
            this.matcher = new StringMatcher(patternString, !this.caseSensitiveEnabled, false);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    protected boolean wordMatches(String text) {
        if (this.pattern == null || this.pattern.isEmpty()) {
            return true;
        }
        if (text == null) {
            return false;
        }
        return this.matcher.match(text);
    }

    public void setCaseSensitiveEnabled(boolean caseSensitiveEnabled) {
        this.caseSensitiveEnabled = caseSensitiveEnabled;
    }

    public void doSetUseCache(boolean useCache) {
        try {
            Method setUseCacheMethod = PatternFilter.class.getDeclaredMethod("setUseCache", Boolean.TYPE);
            setUseCacheMethod.setAccessible(true);
            setUseCacheMethod.invoke((Object)this, useCache);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void doClearCaches() {
        try {
            Method clearCachesMethod = PatternFilter.class.getDeclaredMethod("clearCaches", new Class[0]);
            clearCachesMethod.setAccessible(true);
            clearCachesMethod.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

