/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.menu;

import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.capella.common.ui.toolkit.viewers.menu.ContextMenuSelectionService;

public class ModalContextMenuExtender {
    @Inject
    IEclipseContext context;
    String location;
    IServiceLocator locator;
    ISelectionProvider provider;
    MenuManager contributionManager;
    IEclipseContext popupContext = null;

    public ModalContextMenuExtender(MenuManager contributionManager, String locationUri, ISelectionProvider provider, IServiceLocator locator) {
        this.contributionManager = contributionManager;
        this.location = locationUri;
        if (this.location.startsWith("popup:")) {
            this.location = this.location.replaceFirst("popup:", "");
        }
        this.provider = provider;
        this.locator = locator;
    }

    public void registerContextMenu() {
        if (this.location == null || this.location.isEmpty()) {
            return;
        }
        final ContextMenuSelectionService newService = new ContextMenuSelectionService(this.provider);
        this.contributionManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IEclipseContext currentContext = ModalContextMenuExtender.this.context.getActiveLeaf();
                if (ModalContextMenuExtender.this.popupContext == null && currentContext.toString().equals("popup:" + ModalContextMenuExtender.this.location)) {
                    ModalContextMenuExtender.this.popupContext = currentContext;
                }
                if (ModalContextMenuExtender.this.popupContext != null) {
                    ModalContextMenuExtender.this.popupContext.set(ISelectionService.class.getName(), (Object)newService);
                    ModalContextMenuExtender.this.popupContext.set("selection", (Object)newService.getSelection());
                    ModalContextMenuExtender.this.popupContext.set("activeMenuSelection", (Object)newService.getSelection());
                    ModalContextMenuExtender.this.popupContext.set("activePartId", (Object)"modal");
                    ModalContextMenuExtender.this.popupContext.processWaiting();
                }
            }
        });
        IMenuService menuService = (IMenuService)this.locator.getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)this.contributionManager, this.location);
        PartSite.registerContextMenu((String)this.location, (MenuManager)this.contributionManager, (ISelectionProvider)this.provider, (boolean)false, (IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), (IEclipseContext)this.context, new ArrayList());
    }

    public static ModalContextMenuExtender registerContextMenu(MenuManager _contextMenuManager, String contextMenuLocation, ISelectionProvider provider) {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IEclipseContext.class);
        ModalContextMenuExtender popupPopulator = new ModalContextMenuExtender(_contextMenuManager, contextMenuLocation, provider, (IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        ContextInjectionFactory.inject((Object)popupPopulator, (IEclipseContext)context);
        popupPopulator.registerContextMenu();
        return popupPopulator;
    }
}

