/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class UI {
    public static final Color ERROR_COLOR;
    public static final Color DEFAULT_COLOR;

    static {
        Display.getDefault().disposeExec(new Runnable(){

            @Override
            public void run() {
                UI.dispose();
            }
        });
        ERROR_COLOR = Display.getDefault().getSystemColor(3);
        DEFAULT_COLOR = Display.getDefault().getSystemColor(2);
    }

    protected static void dispose() {
        ERROR_COLOR.dispose();
        DEFAULT_COLOR.dispose();
    }

    public static int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    public static int convertVerticalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        double verticalDialogUnitSize = (double)height * 0.125;
        return (int)Math.round((double)dlus * verticalDialogUnitSize);
    }

    public static void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
    }
}

