/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.SafeRunnable;
import org.eclipse.egit.core.internal.indexdiff.GitResourceDeltaVisitor;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffUpdateJob;
import org.eclipse.egit.core.internal.indexdiff.SkipNotInterestingDeltaVisitor;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IndexReadException;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.InterIndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.util.NLS;

public class IndexDiffCacheEntry {
    private static final int RESOURCE_LIST_UPDATE_LIMIT = 1000;
    private final File repositoryGitDir;
    private final String repositoryName;
    private volatile IndexDiffData indexDiffData;
    private Job reloadJob;
    private volatile boolean reloadJobIsInitializing;
    private IndexDiffUpdateJob updateJob;
    private DirCache lastIndex;
    private ReentrantLock lock = new ReentrantLock(true);
    private CopyOnWriteArrayList<IndexDiffChangedListener> listeners = new CopyOnWriteArrayList();
    private final IndexChangedListener indexChangedListener = new IndexChangedListener(){

        public void onIndexChanged(IndexChangedEvent event) {
            IndexDiffCacheEntry.this.refreshIndexDelta();
        }
    };
    private final RefsChangedListener refsChangedListener = new RefsChangedListener(){

        public void onRefsChanged(RefsChangedEvent event) {
            IndexDiffCacheEntry.this.scheduleReloadJob("RefsChanged");
        }
    };
    private final Set<ListenerHandle> listenerHandles = new HashSet<ListenerHandle>();
    private final Map<Repository, String> submodules = new HashMap<Repository, String>();
    private final IndexDiffChangedListener submoduleListener = (submodule, diffData) -> {
        String path = this.submodules.get(submodule);
        if (path != null) {
            this.scheduleUpdateJob(Collections.singletonList(path), Collections.emptyList());
        }
    };
    private IResourceChangeListener resourceChangeListener;
    private static Semaphore parallelism = new Semaphore(2);

    public IndexDiffCacheEntry(Repository repository, @Nullable IndexDiffChangedListener listener) {
        this.repositoryGitDir = repository.getDirectory();
        this.repositoryName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        if (listener != null) {
            this.addIndexDiffChangedListener(listener);
        }
        this.listenerHandles.add(repository.getListenerList().addIndexChangedListener(this.indexChangedListener));
        this.listenerHandles.add(repository.getListenerList().addRefsChangedListener(this.refsChangedListener));
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repository);){
                while (walk.next()) {
                    Repository submodule2 = walk.getRepository();
                    if (submodule2 == null || submodule2.isBare()) continue;
                    Repository cached = Activator.getDefault().getRepositoryCache().lookupRepository(submodule2.getDirectory().getAbsoluteFile());
                    this.submodules.put(cached, walk.getPath());
                    IndexDiffCacheEntry submoduleCache = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(cached);
                    if (submoduleCache != null) {
                        submoduleCache.addIndexDiffChangedListener(this.submoduleListener);
                    }
                    submodule2.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            Activator.logError(MessageFormat.format(CoreText.IndexDiffCacheEntry_errorCalculatingIndexDelta, repository), ex);
        }
        this.scheduleReloadJob("IndexDiffCacheEntry construction");
        this.createResourceChangeListener();
        if (!repository.isBare()) {
            try {
                this.lastIndex = DirCache.read((File)repository.getIndexFile(), (FS)repository.getFS());
            }
            catch (IOException ex) {
                Activator.logError(MessageFormat.format(CoreText.IndexDiffCacheEntry_errorCalculatingIndexDelta, repository), ex);
            }
        }
    }

    @Nullable
    private Repository getRepository() {
        if (Activator.getDefault() == null) {
            return null;
        }
        Repository repository = Activator.getDefault().getRepositoryCache().getRepository(this.repositoryGitDir);
        if (repository == null) {
            return null;
        }
        File directory = repository.getDirectory();
        if (directory == null || !directory.exists()) {
            return null;
        }
        return repository;
    }

    public void addIndexDiffChangedListener(IndexDiffChangedListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeIndexDiffChangedListener(IndexDiffChangedListener listener) {
        this.listeners.remove(listener);
    }

    public Job createRefreshResourcesAndIndexDiffJob() {
        String jobName = MessageFormat.format(CoreText.IndexDiffCacheEntry_refreshingProjects, this.repositoryName);
        WorkspaceJob job = new WorkspaceJob(jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Repository repository = IndexDiffCacheEntry.this.getRepository();
                if (repository == null) {
                    return Status.CANCEL_STATUS;
                }
                long start = System.currentTimeMillis();
                ISchedulingRule rule = RuleUtil.getRule(repository);
                try {
                    Job.getJobManager().beginRule(rule, monitor);
                    try {
                        IProject[] validOpenProjects = ProjectUtil.getValidOpenProjects(repository);
                        repository = null;
                        ResourcesPlugin.getWorkspace().run(pm -> ProjectUtil.refreshResources((IResource[])validOpenProjects, pm), null, 1, monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.error(e.getMessage(), e);
                        Job.getJobManager().endRule(rule);
                        repository = null;
                        return iStatus;
                    }
                    try {
                        if (Activator.getDefault().isDebugging()) {
                            long refresh = System.currentTimeMillis();
                            Activator.logInfo("Resources refresh took " + (refresh - start) + " ms for " + IndexDiffCacheEntry.this.repositoryName);
                        }
                    }
                    catch (OperationCanceledException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                finally {
                    Job.getJobManager().endRule(rule);
                    repository = null;
                }
                IndexDiffCacheEntry.this.refresh();
                Job next = IndexDiffCacheEntry.this.reloadJob;
                if (next != null) {
                    try {
                        next.join();
                    }
                    catch (InterruptedException e) {
                        return Status.CANCEL_STATUS;
                    }
                }
                if (Activator.getDefault().isDebugging()) {
                    long refresh = System.currentTimeMillis();
                    Activator.logInfo("Diff took " + (refresh - start) + " ms for " + IndexDiffCacheEntry.this.repositoryName);
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    public void refresh() {
        this.scheduleReloadJob("Refresh called");
    }

    public void refreshFiles(Collection<String> filesToRefresh) {
        List<IResource> resources = Collections.emptyList();
        this.scheduleUpdateJob(filesToRefresh, resources);
    }

    private void refreshIndexDelta() {
        Repository repository = this.getRepository();
        if (repository == null || repository.isBare()) {
            return;
        }
        try {
            DirCache currentIndex = DirCache.read((File)repository.getIndexFile(), (FS)repository.getFS());
            DirCache oldIndex = this.lastIndex;
            this.lastIndex = currentIndex;
            if (oldIndex == null) {
                this.refresh();
                return;
            }
            TreeSet<String> paths = new TreeSet<String>();
            Throwable throwable = null;
            Object var6_8 = null;
            try (TreeWalk walk = new TreeWalk(repository);){
                walk.addTree((AbstractTreeIterator)new DirCacheIterator(oldIndex));
                walk.addTree((AbstractTreeIterator)new DirCacheIterator(currentIndex));
                walk.setFilter((TreeFilter)new InterIndexDiffFilter());
                while (walk.next()) {
                    if (walk.isSubtree()) {
                        walk.enterSubtree();
                        continue;
                    }
                    paths.add(walk.getPathString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!paths.isEmpty()) {
                this.refreshFiles(paths);
            }
        }
        catch (IOException ex) {
            Activator.logError(MessageFormat.format(CoreText.IndexDiffCacheEntry_errorCalculatingIndexDelta, repository), ex);
            this.scheduleReloadJob("Exception while calculating index delta, doing full reload instead");
        }
    }

    public IndexDiffData getIndexDiff() {
        return this.indexDiffData;
    }

    protected void scheduleReloadJob(final String trigger) {
        if (this.reloadJob != null) {
            if (this.reloadJobIsInitializing) {
                return;
            }
            this.reloadJob.cancel();
        }
        if (this.updateJob != null) {
            this.updateJob.cleanupAndCancel();
        }
        if (this.getRepository() == null) {
            return;
        }
        this.reloadJob = new Job(this.getReloadJobName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IndexDiffCacheEntry.this.reloadJobIsInitializing = true;
                    IndexDiffCacheEntry.this.waitForWorkspaceLock(monitor);
                }
                finally {
                    IndexDiffCacheEntry.this.reloadJobIsInitializing = false;
                }
                IndexDiffCacheEntry.this.lock.lock();
                try {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    parallelism.acquire();
                    long startTime = System.currentTimeMillis();
                    Repository repository = IndexDiffCacheEntry.this.getRepository();
                    if (repository == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffData result = IndexDiffCacheEntry.this.calcIndexDiffDataFull(monitor, this.getName(), repository);
                    if (monitor.isCanceled() || result == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffCacheEntry.this.indexDiffData = result;
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        long time = System.currentTimeMillis() - startTime;
                        StringBuilder message = new StringBuilder(this.getTraceMessage(time));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), message.append(IndexDiffCacheEntry.this.indexDiffData.toString()).toString());
                    }
                    IndexDiffCacheEntry.this.notifyListeners(repository);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (IndexReadException e) {
                    IStatus iStatus = Activator.error(CoreText.IndexDiffCacheEntry_cannotReadIndex, e);
                    return iStatus;
                }
                catch (IOException e) {
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), "Calculating IndexDiff failed", (Throwable)e);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InterruptedException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    IndexDiffCacheEntry.this.lock.unlock();
                    parallelism.release();
                }
            }

            private String getTraceMessage(long time) {
                return NLS.bind((String)"\nUpdated IndexDiffData in {0} ms\nReason: {1}\nRepository: {2}\n", (Object[])new Object[]{time, trigger, IndexDiffCacheEntry.this.repositoryGitDir});
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.INDEX_DIFF_CACHE_UPDATE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        this.reloadJob.setSystem(true);
        this.reloadJob.schedule();
    }

    private void waitForWorkspaceLock(IProgressMonitor monitor) {
        Repository repository = this.getRepository();
        Object rule = repository == null ? ResourcesPlugin.getWorkspace().getRoot() : RuleUtil.getRule(repository);
        try {
            try {
                Job.getJobManager().beginRule((ISchedulingRule)rule, monitor);
            }
            catch (OperationCanceledException e) {
                Job.getJobManager().endRule((ISchedulingRule)rule);
                return;
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
    }

    protected void scheduleUpdateJob(Collection<String> filesToUpdate, Collection<IResource> resourcesToUpdate) {
        if (this.getRepository() == null) {
            return;
        }
        if (this.reloadJob != null && this.reloadJobIsInitializing) {
            return;
        }
        if (this.shouldReload(filesToUpdate)) {
            this.scheduleReloadJob("Too many resources changed: " + filesToUpdate.size());
            return;
        }
        if (this.updateJob != null) {
            this.updateJob.addChanges(filesToUpdate, resourcesToUpdate);
            return;
        }
        this.updateJob = new IndexDiffUpdateJob(this.getUpdateJobName(), 10L){

            @Override
            protected IStatus updateIndexDiff(Collection<String> files, Collection<IResource> resources, IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (IndexDiffCacheEntry.this.shouldReload(files)) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("Too many resources changed: " + files.size());
                    return Status.CANCEL_STATUS;
                }
                IndexDiffCacheEntry.this.waitForWorkspaceLock(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IndexDiffCacheEntry.this.lock.lock();
                try {
                    long startTime = System.currentTimeMillis();
                    Repository repository = IndexDiffCacheEntry.this.getRepository();
                    if (repository == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffData result = IndexDiffCacheEntry.this.calcIndexDiffDataIncremental(monitor, this.getName(), repository, files, resources);
                    if (monitor.isCanceled() || result == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffCacheEntry.this.indexDiffData = result;
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        long time = System.currentTimeMillis() - startTime;
                        StringBuilder message = new StringBuilder(NLS.bind((String)"Updated IndexDiffData based on resource list (length = {0}) in {1} ms\n", (Object)resources.size(), (Object)time));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), message.append(IndexDiffCacheEntry.this.indexDiffData.toString()).toString());
                    }
                    IndexDiffCacheEntry.this.notifyListeners(repository);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (IOException e) {
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), "Calculating IndexDiff failed", (Throwable)e);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    IndexDiffCacheEntry.this.lock.unlock();
                }
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.INDEX_DIFF_CACHE_UPDATE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        this.updateJob.addChanges(filesToUpdate, resourcesToUpdate);
    }

    protected boolean shouldReload(Collection<String> filesToUpdate) {
        return filesToUpdate.size() > 1000;
    }

    private IndexDiffData calcIndexDiffDataIncremental(IProgressMonitor monitor, String jobName, Repository repository, Collection<String> filesToUpdate, Collection<IResource> resourcesToUpdate) throws IOException {
        if (this.indexDiffData == null) {
            return this.calcIndexDiffDataFull(monitor, jobName, repository);
        }
        EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
        List<String> treeFilterPaths = this.calcTreeFilterPaths(filesToUpdate);
        WorkingTreeIterator iterator = IteratorService.createInitialIterator(repository);
        if (iterator == null) {
            return null;
        }
        IndexDiff diffForChangedResources = new IndexDiff(repository, "HEAD", iterator);
        diffForChangedResources.setFilter(PathFilterGroup.createFromStrings(treeFilterPaths));
        diffForChangedResources.diff((ProgressMonitor)jgitMonitor, 0, 0, jobName);
        IndexDiffData previous = this.indexDiffData;
        if (previous == null) {
            return null;
        }
        return new IndexDiffData(previous, filesToUpdate, resourcesToUpdate, diffForChangedResources);
    }

    private List<String> calcTreeFilterPaths(Collection<String> filesToUpdate) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String fileToUpdate : filesToUpdate) {
            for (String untrackedFolder : this.indexDiffData.getUntrackedFolders()) {
                if (!fileToUpdate.startsWith(untrackedFolder) || fileToUpdate.equals(untrackedFolder)) continue;
                paths.add(untrackedFolder);
            }
            paths.add(fileToUpdate);
        }
        return paths;
    }

    private void notifyListeners(Repository repository) {
        for (IndexDiffChangedListener listener : this.listeners) {
            SafeRunnable.run(() -> listener.indexDiffChanged(repository, this.indexDiffData));
        }
    }

    private IndexDiffData calcIndexDiffDataFull(IProgressMonitor monitor, String jobName, Repository repository) throws IOException {
        EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
        WorkingTreeIterator iterator = IteratorService.createInitialIterator(repository);
        if (iterator == null) {
            return null;
        }
        IndexDiff newIndexDiff = new IndexDiff(repository, "HEAD", iterator);
        newIndexDiff.diff((ProgressMonitor)jgitMonitor, 0, 0, jobName);
        return new IndexDiffData(newIndexDiff);
    }

    private String getReloadJobName() {
        return MessageFormat.format(CoreText.IndexDiffCacheEntry_reindexing, this.repositoryName);
    }

    private String getUpdateJobName() {
        return MessageFormat.format(CoreText.IndexDiffCacheEntry_reindexingIncrementally, this.repositoryName);
    }

    private void createResourceChangeListener() {
        this.resourceChangeListener = new IResourceChangeListener(){
            private final Map<IProject, IPath> deletedProjects = new HashMap<IProject, IPath>();

            public void resourceChanged(IResourceChangeEvent event) {
                Repository repository;
                if (event.getDelta() != null) {
                    SkipNotInterestingDeltaVisitor skipNotInterestingVisitor = new SkipNotInterestingDeltaVisitor();
                    try {
                        event.getDelta().accept((IResourceDeltaVisitor)skipNotInterestingVisitor);
                        if (!skipNotInterestingVisitor.hasAtLeastOneInterestingDelta()) {
                            return;
                        }
                    }
                    catch (CoreException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
                if ((repository = IndexDiffCacheEntry.this.getRepository()) == null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                    IndexDiffCacheEntry.this.resourceChangeListener = null;
                    return;
                }
                if (event.getType() == 4) {
                    IPath repoPath;
                    IPath projectPath;
                    IResource resource = event.getResource();
                    if (resource.getType() == 4 && (projectPath = resource.getLocation()) != null && (repoPath = ResourceUtil.getRepositoryRelativePath(projectPath, repository)) != null) {
                        this.deletedProjects.put((IProject)resource, projectPath);
                    }
                    return;
                }
                GitResourceDeltaVisitor visitor = new GitResourceDeltaVisitor(repository, this.deletedProjects);
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    Activator.logError(e.getMessage(), e);
                    return;
                }
                if (visitor.getGitIgnoreChanged()) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("A .gitignore changed");
                } else if (visitor.isProjectDeleted()) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("A project was deleted");
                } else if (IndexDiffCacheEntry.this.indexDiffData == null) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("Resource changed, no diff available");
                } else {
                    Collection<String> filesToUpdate = visitor.getFilesToUpdate();
                    Collection<IResource> resourcesToUpdate = visitor.getResourcesToUpdate();
                    if (!filesToUpdate.isEmpty()) {
                        IndexDiffCacheEntry.this.scheduleUpdateJob(filesToUpdate, resourcesToUpdate);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 5);
    }

    protected IndexDiffUpdateJob getUpdateJob() {
        return this.updateJob;
    }

    public void dispose() {
        for (ListenerHandle h : this.listenerHandles) {
            h.remove();
        }
        this.listenerHandles.clear();
        this.submodules.clear();
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        this.listeners.clear();
        if (this.reloadJob != null) {
            this.reloadJob.cancel();
            this.reloadJob = null;
        }
        if (this.updateJob != null) {
            this.updateJob.cleanupAndCancel();
            this.updateJob = null;
        }
        this.indexDiffData = null;
        this.lastIndex = null;
    }
}

