/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker;

import java.util.Collection;
import org.polarsys.capella.core.model.links.helpers.LinkInfo;

public class FastLinkerState {
    protected Collection firstElement;
    protected Collection secondElement;
    protected Collection pinnedElement;
    protected LinkInfo linkCreated;

    protected FastLinkerState() {
        this.firstElement = null;
        this.secondElement = null;
        this.pinnedElement = null;
        this.linkCreated = null;
    }

    protected FastLinkerState(Collection firstElement, Collection secondElement, Collection pinnedElement) {
        this.firstElement = firstElement;
        this.secondElement = secondElement;
        if (pinnedElement == null || firstElement == pinnedElement || secondElement == pinnedElement) {
            this.pinnedElement = pinnedElement;
        }
        this.linkCreated = null;
    }

    protected void clear() {
        this.firstElement = null;
        this.secondElement = null;
        this.pinnedElement = null;
        this.linkCreated = null;
    }

    protected FastLinkerState getPreviewState(Collection elementToPut) {
        FastLinkerState previewState = new FastLinkerState(this.firstElement, this.secondElement, this.pinnedElement);
        return previewState.updateState(elementToPut);
    }

    protected FastLinkerState updateState(Collection elementToPut) {
        if (this.firstElement == null) {
            this.firstElement = elementToPut;
        } else if (this.secondElement == null) {
            this.secondElement = elementToPut;
        } else if (this.pinnedElement == null) {
            this.firstElement = elementToPut;
            this.secondElement = null;
        } else if (this.firstElement == this.pinnedElement) {
            this.secondElement = elementToPut;
        } else if (this.secondElement == this.pinnedElement) {
            this.firstElement = elementToPut;
        }
        this.linkCreated = null;
        return this;
    }

    protected FastLinkerState updateState(Collection firstElement, Collection secondElement, Collection pinnedElement) {
        this.firstElement = firstElement;
        this.secondElement = secondElement;
        this.pinnedElement = pinnedElement;
        return this;
    }

    public void setLinkCreated(LinkInfo linkCreated) {
        this.linkCreated = linkCreated;
    }

    public LinkInfo getLinkCreated() {
        return this.linkCreated;
    }

    public Collection getPinnedElement() {
        return this.pinnedElement;
    }

    public Collection getFirstElement() {
        return this.firstElement;
    }

    public Collection getSecondElement() {
        return this.secondElement;
    }

    protected void pinModelElement(Collection elementToPin) {
        if (elementToPin == null || this.pinnedElement == elementToPin || elementToPin.isEmpty()) {
            this.pinnedElement = null;
        } else if (this.firstElement == elementToPin || this.secondElement == elementToPin) {
            this.pinnedElement = elementToPin;
        }
    }
}

