/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.cache.FunctionalChainCache;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractCacheAwareRefreshExtension;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;

public class DataFlowBlankRefreshExtension
extends AbstractCacheAwareRefreshExtension {
    @Override
    public void beforeRefresh(DDiagram diagram) {
        super.beforeRefresh(diagram);
        FunctionalChainCache.getInstance().reset();
        DDiagramContents context = FaServices.getFaServices().getDDiagramContents(diagram);
        try {
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
            List contextualElements = ContextualDiagramHelper.getService().getContextualElements(descriptor);
            FaServices.getFaServices().showDFContextualElements(context, contextualElements);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnContextualElements, (Throwable)e);
        }
        try {
            this.updateFunctionalExchangeCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFECategories, (Throwable)e);
        }
        try {
            context.commitDeferredActions();
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnCommitDeferredActions, (Throwable)e);
        }
        try {
            FaServices.getFaServices().reorderFAElements(diagram);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnReordering, (Throwable)e);
        }
    }

    @Override
    public void postRefresh(DDiagram diagram) {
        try {
            FunctionalChainServices.getFunctionalChainServices().updateFunctionalChainStyles(diagram);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFunctionalChainStyle, (Throwable)e);
        }
        FunctionalChainCache.getInstance().reset();
        super.postRefresh(diagram);
    }

    protected void updateFunctionalExchangeCategories(DDiagramContents diagramContents) {
        EdgeMapping edgeMapping;
        DDiagram diagram = diagramContents.getDDiagram();
        if (diagram.isSynchronized() && (edgeMapping = FaServices.getFaServices().getMappingFECategory(diagram)) != null) {
            HashSet<ExchangeCategory> categories = new HashSet<ExchangeCategory>();
            for (DDiagramElement element : diagramContents.getDiagramElements((DiagramElementMapping)edgeMapping)) {
                EObject target = element.getTarget();
                if (!(target instanceof ExchangeCategory)) continue;
                categories.add((ExchangeCategory)target);
            }
            FaServices.getFaServices().switchFECategories(diagramContents, (DSemanticDecorator)diagram, categories, false);
        }
    }
}

