/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.queries.csServices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.ExtendingQuery;
import org.polarsys.capella.common.queries.exceptions.QueryException;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.filters.MultiFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.queries.QueryExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveActorsFilter;
import org.polarsys.capella.core.sirius.analysis.queries.csServices.GetIBShowHideComponent;

@ExtendingQuery(extendingQuery=GetIBShowHideComponent.class)
public class GetIBShowHideComponent__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) throws QueryException {
        ArrayList<Component> result = new ArrayList<Component>();
        EObject target = this.getIBTarget((DSemanticDecorator)input);
        IModel currentProject = ILibraryManager.INSTANCE.getModel(target);
        Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
        for (IModel library : libraries) {
            EObject correspondingInput = QueryExt.getCorrespondingElementInLibrary((EObject)target, (CapellaModel)((CapellaModel)library));
            List components = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_COMPONENTS, (Object)correspondingInput, (IQueryContext)context);
            result.addAll(components);
        }
        return this.filter(result).stream().filter((? super T c) -> !c.getRepresentingParts().isEmpty()).collect(Collectors.toList());
    }

    protected List<Component> filter(List<Component> result) {
        return QueryInterpretor.executeFilter(result, (IQueryFilter)new MultiFilter(new IQueryFilter[]{new RemoveActorsFilter()}));
    }

    private EObject getIBTarget(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (element.getTarget() != decorator.getTarget()) continue;
                return this.getParentContainer(decorator.getTarget());
            }
            return decorator.getTarget();
        }
        return decorator.getTarget();
    }

    private EObject getParentContainer(EObject current) {
        EObject object = current;
        object = current.eContainer();
        while (object != null) {
            if (object instanceof Component || object instanceof BlockArchitecture) {
                return object;
            }
            object = object.eContainer();
        }
        return null;
    }
}

