/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.queries.csServices;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;

public abstract class GetABInsertComponentActor
extends AbstractQuery {
    Predicate<Component> getCanBeMovedIntoPredicate(Object target) {
        if (target instanceof Component) {
            return component -> ComponentExt.canMoveInto((Component)component, (Component)((Component)target));
        }
        if (target instanceof ComponentPkg) {
            return component -> ComponentPkgExt.canMoveInto((Component)component, (ComponentPkg)((ComponentPkg)target));
        }
        return component -> false;
    }

    protected List<Component> getComponentsToInsertFromArchitecture(Object input, BlockArchitecture architecture) {
        return BlockArchitectureExt.getAllComponents((BlockArchitecture)architecture).stream().filter(component -> !ComponentExt.isActor((Component)component)).filter(this.getCanBeMovedIntoPredicate(input)).collect(Collectors.toList());
    }

    protected List<Component> getActorsToInsertFromArchitecture(Object input, BlockArchitecture architecture) {
        return BlockArchitectureExt.getAllComponents((BlockArchitecture)architecture).stream().filter(ComponentExt::isActor).filter(this.getCanBeMovedIntoPredicate(input)).collect(Collectors.toList());
    }
}

