/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.constants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;

public class MappingConstantsHelper {
    public static String getMappingABAbstractFunction(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_PhysicalFunction";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB Logical Function";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA System Function";
        } else if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB_Activity";
        } else if (MappingConstantsHelper.equals(description, "Operational Role Blank")) {
            mappingName = "ORB_OAAllocation";
        }
        return mappingName;
    }

    public static String getMappingFunctionalExchangeCategoryOutputPin(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA_OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB OutputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB OutputPin by Categorie";
        }
        return mappingName;
    }

    public static String getMappingFunctionalExchangeCategoryInputPin(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA_InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB InputPin by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB InputPin by Categorie";
        }
        return mappingName;
    }

    public static String getMappingFunctionalExchangeCategory(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_Exchange by Categorie";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_Exchange by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_Exchange by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_Exchange by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_Exchange by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_Exchange by Categorie";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA DataFlow by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_FunctionExchange by Categorie";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB DataFlow by Categorie";
        }
        return mappingName;
    }

    public static String getMappingABFunctionPort(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_Pin";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB Flow Port on Logical Function";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA Flow Port on System Function";
        }
        return mappingName;
    }

    public static String getMappingABFunctionalExchange(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_FunctionExchange";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB DataFlow between Function";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA DataFlow between Function";
        } else if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB Interaction";
        } else if (MappingConstantsHelper.equals(description, "Operational Role Blank")) {
            mappingName = "ORB Interaction";
        }
        return mappingName;
    }

    public static String getMappingABComponentPortAllocation(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_ComponentPortAllocation";
        }
        return mappingName;
    }

    public static String getMappingABPortAllocation(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA PortRealization FunctionPort to ComponentPort";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB PortRealization FlowPort to ComponentPort";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB PortRealization";
        }
        return mappingName;
    }

    public static String getMappingABConnection(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_Exchange";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB DataFlow between Logical Components";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA Data Flow Between Actors and System";
        } else if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB_CommunicationMean";
        } else if (MappingConstantsHelper.equals(description, "Contextual Component Internal Interfaces")) {
            mappingName = "CCII_Connection";
        } else if (MappingConstantsHelper.equals(description, "Interfaces Diagram Blank")) {
            mappingName = "IDB_Connection";
        } else if (MappingConstantsHelper.equals(description, "Operational Capabilities Blank")) {
            mappingName = "COC_CommunicationMeans";
        }
        return mappingName;
    }

    public static String getMappingABPhysicalLink(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "SAB_PhysicalLink";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_PhysicalLink";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_PhysicalLink";
        }
        return mappingName;
    }

    public static String getMappingABPhysicalPort(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "SAB_PhysicalPort";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_PhysicalPort";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_Port";
        }
        return mappingName;
    }

    public static String getMappingABComponentPort(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_Port";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB ComponentPort";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA Component Port";
        } else if (MappingConstantsHelper.equals(description, "Contextual Component Internal Interfaces")) {
            mappingName = "CCII_Port";
        } else if (MappingConstantsHelper.equals(description, "Interfaces Diagram Blank")) {
            mappingName = "IDB_Port";
        }
        return mappingName;
    }

    public static String getMappingDFFunctionalExchange(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_Exchange";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_Exchange";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_Exchange";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_Exchange";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_Exchange";
        } else if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_Exchange";
        } else if (MappingConstantsHelper.equals(description, "Contextual Operational Activity Interaction")) {
            mappingName = "OAI Interaction";
        } else if (MappingConstantsHelper.equals(description, "Operational Activity Interaction Blank")) {
            mappingName = "OAIB Interaction";
        } else if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB Interaction";
        } else if (MappingConstantsHelper.equals(description, "Operational Role Blank")) {
            mappingName = "ORB Interaction";
        }
        return mappingName;
    }

    public static String getMappingDFFunctionPort(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_Pin";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_Pin";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_Pin";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_Pin";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_Pin";
        } else if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_Pin";
        }
        return mappingName;
    }

    public static String getMappingDFFunction(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_Function";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_Function";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_Function";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_Function";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_Function";
        } else if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_Function";
        } else if (MappingConstantsHelper.equals(description, "Operational Activity Interaction Blank")) {
            mappingName = "OAIB Operational Activity";
        } else if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB_Activity";
        }
        return mappingName;
    }

    public static String getMappingFunctionalChainEnd(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Operational Activity Interaction Blank")) {
            mappingName = "OAIB_OperationalProcessEnd";
        }
        return mappingName;
    }

    public static String getMappingFunction(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABAbstractFunction(diagram);
        if (mappingName == null) {
            mappingName = MappingConstantsHelper.getMappingDFFunction(diagram);
        }
        return mappingName;
    }

    public static String getMappingFunctionPort(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABFunctionPort(diagram);
        if (mappingName == null) {
            mappingName = MappingConstantsHelper.getMappingDFFunctionPort(diagram);
        }
        return mappingName;
    }

    public static String getMappingFunctionalExchange(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABFunctionalExchange(diagram);
        if (mappingName == null) {
            mappingName = MappingConstantsHelper.getMappingDFFunctionalExchange(diagram);
        }
        return mappingName;
    }

    public static String getMappingABComponentCategory(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB_ComponentCategory";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "SAB_ComponentCategory";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_ComponentCategory";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_ComponentCategory";
        }
        return mappingName;
    }

    public static String getMappingABPhysicalCategory(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_PhysicalCategory";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_PhysicalCategory";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "SAB_PhysicalCategory";
        }
        return mappingName;
    }

    public static String getMappingABComponentCategoryPin(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_ComponentCategory_Pin";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_ComponentCategory_Pin";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "SAB_ComponentCategory_Pin";
        }
        return mappingName;
    }

    public static List<String> getMappingABPhysicalCategoryPin(DDiagram diagram) {
        ArrayList<String> mappingNames = new ArrayList<String>();
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingNames.add("PAB_PhysicalCategory_Pin");
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingNames.add("LAB_PhysicalCategory_Pin");
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingNames.add("SAB_PhysicalCategory_Pin");
        }
        return mappingNames;
    }

    public static String getMappingABPhysicalCategoryPin(DDiagram diagram, EObject semantic) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "SAB_PhysicalCategory_Pin";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_PhysicalCategory_Pin";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_PhysicalCategory_Pin";
        }
        return mappingName;
    }

    public static String getMappingABFunctionalChain(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB_OperationalProcessEnd";
        }
        return mappingName;
    }

    public static String getMappingDFFunctionalChain(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Operational Activity Interaction Blank")) {
            mappingName = "OAIB_OperationalProcessEnd";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_FunctionalChainEnd";
        } else if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_FunctionalChainEnd";
        }
        return mappingName;
    }

    public static String getMappingABComponent(EObject eObject, DDiagram diagram) {
        EObject component = eObject;
        if (eObject != null && eObject instanceof Part) {
            component = CsServices.getService().getComponentType((Part)eObject);
        }
        String mappingName = null;
        if (component != null) {
            String description = diagram.getDescription().getName();
            if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
                mappingName = "PAB_PC";
            } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
                mappingName = "LAB Logical Component";
            } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
                mappingName = "System System";
                if (ComponentExt.isActor((EObject)component)) {
                    mappingName = "System Actors";
                }
            } else if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
                mappingName = "OAB_Entity1";
                if (ComponentExt.isActor((EObject)component)) {
                    mappingName = "OAB_Entity1";
                }
            }
        }
        return mappingName;
    }

    public static List<String> getMappingsABComponent(DDiagram diagram) {
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            return Arrays.asList("PAB_PC");
        }
        if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            return Arrays.asList("LAB Logical Component");
        }
        if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            return Arrays.asList("System System", "System Actors");
        }
        if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            return Arrays.asList("OAB_Entity1", "OAB_Entity1");
        }
        return Collections.emptyList();
    }

    public static String getMappingABRole(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Operational Entity Blank")) {
            mappingName = "OAB_subRoles";
        } else if (MappingConstantsHelper.equals(description, "Operational Role Blank")) {
            mappingName = "ORB_Role1";
        }
        return mappingName;
    }

    public static String getMappingABDeployedElement(DDiagram dDiagram) {
        String mappingName = "PAB_Deployment";
        return mappingName;
    }

    public static String getMappingSMStateMode(EObject state, DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Modes & States")) {
            mappingName = "SM_ModeState_Container";
        }
        return mappingName;
    }

    public static String getMappingSMInnerStateMode(EObject state, DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Modes & States")) {
            mappingName = "SM_InnerModeState_Container";
        }
        return mappingName;
    }

    public static String getMappingSMInnerPseudostate(EObject pseudoState, DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Modes & States")) {
            mappingName = "SM_InnerModeState";
        }
        return mappingName;
    }

    public static String getMappingSMPseudostate(EObject pseudoState, DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Modes & States")) {
            mappingName = "SM_ModeState";
        }
        return mappingName;
    }

    public static String getMappingSMTransition(EObject function_p, DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Modes & States")) {
            mappingName = "SM_Transition";
        }
        return mappingName;
    }

    public static String getMappingPhysicalPath(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_PhysicalPathEnd";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_PhysicalPathEnd";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "SAB_PhysicalPathEnd";
        }
        return mappingName;
    }

    public static String getMappingPhysicalPathInternLink(DDiagram diagram) {
        String mappingName = null;
        if ("Physical Architecture Blank".equals(diagram.getDescription().getName())) {
            mappingName = "PAB_InternPhysicalPathLink";
        } else if ("System Architecture Blank".equals(diagram.getDescription().getName())) {
            mappingName = "SAB_InternPhysicalPathLink";
        } else if ("Logical Architecture Blank".equals(diagram.getDescription().getName())) {
            mappingName = "LAB_InternPhysicalPathLink";
        }
        return mappingName;
    }

    public static String getInternLinkEdgeMapping(DDiagram diagram) {
        String mappingName = null;
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Logical Data Flow Blank")) {
            mappingName = "LDFB_InternLink";
        } else if (MappingConstantsHelper.equals(description, "Contextual Logical Data Flow")) {
            mappingName = "LDF_InternLink";
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingName = "LAB_InternLink";
        } else if (MappingConstantsHelper.equals(description, "Physical Data Flow Blank")) {
            mappingName = "PDFB_InternLink";
        } else if (MappingConstantsHelper.equals(description, "Contextual Physical Data Flow")) {
            mappingName = "PDF_InternLink";
        } else if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingName = "PAB_InternLink";
        } else if (MappingConstantsHelper.equals(description, "System Data Flow Blank")) {
            mappingName = "SDFB_InternLink";
        } else if (MappingConstantsHelper.equals(description, "Contextual System Data Flow")) {
            mappingName = "SDF_InternLink";
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingName = "CA_InternLink";
        }
        return mappingName;
    }

    public static List<String> getMappingABPorts(DDiagram diagram) {
        ArrayList<String> mappingNames = new ArrayList<String>();
        String description = diagram.getDescription().getName();
        if (MappingConstantsHelper.equals(description, "Physical Architecture Blank")) {
            mappingNames.add("PAB_Port");
        } else if (MappingConstantsHelper.equals(description, "Logical Architecture Blank")) {
            mappingNames.add("LAB ComponentPort");
            mappingNames.add("LAB_PhysicalPort");
        } else if (MappingConstantsHelper.equals(description, "System Architecture Blank")) {
            mappingNames.add("CA Component Port");
            mappingNames.add("SAB_PhysicalPort");
        } else if (MappingConstantsHelper.equals(description, "Contextual Component Internal Interfaces")) {
            mappingNames.add("CCII_Port");
        } else if (MappingConstantsHelper.equals(description, "Interfaces Diagram Blank")) {
            mappingNames.add("IDB_Port");
        }
        return mappingNames;
    }

    public static String getMappingCapability(EObject eObj, DDiagram diagram) {
        EClass eClass = eObj.eClass();
        if ("Missions Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return "ActorNode4";
            }
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return "CapabilityNode4";
            }
            if (CtxPackage.Literals.MISSION.isSuperTypeOf(eClass)) {
                return "MissionNode4";
            }
        } else if ("Missions Blank".equals(diagram.getDescription().getName())) {
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return "ActorNode2";
            }
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return "CapNode2";
            }
            if (CtxPackage.Literals.MISSION.isSuperTypeOf(eClass)) {
                return "MissionNode2";
            }
        } else if ("Contextual Capability".equals(diagram.getDescription().getName())) {
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return "ActorNode3";
            }
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return "Capability3";
            }
            if (CtxPackage.Literals.MISSION.isSuperTypeOf(eClass)) {
                return "MissionNode3";
            }
        } else if ("Contextual Mission".equals(diagram.getDescription().getName())) {
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return "ActorNode";
            }
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return "CapNode";
            }
        } else if ("Contextual Operational Capability".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return "COC2_OperationalCapabilities";
            }
            if (OaPackage.Literals.ENTITY.isSuperTypeOf(eClass)) {
                return "COC2_Entities";
            }
        } else if ("Operational Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return "COC_OperationalCapabilities";
            }
            if (OaPackage.Literals.ENTITY.isSuperTypeOf(eClass)) {
                return "COC_OperationalEntities";
            }
        } else if ("Capability Realization Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return "CRB CapabilityRealization";
            }
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return "CRB Component";
            }
        } else if ("Contextual Capability Realization Involvement".equals(diagram.getDescription().getName())) {
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return "CCRI Component";
            }
            if (LaPackage.Literals.CAPABILITY_REALIZATION.isSuperTypeOf(eClass)) {
                return "CCRI CapabilityRealization";
            }
        }
        return null;
    }

    private static boolean equals(String s1, String s2) {
        return s1 != null && s2 != null && s1.hashCode() == s2.hashCode() && s1.equals(s2);
    }
}

