/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.accelerators;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class SelectOrCreateFunctionalExchangeDialog
extends SelectElementsDialog {
    public static final int CREATION = 5;
    public static final int SELECTION = 10;
    Button creationChecker;
    boolean creationChecked;
    Text feNameInputText;
    Button sourceBrowseButton;
    Button targetBrowseButton;
    Set<FunctionalExchange> availableFCILinks;
    Set<AbstractFunction> availableFCIFunctions;
    AbstractFunction newFESource;
    AbstractFunction newFETarget;
    String newFEName = "";
    Shell parentShell;
    Set<AbstractFunction> availableSourceFunctions;
    Set<AbstractFunction> availableTargetFunctions;

    public SelectOrCreateFunctionalExchangeDialog(Shell parentShell, Set<FunctionalExchange> availableFEs, Set<AbstractFunction> availableSourceFunctions, Set<AbstractFunction> availableTargetFunctions) {
        super(parentShell, "Select or create Functional Exchange", "Select or create Functional Exchange", availableFEs);
        this.availableFCILinks = availableFEs;
        this.availableFCIFunctions = availableSourceFunctions;
        this.parentShell = parentShell;
        this.availableSourceFunctions = availableSourceFunctions;
        this.availableTargetFunctions = availableTargetFunctions;
    }

    protected void okPressed() {
        super.okPressed();
        int returnCode = super.getReturnCode();
        if (returnCode == 0) {
            if (this.creationChecked) {
                this.setReturnCode(5);
            } else {
                this.setReturnCode(10);
            }
        }
    }

    protected void doCreateDialogArea(Composite parent) {
        this.createCreationForm(parent);
        super.doCreateDialogArea(parent);
    }

    public void createCreationForm(Composite parent) {
        Group creationGroup = new Group(parent, 0);
        creationGroup.setText("Create a new Functional Exchange");
        creationGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        creationGroup.setLayout((Layout)new GridLayout(3, false));
        this.creationChecker = new Button((Composite)creationGroup, 32);
        this.creationChecker.setText("Create a new Functional Exchange");
        this.creationChecker.setLayoutData((Object)new GridData(4, 1, true, false, 4, 1));
        this.creationChecker.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectOrCreateFunctionalExchangeDialog.this.handleCreationChecker();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectOrCreateFunctionalExchangeDialog.this.handleCreationChecker();
            }
        });
        this.creationChecker.setSelection(false);
        Label feNameLabel = new Label((Composite)creationGroup, 0);
        feNameLabel.setText("Name of Functional Exchange");
        feNameLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        this.feNameInputText = new Text((Composite)creationGroup, 2052);
        this.feNameInputText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.feNameInputText.setEnabled(false);
        this.feNameInputText.addModifyListener(e -> {
            this.newFEName = this.feNameInputText.getText();
            this.updateOKButton();
        });
        final String labelTextForSourceFunction = "Select Function as source";
        this.createFunctionLabel(creationGroup, labelTextForSourceFunction);
        final Text sourceInputText = this.createFunctionInputText(creationGroup);
        this.sourceBrowseButton = this.createFunctionBrowseButton(creationGroup);
        this.sourceBrowseButton.addSelectionListener(new SelectionListener(){

            private void update() {
                SelectOrCreateFunctionalExchangeDialog.this.newFESource = SelectOrCreateFunctionalExchangeDialog.this.selectAbstractFunction(SelectOrCreateFunctionalExchangeDialog.this.availableSourceFunctions, labelTextForSourceFunction);
                sourceInputText.setText(SelectOrCreateFunctionalExchangeDialog.this.getLabelProvider().getText((Object)SelectOrCreateFunctionalExchangeDialog.this.newFESource));
                SelectOrCreateFunctionalExchangeDialog.this.updateOKButton();
            }

            public void widgetSelected(SelectionEvent e) {
                this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.update();
            }
        });
        final String labelTextForTargetFunction = "Select Function as target";
        this.createFunctionLabel(creationGroup, labelTextForTargetFunction);
        final Text targetInputText = this.createFunctionInputText(creationGroup);
        this.targetBrowseButton = this.createFunctionBrowseButton(creationGroup);
        this.targetBrowseButton.addSelectionListener(new SelectionListener(){

            private void update() {
                SelectOrCreateFunctionalExchangeDialog.this.newFETarget = SelectOrCreateFunctionalExchangeDialog.this.selectAbstractFunction(SelectOrCreateFunctionalExchangeDialog.this.availableTargetFunctions, labelTextForTargetFunction);
                targetInputText.setText(SelectOrCreateFunctionalExchangeDialog.this.getLabelProvider().getText((Object)SelectOrCreateFunctionalExchangeDialog.this.newFETarget));
                SelectOrCreateFunctionalExchangeDialog.this.updateOKButton();
            }

            public void widgetSelected(SelectionEvent e) {
                this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.update();
            }
        });
    }

    private AbstractFunction selectAbstractFunction(Set<AbstractFunction> availableSourceFunctions2, String mesage) {
        EObject selectedElement;
        SelectElementsDialog dialog = new SelectElementsDialog(this.parentShell, "Select a Function", mesage, availableSourceFunctions2);
        if (dialog.open() == 0 && (selectedElement = (EObject)dialog.getResult().stream().findFirst().orElse(null)) instanceof AbstractFunction) {
            return (AbstractFunction)selectedElement;
        }
        return null;
    }

    private Button createFunctionBrowseButton(Group creationGroup) {
        Button browseButton = new Button((Composite)creationGroup, 8);
        browseButton.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.browse"));
        browseButton.setEnabled(false);
        return browseButton;
    }

    private Text createFunctionInputText(Group creationGroup) {
        Text inputText = new Text((Composite)creationGroup, 2052);
        inputText.setLayoutData((Object)new GridData(4, 1, true, false));
        inputText.setEnabled(false);
        return inputText;
    }

    private Label createFunctionLabel(Group creationGroup, String labelText) {
        Label label = new Label((Composite)creationGroup, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        return label;
    }

    protected void handleCreationChecker() {
        this.creationChecked = this.creationChecker.getSelection();
        this.getViewer().setEnabled(!this.creationChecked);
        this.feNameInputText.setEnabled(this.creationChecked);
        this.sourceBrowseButton.setEnabled(this.creationChecked);
        this.targetBrowseButton.setEnabled(this.creationChecked);
        this.updateOKButton();
    }

    public NewFEData getCreation() {
        return new NewFEData(this.newFEName, this.newFESource, this.newFETarget);
    }

    public List<FunctionalExchange> getSelection() {
        return this.getResult().stream().map(FunctionalExchange.class::cast).collect(Collectors.toList());
    }

    private void updateOKButton() {
        Button okButton = this.getButton(0);
        if (this.creationChecked) {
            boolean creationDataFullfilled = !this.newFEName.isEmpty();
            creationDataFullfilled &= this.newFESource != null;
            okButton.setEnabled(creationDataFullfilled &= this.newFETarget != null);
        } else {
            boolean selectionDataFullfilled = this.getResult() != null && !this.getResult().isEmpty();
            okButton.setEnabled(selectionDataFullfilled);
        }
    }

    public class NewFEData {
        String name;
        AbstractFunction source;
        AbstractFunction target;

        public NewFEData(String name, AbstractFunction source, AbstractFunction target) {
            this.name = name;
            this.source = source;
            this.target = target;
        }

        public String getName() {
            return this.name;
        }

        public AbstractFunction getSource() {
            return this.source;
        }

        public AbstractFunction getTarget() {
            return this.target;
        }
    }
}

