/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.data.oa.RolePkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.OperationalAnalysisExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.sequencediag.ScenarioService;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;

public class OAServices {
    private static OAServices _service;

    public static OAServices getService() {
        if (_service == null) {
            _service = new OAServices();
        }
        return _service;
    }

    public List<EObject> getOEBScopeBreakdown(EObject eObject) {
        ArrayList<Entity> roots = new ArrayList<Entity>();
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (eObject instanceof Entity) {
            roots.add((Entity)eObject);
        } else if (eObject instanceof EntityPkg) {
            roots.addAll((Collection<Entity>)((EntityPkg)eObject).getOwnedEntities());
        }
        for (Entity entity : roots) {
            if (entity.getRepresentingParts().size() > 0 && !result.contains(entity)) {
                result.add((EObject)entity);
            }
            for (Component pe : CapellaServices.getService().getAllDescendants((Component)entity)) {
                if (result.contains(pe)) continue;
                result.add((EObject)pe);
            }
        }
        return result;
    }

    public EObject getOEBTarget(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (element.getTarget() != decorator.getTarget()) continue;
                EObject target = CsServices.getService().getParentContainer(decorator.getTarget());
                if (target instanceof BlockArchitecture) {
                    return BlockArchitectureExt.getContext((BlockArchitecture)((BlockArchitecture)target));
                }
                return target;
            }
            return decorator.getTarget();
        }
        return decorator.getTarget();
    }

    public RolePkg getRootRolePkg(EObject object) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)object);
        if (architecture instanceof OperationalAnalysis) {
            OperationalAnalysis analysis = (OperationalAnalysis)architecture;
            if (analysis.getOwnedRolePkg() == null) {
                RolePkg pkg = OaFactory.eINSTANCE.createRolePkg("Roles");
                analysis.setOwnedRolePkg(pkg);
            }
            return analysis.getOwnedRolePkg();
        }
        return null;
    }

    public EntityPkg getRootEntityPkg(EObject object) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)object);
        if (architecture instanceof OperationalAnalysis) {
            OperationalAnalysis analysis = (OperationalAnalysis)architecture;
            if (analysis.getOwnedEntityPkg() == null) {
                EntityPkg pkg = OaFactory.eINSTANCE.createEntityPkg("Operational Entities");
                analysis.setOwnedEntityPkg(pkg);
            }
            return analysis.getOwnedEntityPkg();
        }
        return null;
    }

    public List<FunctionalExchange> getAllAvailableExchanges(EObject eObject) {
        ArrayList<FunctionalExchange> list = new ArrayList<FunctionalExchange>();
        if (eObject == null) {
            return list;
        }
        if (eObject instanceof OperationalActivity) {
            OperationalActivity oa = (OperationalActivity)eObject;
            list.addAll(this.getOutgoingAndIncomingExchanges((AbstractFunction)oa));
            List allAbstractFunctions = (List)ModelCache.getCache(FunctionExt::getAllAbstractFunctions, (Object)oa);
            for (AbstractFunction abstractFunction : allAbstractFunctions) {
                list.addAll(this.getOutgoingAndIncomingExchanges(abstractFunction));
            }
        }
        return list;
    }

    private List<FunctionalExchange> getOutgoingAndIncomingExchanges(AbstractFunction function) {
        ArrayList<FunctionalExchange> list = new ArrayList<FunctionalExchange>();
        EList incoming = function.getIncoming();
        for (ActivityEdge activityEdge : incoming) {
            if (!(activityEdge instanceof FunctionalExchange)) continue;
            list.add((FunctionalExchange)activityEdge);
        }
        EList outgoing = function.getOutgoing();
        for (ActivityEdge activityEdge2 : outgoing) {
            if (!(activityEdge2 instanceof FunctionalExchange)) continue;
            list.add((FunctionalExchange)activityEdge2);
        }
        return list;
    }

    public boolean isAllocatedRole(EObject context, EObject role, Entity container) {
        if (role == null || container == null || !(role instanceof Role)) {
            return false;
        }
        EList ownedRoleAllocations = container.getOwnedRoleAllocations();
        for (RoleAllocation roleAllocation : ownedRoleAllocations) {
            if (!roleAllocation.getRole().equals(role)) continue;
            return true;
        }
        return false;
    }

    public boolean isInOperationalAnalysis(EObject context) {
        return context instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)context));
    }

    public Collection<EObject> getOESScopeInsertEntitiesRoles(Scenario scenario) {
        ArrayList<EObject> roots = new ArrayList<EObject>();
        roots.addAll(new ScenarioService().getAllMultiInstanceRoleParts(scenario));
        BlockArchitecture analysis = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
        if (analysis instanceof OperationalAnalysis) {
            roots.addAll(OperationalAnalysisExt.getAllRoles((OperationalAnalysis)((OperationalAnalysis)analysis)));
        }
        return roots;
    }

    public boolean isAllocatedFunctionInRole(EObject context, OperationalActivity current, Role container) {
        if (current == null || container == null) {
            return false;
        }
        if (!FunctionExt.isLeaf((AbstractFunction)current)) {
            return false;
        }
        EList ownedActivityAllocations = container.getOwnedActivityAllocations();
        for (ActivityAllocation activityAllocation : ownedActivityAllocations) {
            if (!activityAllocation.getActivity().equals(current)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Collection<? extends Component> getAvailableEntitiesToInsert(DSemanticDecorator view) {
        return this.getOEBEntities(view);
    }

    public Collection<? extends Component> getOEBEntities(DSemanticDecorator view) {
        BlockArchitecture arch;
        EObject target = view.getTarget();
        Collection<Object> entities = Collections.emptyList();
        if (target instanceof Entity || target instanceof EntityPkg || target instanceof Entity && ((Component)target).isActor()) {
            target = this.getOEBTarget(view);
            if (target instanceof EntityPkg) {
                target = this.getRootEntityPkg((EObject)BlockArchitectureExt.getRootBlockArchitecture((EObject)target));
            } else if (target instanceof Entity && ((Component)target).isActor()) {
                target = target.eContainer();
            }
            if (target instanceof Entity) {
                entities = ComponentExt.getAllSubUsedComponents((Component)((Entity)target));
            } else if (target instanceof EntityPkg) {
                entities = new ArrayList(OperationalAnalysisExt.getAllEntity((EntityPkg)((EntityPkg)target)));
            }
        } else if ((target instanceof OperationalCapabilityPkg || target instanceof OperationalCapability) && (arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)target)) instanceof OperationalAnalysis) {
            OperationalAnalysis opAnalysis = (OperationalAnalysis)arch;
            EntityPkg pkg = opAnalysis.getOwnedEntityPkg();
            entities = new ArrayList(OperationalAnalysisExt.getAllEntity((EntityPkg)pkg));
        }
        return entities.stream().filter(c -> !c.getRepresentingParts().isEmpty()).collect(Collectors.toList());
    }

    public List<CommunicationMean> getAllCommunicationMeans(OperationalAnalysis arch) {
        return OperationalAnalysisExt.getAllCommunicationMeans((OperationalAnalysis)arch);
    }

    public EObject insertRemoveCommunicationMeans(DNodeContainer entityView, List<CommunicationMean> selectedComMeans) {
        HashSet<CommunicationMean> displayedComMeans = new HashSet<CommunicationMean>();
        HashSet incomingOutgoingEdges = new HashSet();
        HashMap<Entity, DNodeContainer> displayedEntities = new HashMap<Entity, DNodeContainer>();
        incomingOutgoingEdges.addAll(entityView.getIncomingEdges());
        incomingOutgoingEdges.addAll(entityView.getOutgoingEdges());
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)entityView);
        ContainerMapping entityMapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, "OAB_Entity1");
        EdgeMapping comMeanMapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, "OAB_CommunicationMean");
        for (AbstractDNode aContainer : diagram.getContainers()) {
            if (!(aContainer.getTarget() instanceof Entity)) continue;
            displayedEntities.put((Entity)aContainer.getTarget(), (DNodeContainer)aContainer);
        }
        for (DEdge anEdge : incomingOutgoingEdges) {
            if (!(anEdge.getTarget() instanceof CommunicationMean)) continue;
            if (!selectedComMeans.contains(anEdge.getTarget())) {
                DiagramServices.getDiagramServices().removeEdgeView(anEdge);
                continue;
            }
            displayedComMeans.add((CommunicationMean)anEdge.getTarget());
        }
        for (CommunicationMean aCommunicationMean : selectedComMeans) {
            if (displayedComMeans.contains(aCommunicationMean)) continue;
            DNodeContainer sourceView = (DNodeContainer)displayedEntities.get(aCommunicationMean.getSource());
            DNodeContainer targetView = (DNodeContainer)displayedEntities.get(aCommunicationMean.getTarget());
            if (sourceView == null) {
                sourceView = DiagramServices.getDiagramServices().createContainer(entityMapping, (EObject)aCommunicationMean.getSource(), (DragAndDropTarget)diagram, diagram);
                displayedEntities.put((Entity)aCommunicationMean.getSource(), sourceView);
            }
            if (targetView == null) {
                targetView = DiagramServices.getDiagramServices().createContainer(entityMapping, (EObject)aCommunicationMean.getTarget(), (DragAndDropTarget)diagram, diagram);
                displayedEntities.put((Entity)aCommunicationMean.getTarget(), targetView);
            }
            DiagramServices.getDiagramServices().createEdge(comMeanMapping, (EdgeTarget)sourceView, (EdgeTarget)targetView, (EObject)aCommunicationMean);
        }
        return entityView;
    }

    public EObject insertRemoveEntities(EObject view, List<Entity> selectedEntities) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(view);
        for (AbstractDNode aContainer : diagram.getContainers()) {
            if (!(aContainer.getTarget() instanceof Entity) || !(aContainer instanceof DNodeContainer)) continue;
            Entity currentEntity = (Entity)aContainer.getTarget();
            aContainer.setVisible(selectedEntities.contains(currentEntity));
        }
        return view;
    }

    public OperationalActivity getInteractionSourceInDiagram(FunctionalExchange interaction, DDiagram diagram) {
        OperationalActivity sourceOA;
        AbstractFunction sourceFunction = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)interaction);
        if (!(sourceFunction instanceof OperationalActivity)) {
            return null;
        }
        HashSet<OperationalActivity> displayedActivities = new HashSet<OperationalActivity>();
        for (DDiagramElement anElement : diagram.getDiagramElements()) {
            if (!(anElement.getTarget() instanceof OperationalActivity)) continue;
            displayedActivities.add((OperationalActivity)anElement.getTarget());
        }
        OperationalActivity parent = sourceOA = (OperationalActivity)sourceFunction;
        while (parent instanceof OperationalActivity) {
            if (displayedActivities.contains(parent)) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return sourceOA;
    }

    public OperationalActivity getInteractionTargetInDiagram(FunctionalExchange interaction, DDiagram diagram) {
        OperationalActivity targetOA;
        AbstractFunction targetFunction = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)interaction);
        if (!(targetFunction instanceof OperationalActivity)) {
            return null;
        }
        HashSet<OperationalActivity> displayedActivities = new HashSet<OperationalActivity>();
        for (DDiagramElement anElement : diagram.getDiagramElements()) {
            if (!(anElement.getTarget() instanceof OperationalActivity)) continue;
            displayedActivities.add((OperationalActivity)anElement.getTarget());
        }
        OperationalActivity parent = targetOA = (OperationalActivity)targetFunction;
        while (parent instanceof OperationalActivity) {
            if (displayedActivities.contains(parent)) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return targetOA;
    }

    public List<EObject> getAvailableOperationalActivityAllocations(Role role) {
        ArrayList<EObject> returnedList = new ArrayList<EObject>();
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(role.eClass(), (EStructuralFeature)OaPackage.Literals.ROLE__OWNED_ACTIVITY_ALLOCATIONS);
        if (query != null) {
            returnedList.addAll(query.getAvailableElements((EObject)role));
        }
        return returnedList;
    }

    @Deprecated
    public boolean isOAInternalValid(DSemanticDecorator containerView) {
        return !(containerView instanceof DDiagram);
    }

    @Deprecated
    public boolean isOARootValid(DSemanticDecorator containerView, EObject target) {
        DDiagram diagram;
        if (target instanceof AbstractNamedElement && "OA2".equals(((AbstractNamedElement)target).getName())) {
            System.out.println(0);
        }
        if ((diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView)) instanceof DSemanticDecorator && EcoreUtil.isAncestor((EObject)((DSemanticDecorator)diagram).getTarget(), (EObject)target)) {
            return target == ((DSemanticDecorator)diagram).getTarget();
        }
        return false;
    }

    @Deprecated
    public boolean isOARootValidA(DSemanticDecorator containerView, EObject target) {
        DDiagram diagram;
        if (target instanceof AbstractNamedElement && "OA2".equals(((AbstractNamedElement)target).getName())) {
            System.out.println(0);
        }
        if ((diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView)) instanceof DSemanticDecorator && EcoreUtil.isAncestor((EObject)((DSemanticDecorator)diagram).getTarget(), (EObject)target)) {
            return target == ((DSemanticDecorator)diagram).getTarget();
        }
        return true;
    }

    @Deprecated
    public List<Object> getAllOperationalCapabilities(CapellaElement element) {
        BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        if (!(arch instanceof OperationalAnalysis)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(OperationalAnalysisExt.getAllOperationalCapabilities((OperationalAnalysis)((OperationalAnalysis)arch)));
        return result;
    }

    public boolean hideAllocatedInteractions(EObject obj) {
        return obj instanceof FunctionalExchange && ((FunctionalExchange)obj).getAllocatingComponentExchanges().isEmpty();
    }

    public Collection<Part> getAllEntities(EObject any) {
        ArrayList<Part> parts = new ArrayList<Part>();
        OperationalAnalysis architecture = (OperationalAnalysis)EcoreUtil2.getFirstContainer((EObject)any, (EClass)OaPackage.Literals.OPERATIONAL_ANALYSIS);
        for (Entity entity : OperationalAnalysisExt.getAllEntity((OperationalAnalysis)architecture)) {
            parts.addAll((Collection<Part>)entity.getRepresentingParts());
        }
        return parts;
    }
}

