/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IViewSite;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AbstractTab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.Tab;

public class TabFactory {
    public static TabFactory INSTANCE = new TabFactory();

    public void createTab(String viewpointId, List<Tab> tabCollector, IViewSite site) {
        IConfigurationElement[] elts = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.ad.viewpoint.ui.viewpointview.tab");
        Arrays.sort(elts, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                int attribute2 = Integer.parseInt(o2.getAttribute("weight"));
                int attribute1 = Integer.parseInt(o1.getAttribute("weight"));
                return attribute2 - attribute1;
            }
        });
        IConfigurationElement[] iConfigurationElementArray = elts;
        int n = elts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            if (this.addTab(elt, viewpointId)) {
                try {
                    AbstractTab tab = (AbstractTab)elt.createExecutableExtension("class");
                    tab.setSite(site);
                    tab.setDesignOnly(Boolean.parseBoolean(elt.getAttribute("designOnly")));
                    tabCollector.add(tab);
                }
                catch (CoreException e) {
                    AD_Log.getDefault().logError((Throwable)e);
                }
            }
            ++n2;
        }
    }

    private boolean addTab(IConfigurationElement elt, String viewpointId) {
        String attribute = elt.getAttribute("targetViewpointIds");
        if (attribute == null) {
            return true;
        }
        if ("".equals(attribute = attribute.trim())) {
            return true;
        }
        String[] stringArray = attribute.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.trim().equals(viewpointId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

