/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiMethod;
import org.eclipse.pde.api.tools.internal.model.ApiType;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.model.StubArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;

public class TypeStructureBuilder
extends ClassVisitor {
    ApiType fType;
    IApiComponent fComponent;
    IApiTypeRoot fFile;

    TypeStructureBuilder(ClassVisitor cv, IApiComponent component, IApiTypeRoot file) {
        super(458752, cv);
        this.fComponent = component;
        this.fFile = file;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int laccess;
        StringBuilder simpleSig = new StringBuilder();
        simpleSig.append('L');
        simpleSig.append(name);
        simpleSig.append(';');
        String enclosingName = null;
        int index = name.lastIndexOf(36);
        if (index > -1) {
            enclosingName = name.substring(0, index).replace('/', '.');
        }
        if (((laccess = access) & 0x20000) != 0) {
            laccess &= 0xFFFDFFFF;
            laccess |= 0x100000;
        }
        this.fType = new ApiType(this.fComponent, name.replace('/', '.'), simpleSig.toString(), signature, laccess, enclosingName, this.fFile);
        if (superName != null) {
            this.fType.setSuperclassName(superName.replace('/', '.'));
        }
        if (interfaces != null && interfaces.length > 0) {
            String[] names = new String[interfaces.length];
            int i = 0;
            while (i < names.length) {
                names[i] = interfaces[i].replace('/', '.');
                ++i;
            }
            this.fType.setSuperInterfaceNames(names);
        }
        super.visit(version, laccess, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        String currentName = name.replace('/', '.');
        if (currentName.equals(this.fType.getName())) {
            if (innerName == null) {
                this.fType.setAnonymous();
            } else if (outerName == null) {
                this.fType.setLocal();
                this.fType.setSimpleName(innerName);
            }
        }
        if (outerName != null && innerName != null) {
            String currentOuterName = outerName.replace('/', '.');
            if (currentOuterName.equals(this.fType.getName())) {
                this.fType.addMemberType(currentName, access);
            } else if (currentName.equals(this.fType.getName())) {
                this.fType.setModifiers(access);
                this.fType.setSimpleName(innerName);
                this.fType.setMemberType();
            }
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.fType.setEnclosingMethodInfo(name, desc);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        int laccess = access;
        if ((access & 0x20000) != 0) {
            laccess &= 0xFFFDFFFF;
            laccess |= 0x100000;
        }
        this.fType.addField(name, desc, signature, laccess, value);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String[] names = null;
        int laccess = access;
        if ((laccess & 0x20000) != 0) {
            laccess &= 0xFFFDFFFF;
            laccess |= 0x100000;
        }
        if (exceptions != null && exceptions.length > 0) {
            names = new String[exceptions.length];
            int i = 0;
            while (i < names.length) {
                names[i] = exceptions[i].replace('/', '.');
                ++i;
            }
        }
        final ApiMethod method = this.fType.addMethod(name, desc, signature, laccess, names);
        return new MethodVisitor(458752, super.visitMethod(laccess, name, desc, signature, exceptions)){

            public AnnotationVisitor visitAnnotation(String sig, boolean visible) {
                if (visible && "Ljava/lang/invoke/MethodHandle$PolymorphicSignature;".equals(sig)) {
                    method.isPolymorphic();
                }
                return super.visitAnnotation(sig, visible);
            }

            public AnnotationVisitor visitAnnotationDefault() {
                return new AnnotationDefaultVisitor(method);
            }
        };
    }

    private static IApiType logAndReturn(IApiTypeRoot file, Exception e) {
        if (ApiPlugin.DEBUG_BUILDER) {
            Status status = new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)Messages.TypeStructureBuilder_badClassFileEncountered, (Object)file.getTypeName()), (Throwable)e);
            ApiPlugin.log((IStatus)status);
        }
        return null;
    }

    public static IApiType buildTypeStructure(byte[] bytes, IApiComponent component, IApiTypeRoot file) {
        TypeStructureBuilder visitor = new TypeStructureBuilder((ClassVisitor)new ClassNode(), component, file);
        try {
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)visitor, 5);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            TypeStructureBuilder.logAndReturn(file, e);
            return null;
        }
        catch (IllegalArgumentException iae) {
            return TypeStructureBuilder.logAndReturn(file, iae);
        }
        return visitor.fType;
    }

    public static void setEnclosingMethod(IApiType enclosingType, ApiType currentAnonymousLocalType) {
        IApiTypeRoot typeRoot = enclosingType.getTypeRoot();
        if (typeRoot instanceof AbstractApiTypeRoot) {
            AbstractApiTypeRoot abstractApiTypeRoot = (AbstractApiTypeRoot)typeRoot;
            EnclosingMethodSetter visitor = new EnclosingMethodSetter((ClassVisitor)new ClassNode(), currentAnonymousLocalType.getName());
            try {
                ClassReader classReader = new ClassReader(abstractApiTypeRoot.getContents());
                classReader.accept((ClassVisitor)visitor, 4);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ApiPlugin.log(e);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
            if (visitor.found) {
                currentAnonymousLocalType.setEnclosingMethodInfo(visitor.name, visitor.signature);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Type structure builder for: ").append(this.fType.getName());
        buffer.append("\nBacked by file: ").append(this.fFile.getName());
        return buffer.toString();
    }

    public static IApiType buildStubTypeStructure(byte[] contents, IApiComponent apiComponent, StubArchiveApiTypeContainer.ArchiveApiTypeRoot archiveApiTypeRoot) {
        ApiType type;
        block19: {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(contents));
            type = null;
            try {
                try {
                    int i;
                    short interfacesLength;
                    HashMap<Integer, String> pool = new HashMap<Integer, String>();
                    short currentVersion = inputStream.readShort();
                    int poolSize = inputStream.readShort();
                    int i2 = 0;
                    while (i2 < poolSize) {
                        String readUtf = inputStream.readUTF();
                        short index = inputStream.readShort();
                        pool.put(Integer.valueOf(index), readUtf);
                        ++i2;
                    }
                    char access = '\u0000';
                    if (currentVersion >= 2) {
                        access = inputStream.readChar();
                    }
                    short classIndex = inputStream.readShort();
                    String name = (String)pool.get(classIndex);
                    StringBuilder simpleSig = new StringBuilder();
                    simpleSig.append('L');
                    simpleSig.append(name);
                    simpleSig.append(';');
                    type = new ApiType(apiComponent, name.replace('/', '.'), simpleSig.toString(), null, access, null, archiveApiTypeRoot);
                    short superclassNameIndex = inputStream.readShort();
                    if (superclassNameIndex != -1) {
                        String superclassName = (String)pool.get(superclassNameIndex);
                        type.setSuperclassName(superclassName.replace('/', '.'));
                    }
                    if ((interfacesLength = inputStream.readShort()) != 0) {
                        String[] names = new String[interfacesLength];
                        i = 0;
                        while (i < names.length) {
                            String interfaceName = (String)pool.get(inputStream.readShort());
                            names[i] = interfaceName.replace('/', '.');
                            ++i;
                        }
                        type.setSuperInterfaceNames(names);
                    }
                    int fieldsLength = inputStream.readShort();
                    i = 0;
                    while (i < fieldsLength) {
                        String fieldName = (String)pool.get(inputStream.readShort());
                        type.addField(fieldName, null, null, 0, null);
                        ++i;
                    }
                    int methodsLength = inputStream.readShort();
                    int i3 = 0;
                    while (i3 < methodsLength) {
                        byte isPolymorphic = 0;
                        String methodSelector = (String)pool.get(inputStream.readShort());
                        String methodSignature = (String)pool.get(inputStream.readShort());
                        if (currentVersion == 3) {
                            isPolymorphic = inputStream.readByte();
                        }
                        type.addMethod(methodSelector, methodSignature, null, isPolymorphic == 1 ? 0x200000 : 0, null);
                        ++i3;
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return type;
    }

    static class AnnotationDefaultVisitor
    extends AnnotationVisitor {
        ApiMethod method;
        Object value;
        StringBuilder buff = new StringBuilder();
        boolean trace = false;
        int traceCount = 0;

        public AnnotationDefaultVisitor(ApiMethod method) {
            super(458752);
            this.method = method;
        }

        public void visit(String name, Object value) {
            if (this.trace) {
                this.appendValue(value);
                ++this.traceCount;
                return;
            }
            this.value = value;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.trace = true;
            return this;
        }

        public void visitEnum(String name, String desc, String value) {
            if (this.trace) {
                this.appendValue(value);
                ++this.traceCount;
                return;
            }
            this.value = value;
        }

        public AnnotationVisitor visitArray(String name) {
            this.trace = true;
            return this;
        }

        public void visitEnd() {
            if (this.trace) {
                this.value = this.buff.toString();
                --this.traceCount;
                this.trace = this.traceCount != 0;
            } else {
                this.method.setDefaultValue(this.value == null ? null : this.value.toString());
            }
        }

        void appendValue(Object val) {
            if (val != null) {
                if (this.buff.length() < 1) {
                    this.buff.append(val.toString());
                } else {
                    this.buff.append(',').append(val.toString());
                }
            }
        }
    }

    static class EnclosingMethodSetter
    extends ClassVisitor {
        String name;
        String signature;
        boolean found = false;
        String typeName;

        public EnclosingMethodSetter(ClassVisitor cv, String typeName) {
            super(458752, cv);
            this.typeName = typeName.replace('.', '/');
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<clinit>".equals(name)) {
                return null;
            }
            if (!this.found && (access & 0x500) == 0) {
                this.name = name;
                this.signature = desc;
                if (signature != null) {
                    this.signature = signature;
                }
                TypeNameFinder mv = "<init>".equals(name) ? new TypeNameFinderInConstructor(this.cv.visitMethod(access, name, desc, signature, exceptions), this) : new TypeNameFinder(this.cv.visitMethod(access, name, desc, signature, exceptions), this);
                return mv;
            }
            return null;
        }
    }

    static class TypeNameFinder
    extends MethodVisitor {
        protected EnclosingMethodSetter setter;

        public TypeNameFinder(MethodVisitor mv, EnclosingMethodSetter enclosingMethodSetter) {
            super(458752, mv);
            this.setter = enclosingMethodSetter;
        }

        public void visitTypeInsn(int opcode, String type) {
            if (this.setter.typeName.equals(type)) {
                this.setter.found = true;
            }
        }
    }

    static class TypeNameFinderInConstructor
    extends TypeNameFinder {
        int lineNumberStart;
        int matchingLineNumber;
        int currentLineNumber = -1;

        public TypeNameFinderInConstructor(MethodVisitor mv, EnclosingMethodSetter enclosingMethodSetter) {
            super(mv, enclosingMethodSetter);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            if (!this.setter.found && this.setter.typeName.equals(type)) {
                this.matchingLineNumber = this.currentLineNumber;
                this.setter.found = true;
            }
        }

        public void visitLineNumber(int line, Label start) {
            if (this.currentLineNumber == -1) {
                this.lineNumberStart = line;
            }
            this.currentLineNumber = line;
        }

        public void visitEnd() {
            if (this.setter.found && (this.matchingLineNumber < this.lineNumberStart || this.matchingLineNumber > this.currentLineNumber)) {
                this.setter.found = false;
            }
        }
    }
}

