/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.re2rpl.merge;

import java.util.ArrayList;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.constants.IReConstants;
import org.polarsys.capella.common.re.handlers.attributes.AttributesHandlerHelper;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.re.re2rpl.merge.Messages;
import org.polarsys.capella.core.transition.common.handlers.merge.CategoryFilter;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class SuffixedElementPropagationCategoryFilter
extends CategoryFilter {
    public SuffixedElementPropagationCategoryFilter(IContext context) {
        super(context, Messages.SuffixedElementPropagationCategoryFilter, Messages.SuffixedElementPropagationCategoryFilter_Description);
        this.setCategorySet("category.business");
        this.setInFocusMode(false);
        this.setActive(false);
        this.setVisible(true);
    }

    public boolean covers(IDifference difference) {
        String value = (String)this.context.get((Object)"COMMAND__CURRENT_VALUE");
        if (!"COMMAND__CREATE_A_REPLICA_FROM_REPLICABLE".equals(value) && !"COMMAND__UPDATE_A_REPLICA_FROM_REPLICABLE".equals(value)) {
            return false;
        }
        if (difference instanceof IAttributeValuePresence) {
            IAttributeValuePresence diff = (IAttributeValuePresence)difference;
            EObject sourceElement = diff.getElementMatch().get(Role.REFERENCE);
            EObject targetElement = diff.getElementMatch().get(Role.TARGET);
            if (sourceElement != null && targetElement != null) {
                EStructuralFeature feature = AttributesHandlerHelper.getInstance(this.context).getSuffixableFeature(targetElement, this.context);
                if (((IAttributeValuePresence)difference).getFeature() == null || !((IAttributeValuePresence)difference).getFeature().equals(feature)) {
                    return false;
                }
                CatalogElement source = ReplicableElementHandlerHelper.getInstance(this.context).getSource(this.context);
                CatalogElement target = ReplicableElementHandlerHelper.getInstance(this.context).getTarget(this.context);
                ArrayList links = new ArrayList();
                links.addAll(source.getOwnedLinks());
                links.addAll(target.getOwnedLinks());
                CatalogElementLink link = null;
                for (CatalogElementLink nlink : links) {
                    if (!targetElement.equals(nlink.getTarget())) continue;
                    link = nlink;
                }
                if (link != null && link.getOrigin().isSuffixed()) {
                    String name = (String)link.getTarget().eGet(feature);
                    String originalSuffix = (String)this.context.get(IReConstants.ORIGINAL_SUFFIX);
                    if (originalSuffix != null && !name.endsWith(originalSuffix)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

